/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TagInfoXpString
extends TagInfo {
    public TagInfoXpString(String name, int tag, TiffDirectoryType directoryType) {
        super(name, tag, AbstractFieldType.BYTE, -1, directoryType);
    }

    @Override
    public byte[] encodeValue(AbstractFieldType abstractFieldType, Object value, ByteOrder byteOrder) throws ImagingException {
        if (!(value instanceof String)) {
            throw new ImagingException("Text value not String", value);
        }
        String s = (String)value;
        byte[] bytes = s.getBytes(StandardCharsets.UTF_16LE);
        return Arrays.copyOf(bytes, bytes.length + 2);
    }

    @Override
    public String getValue(TiffField entry) throws ImagingException {
        if (entry.getFieldType() != AbstractFieldType.BYTE) {
            throw new ImagingException("Text field not encoded as bytes.");
        }
        byte[] bytes = entry.getByteArrayValue();
        int length = bytes.length >= 2 && bytes[bytes.length - 1] == 0 && bytes[bytes.length - 2] == 0 ? bytes.length - 2 : bytes.length;
        return new String(bytes, 0, length, StandardCharsets.UTF_16LE);
    }
}

