/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.access.LegacyDataDomainFlushAction;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;

@Deprecated
class DataDomainFlattenedBucket {
    final LegacyDataDomainFlushAction parent;
    final Map<DbEntity, List<FlattenedArcKey>> insertArcKeys;
    final Map<DbEntity, DeleteBatchQuery> flattenedDeleteQueries;

    DataDomainFlattenedBucket(LegacyDataDomainFlushAction parent) {
        this.parent = parent;
        this.insertArcKeys = new HashMap<DbEntity, List<FlattenedArcKey>>();
        this.flattenedDeleteQueries = new HashMap<DbEntity, DeleteBatchQuery>();
    }

    boolean isEmpty() {
        return this.insertArcKeys.isEmpty() && this.flattenedDeleteQueries.isEmpty();
    }

    void addInsertArcKey(DbEntity flattenedEntity, FlattenedArcKey flattenedArcKey) {
        List<FlattenedArcKey> arcKeys = this.insertArcKeys.get(flattenedEntity);
        if (arcKeys == null) {
            arcKeys = new ArrayList<FlattenedArcKey>();
            this.insertArcKeys.put(flattenedEntity, arcKeys);
        }
        arcKeys.add(flattenedArcKey);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        DataNode node;
        List flattenedSnapshots;
        DeleteBatchQuery relationDeleteQuery = this.flattenedDeleteQueries.get(flattenedEntity);
        if (relationDeleteQuery == null) {
            ArrayList<DbAttribute> pk = flattenedEntity.getPrimaryKeys();
            ArrayList<DbAttribute> pkList = pk instanceof List ? pk : new ArrayList<DbAttribute>(pk);
            relationDeleteQuery = new DeleteBatchQuery(flattenedEntity, pkList, Collections.emptySet(), 50);
            relationDeleteQuery.setUsingOptimisticLocking(false);
            this.flattenedDeleteQueries.put(flattenedEntity, relationDeleteQuery);
        }
        if (!(flattenedSnapshots = flattenedDeleteInfo.buildJoinSnapshotsForDelete(node = this.parent.getDomain().lookupDataNode(flattenedEntity.getDataMap()))).isEmpty()) {
            for (Map flattenedSnapshot : flattenedSnapshots) {
                relationDeleteQuery.add(flattenedSnapshot);
            }
        }
    }

    void appendInserts(Collection<Query> queries) {
        for (Map.Entry<DbEntity, List<FlattenedArcKey>> entry : this.insertArcKeys.entrySet()) {
            DbEntity dbEntity = entry.getKey();
            List<FlattenedArcKey> flattenedArcKeys = entry.getValue();
            DataNode node = this.parent.getDomain().lookupDataNode(dbEntity.getDataMap());
            InsertBatchQuery existingQuery = this.findInsertBatchQuery(queries, dbEntity);
            InsertBatchQuery newQuery = new InsertBatchQuery(dbEntity, 50);
            HashMap<ObjectId, Map<String, Object>> toOneSnapshots = new HashMap<ObjectId, Map<String, Object>>();
            ArrayList<Map<String, Object>> toManySnapshots = new ArrayList<Map<String, Object>>();
            for (FlattenedArcKey flattenedArcKey : flattenedArcKeys) {
                Map<String, Object> joinSnapshot = flattenedArcKey.buildJoinSnapshotForInsert(node);
                if (flattenedArcKey.relationship.isToMany()) {
                    toManySnapshots.add(joinSnapshot);
                    continue;
                }
                ObjectId objectId = flattenedArcKey.id1.getSourceId();
                Map snapshot = (Map)toOneSnapshots.get(objectId);
                if (snapshot == null) {
                    toOneSnapshots.put(objectId, joinSnapshot);
                    continue;
                }
                for (Map.Entry<String, Object> dbValue : joinSnapshot.entrySet()) {
                    snapshot.put(dbValue.getKey(), dbValue.getValue());
                }
            }
            for (Map.Entry entry2 : toOneSnapshots.entrySet()) {
                BatchQueryRow existingRow;
                ObjectId objectId = (ObjectId)entry2.getKey();
                Map snapshot = (Map)entry2.getValue();
                if (existingQuery != null && (existingRow = this.findRowForObjectId(existingQuery.getRows(), objectId)) != null) {
                    List<DbAttribute> existingQueryDbAttributes = existingQuery.getDbAttributes();
                    for (int i = 0; i < existingQueryDbAttributes.size(); ++i) {
                        Object value = existingRow.getValue(i);
                        if (value == null) continue;
                        snapshot.put(existingQueryDbAttributes.get(i).getName(), value);
                    }
                }
                newQuery.add(snapshot, objectId);
            }
            for (Map map : toManySnapshots) {
                newQuery.add(map);
            }
            if (existingQuery != null) {
                queries.remove(existingQuery);
            }
            queries.add(newQuery);
        }
    }

    void appendDeletes(Collection<Query> queries) {
        if (!this.flattenedDeleteQueries.isEmpty()) {
            queries.addAll(this.flattenedDeleteQueries.values());
        }
    }

    private InsertBatchQuery findInsertBatchQuery(Collection<Query> queries, DbEntity dbEntity) {
        for (Query query : queries) {
            InsertBatchQuery insertBatchQuery;
            if (!(query instanceof InsertBatchQuery) || !(insertBatchQuery = (InsertBatchQuery)query).getDbEntity().equals(dbEntity)) continue;
            return insertBatchQuery;
        }
        return null;
    }

    private BatchQueryRow findRowForObjectId(List<BatchQueryRow> rows, ObjectId objectId) {
        for (BatchQueryRow row : rows) {
            if (!row.getObjectId().equals(objectId)) continue;
            return row;
        }
        return null;
    }
}

