/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.core.metamodel.facets.object.projection.ident;

import java.util.function.BiConsumer;

import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.causeway.core.metamodel.facets.members.cssclass.CssClassFacetAbstract;
import org.apache.causeway.core.metamodel.facets.object.projection.ProjectionFacet;
import org.apache.causeway.core.metamodel.object.ManagedObject;

public class CssClassFacetFromProjectionFacet
extends CssClassFacetAbstract {

    private final ProjectionFacet projectionFacet;

    public CssClassFacetFromProjectionFacet(
            final ProjectionFacet projectionFacet,
            final FacetHolder holder) {
        super(holder);
        this.projectionFacet = projectionFacet;
    }

    @Override
    public String cssClass(final ManagedObject targetAdapter) {
        var projectedAdapter = projectionFacet.projected(targetAdapter);
        var cssClassFacet = projectedAdapter.objSpec().getFacet(CssClassFacet.class);
        return cssClassFacet != null
                ? cssClassFacet.cssClass(projectedAdapter)
                : null;
    }

    @Override
    public void visitAttributes(final BiConsumer<String, Object> visitor) {
        super.visitAttributes(visitor);
        visitor.accept("projectionFacet", projectionFacet.getClass().getName());
    }

}
