/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Options
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(Options.class);
    private static boolean DEBUG_ENABLED = log.isTraceEnabled();
    private static boolean DEBUG_PROPERTY_SET = false;
    private static final String myClassName = "Options";
    private String logCorrelationIDString = null;
    private static final long serialVersionUID = -8318751890845181507L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    public static String CUSTOM_REPLYTO_ADDRESS = "CUSTOM_REPLYTO_ADDRESS";
    public static String CUSTOM_REPLYTO_ADDRESS_TRUE = "true";
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 30000;
    private Options parent;
    private Map<String, Object> properties;
    private String soapVersionURI;
    private Boolean isExceptionToBeThrownOnSOAPFault;
    private long timeOutInMilliSeconds = -1L;
    private Boolean useSeparateListener;
    private String action;
    private EndpointReference faultTo;
    private EndpointReference from;
    private TransportListener listener;
    private TransportInDescription transportIn;
    private String transportInProtocol;
    private String messageId;
    private List<RelatesTo> relationships;
    private EndpointReference replyTo;
    private ArrayList<OMElement> referenceParameters;
    protected TransportOutDescription transportOut;
    private EndpointReference to;
    private boolean manageSession = false;
    private transient boolean needsToBeReconciled = false;
    private transient MetaDataEntry metaTransportOut = null;
    private transient MetaDataEntry metaTransportIn = null;
    private transient MetaDataEntry metaListener = null;
    private transient boolean callTransportCleanup;
    private transient String userName;
    private transient String password;

    public Options() {
    }

    public Options(Options parent) {
        this.parent = parent;
    }

    public String getAction() {
        if (this.action == null && this.parent != null) {
            return this.parent.getAction();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAction (" + this.action + ") from " + this));
        }
        return this.action;
    }

    public EndpointReference getFaultTo() {
        if (this.faultTo == null && this.parent != null) {
            return this.parent.getFaultTo();
        }
        return this.faultTo;
    }

    public EndpointReference getFrom() {
        if (this.from == null && this.parent != null) {
            return this.parent.getFrom();
        }
        return this.from;
    }

    public TransportListener getListener() {
        this.checkActivateWarning("getListener");
        if (this.listener == null && this.parent != null) {
            return this.parent.getListener();
        }
        return this.listener;
    }

    public TransportInDescription getTransportIn() {
        this.checkActivateWarning("getTransportIn");
        if (this.transportIn == null && this.parent != null) {
            return this.parent.getTransportIn();
        }
        return this.transportIn;
    }

    public String getTransportInProtocol() {
        if (this.transportInProtocol == null && this.parent != null) {
            return this.parent.getTransportInProtocol();
        }
        return this.transportInProtocol;
    }

    public String getMessageId() {
        if (this.messageId == null && this.parent != null) {
            return this.parent.getMessageId();
        }
        return this.messageId;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (this.parent == null) {
            return new HashMap<String, Object>(this.properties);
        }
        Map<String, Object> props = this.parent.getProperties();
        props.putAll(this.properties);
        return props;
    }

    public Object getProperty(String key) {
        Object myPropValue = null;
        if (this.properties != null) {
            myPropValue = this.properties.get(key);
        }
        if (myPropValue == null && this.parent != null) {
            return this.parent.getProperty(key);
        }
        return myPropValue;
    }

    public RelatesTo getRelatesTo(String type) {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelatesTo(type);
        }
        if (this.relationships == null) {
            return null;
        }
        int size = this.relationships.size();
        for (int i = 0; i < size; ++i) {
            RelatesTo relatesTo = this.relationships.get(i);
            String relationshipType = relatesTo.getRelationshipType();
            if (!relationshipType.equals(type)) continue;
            return relatesTo;
        }
        return null;
    }

    public RelatesTo getRelatesTo() {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelatesTo();
        }
        if (this.relationships == null) {
            return null;
        }
        int size = this.relationships.size();
        for (int i = 0; i < size; ++i) {
            RelatesTo relatesTo = this.relationships.get(i);
            String relationshipType = relatesTo.getRelationshipType();
            if (!relationshipType.equals("http://www.w3.org/2005/08/addressing/reply") && !relationshipType.equals("wsa:Reply")) continue;
            return relatesTo;
        }
        return null;
    }

    public RelatesTo[] getRelationships() {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelationships();
        }
        if (this.relationships == null) {
            return null;
        }
        return this.relationships.toArray(new RelatesTo[this.relationships.size()]);
    }

    public void setRelationships(RelatesTo[] list) {
        if (list == null) {
            this.relationships = null;
        } else {
            ArrayList<RelatesTo> arraylist = new ArrayList<RelatesTo>(list.length);
            for (int i = 0; i < list.length; ++i) {
                arraylist.add(list[i]);
            }
            this.relationships = arraylist;
        }
    }

    public EndpointReference getReplyTo() {
        if (this.replyTo == null && this.parent != null) {
            return this.parent.getReplyTo();
        }
        return this.replyTo;
    }

    public TransportOutDescription getTransportOut() {
        this.checkActivateWarning("getTransportOut");
        if (this.transportOut == null && this.parent != null) {
            return this.parent.getTransportOut();
        }
        return this.transportOut;
    }

    public String getSoapVersionURI() {
        if (this.soapVersionURI == null && this.parent != null) {
            return this.parent.getSoapVersionURI();
        }
        return this.soapVersionURI == null ? "http://schemas.xmlsoap.org/soap/envelope/" : this.soapVersionURI;
    }

    public long getTimeOutInMilliSeconds() {
        if (this.timeOutInMilliSeconds == -1L && this.parent != null) {
            return this.parent.getTimeOutInMilliSeconds();
        }
        return this.timeOutInMilliSeconds == -1L ? 30000L : this.timeOutInMilliSeconds;
    }

    public EndpointReference getTo() {
        if (this.to == null && this.parent != null) {
            return this.parent.getTo();
        }
        return this.to;
    }

    public boolean isExceptionToBeThrownOnSOAPFault() {
        if (this.isExceptionToBeThrownOnSOAPFault == null && this.parent != null) {
            this.isExceptionToBeThrownOnSOAPFault = this.parent.isExceptionToBeThrownOnSOAPFault();
        }
        return this.isExceptionToBeThrownOnSOAPFault == null || this.isExceptionToBeThrownOnSOAPFault != false;
    }

    public boolean isUseSeparateListener() {
        if (this.useSeparateListener == null && this.parent != null) {
            this.useSeparateListener = new Boolean(this.parent.isUseSeparateListener());
        }
        return this.useSeparateListener != null && this.useSeparateListener != false;
    }

    public Options getParent() {
        return this.parent;
    }

    public void setParent(Options parent) {
        if (this == parent) {
            throw new IllegalArgumentException("Invalid parent Options: they cannot be the same object");
        }
        this.parent = parent;
    }

    public void setAction(String action) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAction Old action is (" + this.action + ")"));
            log.debug((Object)("setAction New action is (" + action + ")"));
            if (this.action != null && this.action.length() > 0 && action != null && action.length() > 0 && !action.equals(this.action)) {
                log.debug((Object)(" The call stack is:" + JavaUtils.callStackToString()));
            }
        }
        this.action = action;
    }

    public void setExceptionToBeThrownOnSOAPFault(boolean exceptionToBeThrownOnSOAPFault) {
        this.isExceptionToBeThrownOnSOAPFault = exceptionToBeThrownOnSOAPFault;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public void setListener(TransportListener listener) {
        this.listener = listener;
    }

    public void setTransportIn(TransportInDescription transportIn) {
        this.transportIn = transportIn;
    }

    public void setTransportInProtocol(String transportInProtocol) {
        this.transportInProtocol = transportInProtocol;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties != properties && DEBUG_ENABLED) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.debugPropertySet(entry.getKey(), entry.getValue());
            }
        }
        this.properties = properties;
    }

    public void setProperty(String propertyKey, Object property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(propertyKey, property);
        if (DEBUG_ENABLED) {
            this.debugPropertySet(propertyKey, property);
        }
    }

    public void addRelatesTo(RelatesTo relatesTo) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<RelatesTo>(5);
        }
        this.relationships.add(relatesTo);
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    public void setTransportOut(TransportOutDescription transportOut) {
        this.transportOut = transportOut;
    }

    public void setSenderTransport(String senderTransport, AxisConfiguration axisConfiguration) throws AxisFault {
        this.transportOut = axisConfiguration.getTransportOut(senderTransport);
        if (senderTransport == null) {
            throw new AxisFault(Messages.getMessage("unknownTransport", senderTransport));
        }
    }

    public void setSoapVersionURI(String soapVersionURI) {
        this.soapVersionURI = soapVersionURI;
    }

    public void setTimeOutInMilliSeconds(long timeOutInMilliSeconds) {
        this.timeOutInMilliSeconds = timeOutInMilliSeconds;
    }

    public void setTo(EndpointReference to) {
        this.to = to;
    }

    public void setUseSeparateListener(boolean useSeparateListener) {
        this.useSeparateListener = useSeparateListener;
    }

    public boolean isManageSession() {
        return this.manageSession;
    }

    public void setManageSession(boolean manageSession) {
        this.manageSession = manageSession;
    }

    @Override
    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        String logCorrelationIDString = this.getLogCorrelationIDString();
        out.writeLong(-8318751890845181507L);
        out.writeInt(2);
        out.writeLong(this.timeOutInMilliSeconds);
        out.writeBoolean(this.manageSession);
        out.writeObject(this.isExceptionToBeThrownOnSOAPFault);
        out.writeObject(this.useSeparateListener);
        out.writeObject(this.soapVersionURI);
        out.writeObject(this.action);
        out.writeObject(this.transportInProtocol);
        out.writeObject(this.messageId);
        out.writeObject(logCorrelationIDString);
        out.writeObject(this.faultTo);
        out.writeObject(this.from);
        out.writeObject(this.replyTo);
        out.writeObject(this.to);
        this.metaListener = null;
        if (this.listener != null) {
            this.metaListener = new MetaDataEntry(this.listener.getClass().getName(), null);
        }
        out.writeObject(this.metaListener);
        this.metaTransportIn = null;
        if (this.transportIn != null) {
            this.metaTransportIn = new MetaDataEntry(null, this.transportIn.getName().toString());
        }
        out.writeObject(this.metaTransportIn);
        this.metaTransportOut = null;
        if (this.transportOut != null) {
            this.metaTransportOut = new MetaDataEntry(null, this.transportOut.getName().toString());
        }
        out.writeObject(this.metaTransportOut);
        out.writeList(this.relationships);
        out.writeList(this.referenceParameters);
        out.writeMap(this.properties);
        out.writeUTF("parent");
        out.writeObject(this.parent);
    }

    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -8318751890845181507L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        this.timeOutInMilliSeconds = in.readLong();
        this.manageSession = in.readBoolean();
        this.isExceptionToBeThrownOnSOAPFault = (Boolean)in.readObject();
        this.useSeparateListener = (Boolean)in.readObject();
        this.soapVersionURI = (String)in.readObject();
        this.action = (String)in.readObject();
        this.transportInProtocol = (String)in.readObject();
        this.messageId = (String)in.readObject();
        this.logCorrelationIDString = (String)in.readObject();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Options:readExternal():  reading the input stream for  [" + this.logCorrelationIDString + "]"));
        }
        this.faultTo = (EndpointReference)in.readObject();
        this.from = (EndpointReference)in.readObject();
        this.replyTo = (EndpointReference)in.readObject();
        this.to = (EndpointReference)in.readObject();
        this.listener = null;
        this.metaListener = (MetaDataEntry)in.readObject();
        this.transportIn = null;
        this.metaTransportIn = (MetaDataEntry)in.readObject();
        this.transportOut = null;
        this.metaTransportOut = (MetaDataEntry)in.readObject();
        this.relationships = in.readArrayList();
        this.referenceParameters = in.readArrayList();
        this.properties = in.readHashMap();
        in.readUTF();
        this.parent = (Options)in.readObject();
    }

    public void activate(ConfigurationContext cc) {
        if (!this.needsToBeReconciled) {
            return;
        }
        String logCorrelationIDString = this.getLogCorrelationIDString();
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        if (this.metaTransportIn != null) {
            QName qin = this.metaTransportIn.getQName();
            TransportInDescription tmpIn = null;
            try {
                tmpIn = axisConfig.getTransportIn(qin.getLocalPart());
            }
            catch (Exception exin) {
                log.trace((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportInDescription [" + qin.toString() + "]  from the AxisConfiguration [" + exin.getClass().getName() + " : " + exin.getMessage() + "]"));
            }
            if (tmpIn != null) {
                this.transportIn = tmpIn;
            } else {
                log.trace((Object)(logCorrelationIDString + "activate():  No TransportInDescription found for [" + qin.toString() + "]"));
                this.transportIn = null;
            }
        } else {
            log.trace((Object)(logCorrelationIDString + "activate():  No TransportInDescription "));
            this.transportIn = null;
        }
        if (this.metaTransportOut != null) {
            QName qout = this.metaTransportOut.getQName();
            TransportOutDescription tmpOut = null;
            try {
                tmpOut = axisConfig.getTransportOut(qout.getLocalPart());
            }
            catch (Exception exout) {
                log.trace((Object)(logCorrelationIDString + "activate():  exception caught when getting the TransportOutDescription [" + qout.toString() + "]  from the AxisConfiguration [" + exout.getClass().getName() + " : " + exout.getMessage() + "]"));
            }
            if (tmpOut != null) {
                this.transportOut = tmpOut;
            } else {
                log.trace((Object)(logCorrelationIDString + "activate():  No TransportOutDescription found for [" + qout.toString() + "]"));
                this.transportOut = null;
            }
        } else {
            log.trace((Object)(logCorrelationIDString + "activate():  No TransportOutDescription "));
            this.transportOut = null;
        }
        if (this.metaListener != null) {
            String listenerClass = this.metaListener.getClassName();
            log.trace((Object)(logCorrelationIDString + "activate():  TransportListener found for [" + listenerClass + "] "));
        } else {
            this.listener = null;
            log.trace((Object)(logCorrelationIDString + "activate():  No TransportListener "));
        }
        this.needsToBeReconciled = false;
    }

    public boolean isEquivalent(Options obj) {
        if (this.timeOutInMilliSeconds != obj.getTimeOutInMilliSeconds()) {
            return false;
        }
        if (this.isExceptionToBeThrownOnSOAPFault.booleanValue() != obj.isExceptionToBeThrownOnSOAPFault()) {
            return false;
        }
        if (this.useSeparateListener.booleanValue() != obj.isUseSeparateListener()) {
            return false;
        }
        if (this.manageSession != obj.isManageSession()) {
            return false;
        }
        if (this.soapVersionURI != null && obj.getSoapVersionURI() != null) {
            if (!this.soapVersionURI.equals(obj.getSoapVersionURI())) {
                return false;
            }
        } else if (this.soapVersionURI != null || obj.getSoapVersionURI() != null) {
            return false;
        }
        if (this.action != null && obj.getAction() != null) {
            if (!this.action.equals(obj.getAction())) {
                return false;
            }
        } else if (this.action != null || obj.getAction() != null) {
            return false;
        }
        if (this.transportInProtocol != null && obj.getTransportInProtocol() != null) {
            if (!this.transportInProtocol.equals(obj.getTransportInProtocol())) {
                return false;
            }
        } else if (this.transportInProtocol != null || obj.getTransportInProtocol() != null) {
            return false;
        }
        if (this.messageId != null && obj.getMessageId() != null) {
            if (!this.messageId.equals(obj.getMessageId())) {
                return false;
            }
        } else if (this.messageId != null || obj.getMessageId() != null) {
            return false;
        }
        if (this.faultTo != null && obj.getFaultTo() != null) {
            if (!this.faultTo.isEquivalent(obj.getFaultTo())) {
                return false;
            }
        } else if (this.faultTo != null || obj.getFaultTo() != null) {
            return false;
        }
        if (this.from != null && obj.getFrom() != null) {
            if (!this.from.isEquivalent(obj.getFrom())) {
                return false;
            }
        } else if (this.from != null || obj.getFrom() != null) {
            return false;
        }
        if (this.replyTo != null && obj.getReplyTo() != null) {
            if (!this.replyTo.isEquivalent(obj.getReplyTo())) {
                return false;
            }
        } else if (this.replyTo != null || obj.getReplyTo() != null) {
            return false;
        }
        if (this.to != null && obj.getTo() != null) {
            if (!this.to.isEquivalent(obj.getTo())) {
                return false;
            }
        } else if (this.to != null || obj.getTo() != null) {
            return false;
        }
        if (this.properties != null && obj.getProperties() != null) {
            if (!this.properties.equals(obj.getProperties())) {
                return false;
            }
        } else if (this.properties != null || obj.getProperties() != null) {
            return false;
        }
        return true;
    }

    public String getLogCorrelationIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "Options@" + UIDGenerator.generateUID();
        }
        return this.logCorrelationIDString;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled) {
            log.warn((Object)(this.getLogCorrelationIDString() + ":" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked."));
        }
    }

    public boolean isCallTransportCleanup() {
        return this.callTransportCleanup;
    }

    public void setCallTransportCleanup(boolean callTransportCleanup) {
        this.callTransportCleanup = callTransportCleanup;
    }

    public String getUserName() {
        if (this.userName == null && this.parent != null) {
            return this.parent.getUserName();
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        if (this.password == null && this.parent != null) {
            return this.parent.getPassword();
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void debugPropertySet(String key, Object value) {
        if (DEBUG_PROPERTY_SET) {
            ClassLoader cl;
            String className = value == null ? "null" : value.getClass().getName();
            String classloader = "null";
            if (value != null && (cl = Utils.getObjectClassLoader(value)) != null) {
                classloader = cl.toString();
            }
            String valueText = value instanceof String ? value.toString() : null;
            String identity = this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this));
            log.debug((Object)"==================");
            log.debug((Object)(" Property set on object " + identity));
            log.debug((Object)("  Key =" + key));
            if (valueText != null) {
                log.debug((Object)("  Value =" + valueText));
            }
            log.debug((Object)("  Value Class = " + className));
            log.debug((Object)("  Value Classloader = " + classloader));
            log.debug((Object)("Call Stack = " + JavaUtils.callStackToString()));
            log.debug((Object)"==================");
        }
    }
}

