/* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR BSD-3-Clause) */
/* Do not edit directly, auto-generated from: */
/*	Documentation/netlink/specs/ovpn.yaml */
/* YNL-GEN uapi header */
/* To regenerate run: tools/net/ynl/ynl-regen.sh */

#ifndef _LINUX_OVPN_H
#define _LINUX_OVPN_H

#define OVPN_FAMILY_NAME	"ovpn"
#define OVPN_FAMILY_VERSION	1

#define OVPN_NONCE_TAIL_SIZE	8

enum ovpn_cipher_alg {
	OVPN_CIPHER_ALG_NONE,
	OVPN_CIPHER_ALG_AES_GCM,
	OVPN_CIPHER_ALG_CHACHA20_POLY1305,
};

enum ovpn_del_peer_reason {
	OVPN_DEL_PEER_REASON_TEARDOWN,
	OVPN_DEL_PEER_REASON_USERSPACE,
	OVPN_DEL_PEER_REASON_EXPIRED,
	OVPN_DEL_PEER_REASON_TRANSPORT_ERROR,
	OVPN_DEL_PEER_REASON_TRANSPORT_DISCONNECT,
};

enum ovpn_key_slot {
	OVPN_KEY_SLOT_PRIMARY,
	OVPN_KEY_SLOT_SECONDARY,
};

enum {
	OVPN_A_PEER_ID = 1,
	OVPN_A_PEER_REMOTE_IPV4,
	OVPN_A_PEER_REMOTE_IPV6,
	OVPN_A_PEER_REMOTE_IPV6_SCOPE_ID,
	OVPN_A_PEER_REMOTE_PORT,
	OVPN_A_PEER_SOCKET,
	OVPN_A_PEER_SOCKET_NETNSID,
	OVPN_A_PEER_VPN_IPV4,
	OVPN_A_PEER_VPN_IPV6,
	OVPN_A_PEER_LOCAL_IPV4,
	OVPN_A_PEER_LOCAL_IPV6,
	OVPN_A_PEER_LOCAL_PORT,
	OVPN_A_PEER_KEEPALIVE_INTERVAL,
	OVPN_A_PEER_KEEPALIVE_TIMEOUT,
	OVPN_A_PEER_DEL_REASON,
	OVPN_A_PEER_VPN_RX_BYTES,
	OVPN_A_PEER_VPN_TX_BYTES,
	OVPN_A_PEER_VPN_RX_PACKETS,
	OVPN_A_PEER_VPN_TX_PACKETS,
	OVPN_A_PEER_LINK_RX_BYTES,
	OVPN_A_PEER_LINK_TX_BYTES,
	OVPN_A_PEER_LINK_RX_PACKETS,
	OVPN_A_PEER_LINK_TX_PACKETS,

	__OVPN_A_PEER_MAX,
	OVPN_A_PEER_MAX = (__OVPN_A_PEER_MAX - 1)
};

enum {
	OVPN_A_KEYCONF_PEER_ID = 1,
	OVPN_A_KEYCONF_SLOT,
	OVPN_A_KEYCONF_KEY_ID,
	OVPN_A_KEYCONF_CIPHER_ALG,
	OVPN_A_KEYCONF_ENCRYPT_DIR,
	OVPN_A_KEYCONF_DECRYPT_DIR,

	__OVPN_A_KEYCONF_MAX,
	OVPN_A_KEYCONF_MAX = (__OVPN_A_KEYCONF_MAX - 1)
};

enum {
	OVPN_A_KEYDIR_CIPHER_KEY = 1,
	OVPN_A_KEYDIR_NONCE_TAIL,

	__OVPN_A_KEYDIR_MAX,
	OVPN_A_KEYDIR_MAX = (__OVPN_A_KEYDIR_MAX - 1)
};

enum {
	OVPN_A_IFINDEX = 1,
	OVPN_A_PEER,
	OVPN_A_KEYCONF,

	__OVPN_A_MAX,
	OVPN_A_MAX = (__OVPN_A_MAX - 1)
};

enum {
	OVPN_CMD_PEER_NEW = 1,
	OVPN_CMD_PEER_SET,
	OVPN_CMD_PEER_GET,
	OVPN_CMD_PEER_DEL,
	OVPN_CMD_PEER_DEL_NTF,
	OVPN_CMD_KEY_NEW,
	OVPN_CMD_KEY_GET,
	OVPN_CMD_KEY_SWAP,
	OVPN_CMD_KEY_SWAP_NTF,
	OVPN_CMD_KEY_DEL,

	__OVPN_CMD_MAX,
	OVPN_CMD_MAX = (__OVPN_CMD_MAX - 1)
};

#define OVPN_MCGRP_PEERS	"peers"

#endif /* _LINUX_OVPN_H */
