/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;

class OracleConversionInputStream
extends OracleBufferedStream
implements Diagnosable {
    private static final String CLASS_NAME = OracleConversionInputStream.class.getName();
    static final int CHUNK_SIZE = 32768;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    int convbufSize;
    char[] javaChars;
    int javaCharsSize;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, Monitor monitor) {
        this(conv_object, istream, conversion, 1, monitor);
    }

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, short formOfUse, Monitor monitor) {
        super(32768, conv_object.byteArrayAllocator, conv_object.byteArrayCache, monitor);
        this.istream = istream;
        this.conversion = conversion;
        this.converter = conv_object;
        this.maxSize = 0;
        this.totalSize = 0;
        this.numUnconvertedBytes = 0;
        this.endOfStream = false;
        this.nbytes = new int[1];
        this.csform = formOfUse;
        this.currentBufferSize = this.initialBufferSize;
        switch (conversion) {
            case 0: {
                this.javaCharsSize = 32768;
                this.convbufSize = 32768;
                break;
            }
            case 1: {
                this.convbufSize = 16384;
                this.javaCharsSize = 16384;
                break;
            }
            case 2: {
                this.convbufSize = 16384;
                this.javaCharsSize = 32768;
                break;
            }
            case 3: {
                this.convbufSize = 8192;
                this.javaCharsSize = 16384;
                break;
            }
            case 4: {
                int size = 32768 / this.converter.getMaxCharbyteSize();
                this.convbufSize = size * 2;
                this.javaCharsSize = size;
                break;
            }
            case 5: {
                if (this.converter.isUcs2CharSet()) {
                    this.convbufSize = 16384;
                    this.javaCharsSize = 16384;
                    break;
                }
                this.convbufSize = 32768;
                this.javaCharsSize = 32768;
                break;
            }
            case 7: {
                int size;
                this.javaCharsSize = size = 32768 / (this.csform == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                this.convbufSize = 0;
                break;
            }
            case 14: {
                this.javaCharsSize = 16384;
                this.convbufSize = 0;
                break;
            }
            case 16: {
                this.javaCharsSize = 32768 / (this.csform == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.sMaxCharSize);
                this.convbufSize = 0;
                break;
            }
            default: {
                this.convbufSize = 32768;
                this.javaCharsSize = 32768;
            }
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize, Monitor monitor) {
        this(conv_object, istream, conversion, 1, monitor);
        this.maxSize = max_bytesize;
        this.totalSize = 0;
    }

    public OracleConversionInputStream(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse, Monitor monitor) {
        this(conv_object, (InputStream)null, conversion, formOfUse, monitor);
        this.reader = reader;
        this.maxSize = max_charsize;
        this.totalSize = 0;
    }

    public void allocateBuffers() {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            if (this.javaChars == null) {
                this.javaChars = this.converter.charArrayAllocator.apply(this.javaCharsSize);
                if (this.convbufSize > 0) {
                    this.convbuf = this.converter.byteArrayAllocator.apply(this.convbufSize);
                }
            }
        }
    }

    void deallocateBuffers() {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            if (this.convbuf != null) {
                this.converter.byteArrayCache.accept(this.convbuf);
                this.convbuf = null;
            }
            if (this.javaChars != null) {
                this.converter.charArrayCache.accept(this.javaChars);
                this.javaChars = null;
            }
        }
    }

    public void setFormOfUse(short csform) {
        this.csform = csform;
    }

    @Override
    public boolean needBytes(int ignore) throws IOException {
        return this.needBytes();
    }

    @Override
    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos < this.count) {
            return true;
        }
        if (this.istream != null) {
            return this.needBytesFromStream();
        }
        if (this.reader != null) {
            return this.needBytesFromReader();
        }
        return false;
    }

    public boolean needBytesFromReader() throws IOException {
        try {
            int read_size = 0;
            read_size = this.maxSize == 0 ? this.javaCharsSize : Math.min(this.maxSize - this.totalSize, this.javaCharsSize);
            if (read_size <= 0) {
                this.deallocateBuffers();
                return false;
            }
            this.allocateBuffers();
            byte[] buffer = this.getBuffer(this.currentBufferSize);
            int chars_read = this.reader.read(this.javaChars, 0, read_size);
            if (chars_read == -1) {
                this.deallocateBuffers();
                return false;
            }
            this.totalSize += chars_read;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, buffer);
                    break;
                }
                case 14: {
                    this.count = CharacterSet.convertJavaCharsToAL16UTF16Bytes(this.javaChars, 0, buffer, 0, chars_read);
                    break;
                }
                case 16: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    this.count = this.converter.javaCharsToDbCsBytes(this.javaChars, chars_read, buffer);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, buffer, 0, chars_read);
                    this.count = chars_read;
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
        this.pos = 0;
        return true;
    }

    public boolean needBytesFromStream() throws IOException {
        if (!this.endOfStream) {
            try {
                int read_size = 0;
                read_size = this.maxSize == 0 ? this.convbufSize : Math.min(this.maxSize - this.totalSize, this.convbufSize);
                int bytes_read = 0;
                if (read_size <= 0) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                    }
                } else {
                    this.allocateBuffers();
                    int _bytes_read = bytes_read = this.istream.read(this.convbuf, this.numUnconvertedBytes, read_size - this.numUnconvertedBytes);
                    this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "needBytesFromStream", "{0}", null, null, () -> new Object[]{OracleLog.bytesToPrintableForm("Read " + _bytes_read + " bytes into convbuf", this.convbuf, _bytes_read)});
                }
                if (bytes_read == -1) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                    }
                } else {
                    this.totalSize += (bytes_read += this.numUnconvertedBytes);
                }
                if (bytes_read <= 0) {
                    this.deallocateBuffers();
                    return false;
                }
                byte[] buffer = this.getBuffer(this.currentBufferSize);
                switch (this.conversion) {
                    case 0: {
                        this.nbytes[0] = bytes_read;
                        int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaCharsSize);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i = 0; i < this.numUnconvertedBytes; ++i) {
                            this.convbuf[i] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 1: {
                        this.nbytes[0] = bytes_read;
                        int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaCharsSize);
                        this.numUnconvertedBytes = this.nbytes[0];
                        for (int i = 0; i < this.numUnconvertedBytes; ++i) {
                            this.convbuf[i] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 2: {
                        int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 3: {
                        int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 4: {
                        int chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 12: {
                        int chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, buffer);
                        break;
                    }
                    case 5: {
                        DBConversion.asciiBytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, bytes_read, buffer);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, buffer, 0, bytes_read);
                        this.count = bytes_read;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
            this.pos = 0;
            return true;
        }
        this.deallocateBuffers();
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

