﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>

namespace Aws {
namespace PaymentCryptographyData {
namespace Model {
enum class MacAlgorithm {
  NOT_SET,
  ISO9797_ALGORITHM1,
  ISO9797_ALGORITHM3,
  CMAC,
  HMAC,
  HMAC_SHA224,
  HMAC_SHA256,
  HMAC_SHA384,
  HMAC_SHA512,
  AS2805_4_1
};

namespace MacAlgorithmMapper {
AWS_PAYMENTCRYPTOGRAPHYDATA_API MacAlgorithm GetMacAlgorithmForName(const Aws::String& name);

AWS_PAYMENTCRYPTOGRAPHYDATA_API Aws::String GetNameForMacAlgorithm(MacAlgorithm value);
}  // namespace MacAlgorithmMapper
}  // namespace Model
}  // namespace PaymentCryptographyData
}  // namespace Aws
