/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.security.spi.resources.ResourceSharingExtension;

public class ResourcePluginInfo {
    private final Set<ResourceSharingExtension> resourceSharingExtensions = new HashSet<ResourceSharingExtension>();
    private final Map<String, String> typeToIndex = new HashMap<String, String>();
    private final Map<String, String> indexToType = new HashMap<String, String>();
    private final Map<String, LinkedHashSet<String>> typeToGroupNames = new HashMap<String, LinkedHashSet<String>>();
    private final Map<String, FlattenedActionGroups> typeToFlattened = new HashMap<String, FlattenedActionGroups>();

    public void setResourceSharingExtensions(Set<ResourceSharingExtension> extensions, List<String> protectedTypes) {
        this.resourceSharingExtensions.clear();
        this.typeToIndex.clear();
        this.indexToType.clear();
        if (!protectedTypes.isEmpty()) {
            HashSet<String> resourceTypes = new HashSet<String>();
            for (ResourceSharingExtension extension : extensions) {
                for (ResourceProvider rp : extension.getResourceProviders()) {
                    if (!protectedTypes.contains(rp.resourceType())) continue;
                    if (!resourceTypes.contains(rp.resourceType())) {
                        resourceTypes.add(rp.resourceType());
                        this.typeToIndex.put(rp.resourceType(), rp.resourceIndexName());
                        this.indexToType.put(rp.resourceIndexName(), rp.resourceType());
                        continue;
                    }
                    throw new OpenSearchSecurityException(String.format("Resource type [%s] is already registered. Please provide a different unique-name for the resource declared by %s.", rp.resourceType(), extension.getClass().getName()), new Object[0]);
                }
            }
        }
        this.resourceSharingExtensions.addAll(extensions);
    }

    public Set<ResourceSharingExtension> getResourceSharingExtensions() {
        return ImmutableSet.copyOf(this.resourceSharingExtensions);
    }

    public void registerActionGroupNames(String resourceType, Collection<String> names) {
        if (resourceType == null || names == null) {
            return;
        }
        this.typeToGroupNames.computeIfAbsent(resourceType, k -> new LinkedHashSet()).addAll(names.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).toList());
    }

    public void registerFlattened(String resourceType, FlattenedActionGroups flattened) {
        if (resourceType == null || flattened == null) {
            return;
        }
        this.typeToFlattened.put(resourceType, flattened);
    }

    public FlattenedActionGroups flattenedForType(String resourceType) {
        return this.typeToFlattened.getOrDefault(resourceType, FlattenedActionGroups.EMPTY);
    }

    public String typeByIndex(String index) {
        return this.indexToType.get(index);
    }

    public String indexByType(String type) {
        return this.typeToIndex.get(type);
    }

    public Set<ResourceDashboardInfo> getResourceTypes() {
        return this.typeToIndex.keySet().stream().map(s -> new ResourceDashboardInfo((String)s, Collections.unmodifiableSet(this.typeToGroupNames.getOrDefault(s, new LinkedHashSet())))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getResourceIndices() {
        return this.indexToType.keySet();
    }

    public record ResourceDashboardInfo(String resourceType, Set<String> actionGroups) implements ToXContentObject
    {
        public XContentBuilder toXContent(XContentBuilder b, ToXContent.Params p) throws IOException {
            b.startObject();
            b.field("type", this.resourceType);
            b.field("action_groups", this.actionGroups == null ? Collections.emptyList() : this.actionGroups);
            return b.endObject();
        }
    }
}

