/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.logging.LoggerMessageFormat;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.action.simulate.PermissionCheckResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.RolesInjector;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.CompatConfig;
import org.opensearch.security.configuration.DlsFlsRequestValve;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.ResourceAccessEvaluator;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public class SecurityFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private final DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final ClusterService cs;
    private final ClusterInfoHolder clusterInfoHolder;
    private final CompatConfig compatConfig;
    private final IndexResolverReplacer indexResolverReplacer;
    private final WildcardMatcher immutableIndicesMatcher;
    private final RolesInjector rolesInjector;
    private final UserInjector userInjector;
    private final ResourceAccessEvaluator resourceAccessEvaluator;

    public SecurityFilter(Settings settings, PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, ClusterInfoHolder clusterInfoHolder, CompatConfig compatConfig, IndexResolverReplacer indexResolverReplacer, XFFResolver xffResolver, ResourceAccessEvaluator resourceAccessEvaluator) {
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.cs = cs;
        this.clusterInfoHolder = clusterInfoHolder;
        this.compatConfig = compatConfig;
        this.indexResolverReplacer = indexResolverReplacer;
        this.immutableIndicesMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.compliance.immutable_indices", Collections.emptyList()));
        this.rolesInjector = new RolesInjector(auditLog);
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.resourceAccessEvaluator = resourceAccessEvaluator;
        this.log.info("{} indices are made immutable.", (Object)this.immutableIndicesMatcher);
    }

    @VisibleForTesting
    WildcardMatcher getImmutableIndicesMatcher() {
        return this.immutableIndicesMatcher;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().newStoredContext(true);){
            ThreadContext.clearAll();
            this.apply0(task, action, request, listener, chain);
        }
    }

    private static Set<String> alias2Name(Set<Alias> aliases) {
        return (Set)aliases.stream().map(a -> a.name()).collect(ImmutableSet.toImmutableSet());
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        try {
            PrivilegesEvaluator eval;
            boolean internalRequest;
            UserInjector.Result injectedUser;
            ComplianceConfig complianceConfig;
            org.opensearch.common.util.concurrent.ThreadContext threadContext = this.threadPool.getThreadContext();
            if (threadContext.getTransient("_opendistro_security_origin") == null) {
                threadContext.putTransient("_opendistro_security_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if ((complianceConfig = this.auditLog.getComplianceConfig()) != null && complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            Set<String> injectedRoles = this.rolesInjector.injectUserAndRoles(this.threadPool);
            User user = (User)threadContext.getTransient("_opendistro_security_user");
            if (user == null && (injectedUser = this.userInjector.getInjectedUser()) != null) {
                user = injectedUser.getUser();
                threadContext.putTransient("_opendistro_security_user", (Object)user);
            }
            if (user != null && threadContext.getPersistent("_opendistro_security_authenticated_user") == null) {
                threadContext.putPersistent("_opendistro_security_authenticated_user", (Object)new UserSubjectImpl(this.threadPool, user));
            }
            boolean userIsAdmin = SecurityFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(threadContext, "_opendistro_security_conf_request"));
            boolean passThroughRequest = action.startsWith("indices:admin/seq_no") || action.equals("cluster:admin/opendistro_security/whoami");
            boolean bl = internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(threadContext)) && action.startsWith("internal:") && !action.startsWith("internal:transport/proxy");
            if (user != null) {
                ThreadContext.put((String)"user", (String)user.getName());
            }
            if (OpenSearchSecurityPlugin.isActionTraceEnabled()) {
                Object count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                OpenSearchSecurityPlugin.traceAction("Node " + this.cs.localNode().getName() + " -> " + action + " (" + (String)count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + String.valueOf(threadContext.getTransient("_opendistro_security_origin")) + "/directRequest=" + HeaderHelper.isDirectRequest(threadContext) + "/remoteAddress=" + String.valueOf(request.remoteAddress()));
                threadContext.putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + action + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + String.valueOf(threadContext.getTransient("_opendistro_security_origin")) + "/directRequest=" + HeaderHelper.isDirectRequest(threadContext) + "/remoteAddress=" + String.valueOf(request.remoteAddress()) + " " + String.valueOf(threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()))));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                    this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (this.immutableIndicesMatcher != WildcardMatcher.NONE) {
                boolean isImmutable = false;
                if (request instanceof BulkShardRequest) {
                    BulkItemRequest bsr;
                    BulkItemRequest[] bulkItemRequestArray = ((BulkShardRequest)request).items();
                    int n = bulkItemRequestArray.length;
                    for (int i = 0; i < n && !(isImmutable = this.checkImmutableIndices((bsr = bulkItemRequestArray[i]).request(), listener)); ++i) {
                    }
                } else {
                    isImmutable = this.checkImmutableIndices(request, listener);
                }
                if (isImmutable) {
                    return;
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(threadContext.getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(threadContext)) && injectedRoles == null && user == null) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (user == null) {
                boolean skipSecurityIfDualMode;
                if (action.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                boolean bl2 = skipSecurityIfDualMode = threadContext.getTransient("_opendistro_security_passive_security") == Boolean.TRUE;
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null) && !this.compatConfig.transportInterClusterAuthEnabled()) {
                    chain.proceed(task, action, request, listener);
                    return;
                }
                if ((interClusterRequest || trustedClusterRequest || request.remoteAddress() == null || skipSecurityIfDualMode) && this.compatConfig.transportInterClusterPassiveAuthEnabled()) {
                    this.log.info("Transport auth in passive mode and no user found. Injecting default user");
                    user = User.DEFAULT_TRANSPORT_USER;
                    threadContext.putTransient("_opendistro_security_user", (Object)user);
                    if (threadContext.getPersistent("_opendistro_security_authenticated_user") == null) {
                        threadContext.putPersistent("_opendistro_security_authenticated_user", (Object)new UserSubjectImpl(this.threadPool, user));
                    }
                } else {
                    this.log.error("No user found for " + action + " from " + String.valueOf(request.remoteAddress()) + " " + String.valueOf(threadContext.getTransient("_opendistro_security_origin")) + " via " + String.valueOf(threadContext.getTransient("_opendistro_security_channel_type")) + " " + String.valueOf(threadContext.getHeaders()));
                    listener.onFailure((Exception)((Object)new OpenSearchSecurityException("No user found for " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
                    return;
                }
            }
            if (!(eval = this.evalp).isInitialized()) {
                StringBuilder error = new StringBuilder("OpenSearch Security not initialized for ");
                error.append(action);
                if (!this.clusterInfoHolder.hasClusterManager().booleanValue()) {
                    error.append(String.format(". %s", "Cluster manager not present"));
                }
                this.log.error(error.toString());
                listener.onFailure((Exception)((Object)new OpenSearchSecurityException(error.toString(), RestStatus.SERVICE_UNAVAILABLE, new Object[0])));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            PrivilegesEvaluationContext context = eval.createContext(user, action, request, task, injectedRoles);
            User finalUser = user;
            Consumer<PrivilegesEvaluatorResponse> handleUnauthorized = response -> {
                this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
                String err = !response.getMissingSecurityRoles().isEmpty() ? String.format("No mapping for %s on roles %s", finalUser, response.getMissingSecurityRoles()) : (injectedRoles != null ? String.format("no permissions for %s and associated roles %s", response.getMissingPrivileges(), context.getMappedRoles()) : String.format("no permissions for %s and %s", response.getMissingPrivileges(), finalUser));
                this.log.debug(err);
                listener.onFailure((Exception)((Object)new OpenSearchSecurityException(err, RestStatus.FORBIDDEN, new Object[0])));
            };
            if (this.resourceAccessEvaluator.shouldEvaluate(request)) {
                this.resourceAccessEvaluator.evaluateAsync(request, action, context, (ActionListener<PrivilegesEvaluatorResponse>)ActionListener.wrap(response -> {
                    if (this.handlePermissionCheckRequest(listener, (PrivilegesEvaluatorResponse)response, action)) {
                        return;
                    }
                    if (response.isAllowed()) {
                        this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                        this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                        chain.proceed(task, action, request, listener);
                    } else {
                        handleUnauthorized.accept((PrivilegesEvaluatorResponse)response);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
                return;
            }
            PrivilegesEvaluatorResponse pres = eval.evaluate(context);
            if (this.log.isDebugEnabled()) {
                this.log.debug(pres.toString());
            }
            if (this.handlePermissionCheckRequest(listener, pres, action)) {
                return;
            }
            if (pres.isAllowed()) {
                this.auditLog.logGrantedPrivileges(action, (TransportRequest)request, task);
                this.auditLog.logIndexEvent(action, (TransportRequest)request, task);
                if (!this.dlsFlsValve.invoke(context, listener)) {
                    return;
                }
                CreateIndexRequestBuilder createIndexRequestBuilder = pres.getCreateIndexRequestBuilder();
                if (createIndexRequestBuilder == null) {
                    chain.proceed(task, action, request, listener);
                } else {
                    CreateIndexRequest createIndexRequest = (CreateIndexRequest)createIndexRequestBuilder.request();
                    this.log.info("Request {} requires new tenant index {} with aliases {}", (Object)request.getClass().getSimpleName(), (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()));
                    createIndexRequestBuilder.execute(ActionListener.wrap(createIndexResponse -> {
                        if (createIndexResponse.isAcknowledged()) {
                            this.log.debug("Request to create index {} with aliases {} acknowledged, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName());
                            chain.proceed(task, action, request, listener);
                        } else {
                            String message = LoggerMessageFormat.format((String)"Request to create index {} with aliases {} was not acknowledged, failing {}", (String)createIndexRequest.index(), (Object[])new Object[]{SecurityFilter.alias2Name(createIndexRequest.aliases()), request.getClass().getSimpleName()});
                            this.log.error(message);
                            listener.onFailure((Exception)((Object)new OpenSearchException(message, new Object[0])));
                        }
                    }, e -> {
                        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (cause instanceof ResourceAlreadyExistsException) {
                            this.log.warn("Request to create index {} with aliases {} failed as the resource already exists, proceeding with {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), e);
                            chain.proceed(task, action, request, listener);
                        } else {
                            this.log.error("Request to create index {} with aliases {} failed, failing {}", (Object)createIndexRequest.index(), SecurityFilter.alias2Name(createIndexRequest.aliases()), (Object)request.getClass().getSimpleName(), e);
                            listener.onFailure(e);
                        }
                    }));
                }
            } else {
                handleUnauthorized.accept(pres);
            }
        }
        catch (OpenSearchException e2) {
            if (task != null) {
                this.log.debug("Failed to apply filter. Task id: {} ({}). Action: {}", (Object)task.getId(), (Object)task.getDescription(), (Object)action, (Object)e2);
            } else {
                this.log.debug("Failed to apply filter. Action: {}", (Object)action, (Object)e2);
            }
            listener.onFailure((Exception)((Object)e2));
        }
        catch (Throwable e3) {
            this.log.error("Unexpected exception {}", (Object)e3, (Object)e3);
            listener.onFailure((Exception)((Object)new OpenSearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        org.opensearch.common.util.concurrent.ThreadContext threadContext = this.threadPool.getThreadContext();
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (threadContext.getHeader("_opendistro_security_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && threadContext.getHeader("_opendistro_security_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            threadContext.putHeader("_opendistro_security_source_field_context", serializedSourceFieldContext);
        }
    }

    private <Response extends ActionResponse> boolean handlePermissionCheckRequest(ActionListener<Response> listener, PrivilegesEvaluatorResponse pres, String action) {
        boolean isDryRun = Boolean.parseBoolean(this.threadPool.getThreadContext().getHeader("perform_permission_check"));
        if (!isDryRun) {
            return false;
        }
        PermissionCheckResponse response = new PermissionCheckResponse(pres.isAllowed(), pres.getMissingPrivileges());
        listener.onResponse((Object)response);
        this.log.debug("Dry run permission check for action '{}': accessAllowed={}, missingPrivileges={}", (Object)action, (Object)pres.isAllowed(), pres.getMissingPrivileges());
        return true;
    }

    private boolean checkImmutableIndices(Object request, ActionListener listener) {
        boolean isModifyIndexRequest;
        boolean bl = isModifyIndexRequest = request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest;
        if (isModifyIndexRequest && this.isRequestIndexImmutable(request)) {
            listener.onFailure((Exception)((Object)new OpenSearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0])));
            return true;
        }
        if (request instanceof IndexRequest && this.isRequestIndexImmutable(request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
        }
        return false;
    }

    private boolean isRequestIndexImmutable(Object request) {
        IndexResolverReplacer.Resolved resolved = this.indexResolverReplacer.resolveRequest(request);
        if (resolved.isLocalAll()) {
            return true;
        }
        Set<String> allIndices = resolved.getAllIndices();
        return this.immutableIndicesMatcher.matchAny(allIndices);
    }
}

