/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.OptionalInt;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.IntegerStringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class OptionalIntStringConverter
implements StringConverter<OptionalInt> {
    private static IntegerStringConverter INTEGER_CONVERTER = IntegerStringConverter.create();

    private OptionalIntStringConverter() {
    }

    public static OptionalIntStringConverter create() {
        return new OptionalIntStringConverter();
    }

    @Override
    public EnhancedType<OptionalInt> type() {
        return EnhancedType.of(OptionalInt.class);
    }

    @Override
    public String toString(OptionalInt object) {
        if (!object.isPresent()) {
            return null;
        }
        return INTEGER_CONVERTER.toString(object.getAsInt());
    }

    @Override
    public OptionalInt fromString(String string) {
        if (string == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(INTEGER_CONVERTER.fromString(string));
    }
}

