/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.util.Encodable;

public abstract class ContainedPacket
extends Packet
implements Encodable {
    ContainedPacket(int packetTag) {
        this(packetTag, false);
    }

    ContainedPacket(int packetTag, boolean newPacketFormat) {
        super(packetTag, newPacketFormat);
    }

    public byte[] getEncoded() throws IOException {
        return this.getEncoded(PacketFormat.ROUNDTRIP);
    }

    public byte[] getEncoded(PacketFormat format) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)bOut, format);
        pOut.writePacket(this);
        pOut.close();
        return bOut.toByteArray();
    }

    public abstract void encode(BCPGOutputStream var1) throws IOException;
}

