/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.get;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.document.DocumentField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.get.GetResult;

@PublicApi(since="1.0.0")
public class GetResponse
extends ActionResponse
implements Iterable<DocumentField>,
ToXContentObject {
    GetResult getResult;

    GetResponse(StreamInput in) throws IOException {
        super(in);
        this.getResult = new GetResult(in);
    }

    public GetResponse(GetResult getResult) {
        this.getResult = getResult;
    }

    public boolean isExists() {
        return this.getResult.isExists();
    }

    public String getIndex() {
        return this.getResult.getIndex();
    }

    public String getId() {
        return this.getResult.getId();
    }

    public long getVersion() {
        return this.getResult.getVersion();
    }

    public long getSeqNo() {
        return this.getResult.getSeqNo();
    }

    public long getPrimaryTerm() {
        return this.getResult.getPrimaryTerm();
    }

    public byte[] getSourceAsBytes() {
        return this.getResult.source();
    }

    public BytesReference getSourceInternal() {
        return this.getResult.internalSourceRef();
    }

    public BytesReference getSourceAsBytesRef() {
        return this.getResult.sourceRef();
    }

    public boolean isSourceEmpty() {
        return this.getResult.isSourceEmpty();
    }

    public String getSourceAsString() {
        return this.getResult.sourceAsString();
    }

    public Map<String, Object> getSourceAsMap() throws OpenSearchParseException {
        return this.getResult.sourceAsMap();
    }

    public Map<String, Object> getSource() {
        return this.getResult.getSource();
    }

    public Map<String, DocumentField> getFields() {
        return this.getResult.getFields();
    }

    public DocumentField getField(String name) {
        return this.getResult.field(name);
    }

    @Override
    @Deprecated
    public Iterator<DocumentField> iterator() {
        return this.getResult.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.getResult.toXContent(builder, params);
    }

    public static GetResponse fromXContent(XContentParser parser) throws IOException {
        GetResult getResult = GetResult.fromXContent(parser);
        if (getResult.getIndex() == null && getResult.getId() == null) {
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Missing required fields [%s,%s]", "_index", "_id"), new Object[0]);
        }
        return new GetResponse(getResult);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.getResult.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResponse getResponse = (GetResponse)o;
        return Objects.equals(this.getResult, getResponse.getResult);
    }

    public int hashCode() {
        return Objects.hash(this.getResult);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }
}

