/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.NormalizingTokenFilterFactory;

public class TruncateTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private final int length;

    TruncateTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.length = settings.getAsInt("length", Integer.valueOf(-1));
        if (this.length <= 0) {
            throw new IllegalArgumentException("length parameter must be provided");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new TruncateTokenFilter(tokenStream, this.length);
    }
}

