/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.util.function.BiConsumer;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.util.MappedGetter;

public class HistogramRegistry {
    private final long min;
    private final long max;
    private final long step;
    private final MappedGetter<ConnectionRetrievalInfo, Histogram> criHistMap = new MappedGetter();

    public HistogramRegistry(long min, long max, long step) {
        this.min = min;
        this.max = max;
        this.step = step;
    }

    public Histogram getHistogram(ConnectionRetrievalInfo cri) {
        return this.criHistMap.computeIfAbsent(cri, p -> new Histogram(this.min, this.max, this.step));
    }

    public void forEach(BiConsumer<ConnectionRetrievalInfo, Histogram> action) {
        this.criHistMap.forEach(action);
    }
}

