/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;

public abstract class AbstractAnnotationDescriptorRegistry
implements AnnotationDescriptorRegistry {
    protected final Map<Class<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> descriptorMap;
    protected final Map<AnnotationDescriptor<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> repeatableByContainerMap;

    public AbstractAnnotationDescriptorRegistry() {
        this(new ConcurrentHashMap(), new ConcurrentHashMap());
    }

    public AbstractAnnotationDescriptorRegistry(Map<Class<? extends Annotation>, AnnotationDescriptor<?>> descriptorMap, Map<AnnotationDescriptor<?>, AnnotationDescriptor<?>> repeatableByContainerMap) {
        this.descriptorMap = descriptorMap;
        this.repeatableByContainerMap = repeatableByContainerMap;
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> getContainedRepeatableDescriptor(AnnotationDescriptor<A> containerDescriptor) {
        return this.repeatableByContainerMap.get(containerDescriptor);
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> getContainedRepeatableDescriptor(Class<A> containerJavaType) {
        return this.getContainedRepeatableDescriptor(this.getDescriptor(containerJavaType));
    }

    public Map<Class<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> descriptorMap() {
        return this.descriptorMap;
    }

    public Map<Class<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> getDescriptorMap() {
        return Collections.unmodifiableMap(this.descriptorMap);
    }

    public Map<AnnotationDescriptor<? extends Annotation>, AnnotationDescriptor<? extends Annotation>> getRepeatableByContainerMap() {
        return Collections.unmodifiableMap(this.repeatableByContainerMap);
    }
}

