/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;

public class TextStreamOutputEventListener
implements OutputEventListener {
    private final OutputEventListener listener;
    private AtomicReference<LogLevel> logLevel = new AtomicReference<LogLevel>(LogLevel.LIFECYCLE);

    public TextStreamOutputEventListener(OutputEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof StyledTextOutputEvent) {
            this.onTextEvent((StyledTextOutputEvent)event);
        } else if (event instanceof LogLevelChangeEvent) {
            this.onLogLevelChange((LogLevelChangeEvent)event);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void onLogLevelChange(LogLevelChangeEvent changeEvent) {
        this.logLevel.set(changeEvent.getNewLogLevel());
    }

    private void onTextEvent(StyledTextOutputEvent textOutputEvent) {
        if (textOutputEvent.getLogLevel() != null) {
            this.listener.onOutput(textOutputEvent);
        } else {
            this.listener.onOutput(textOutputEvent.withLogLevel(this.logLevel.get()));
        }
    }
}

