/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.apache.commons.io.FileUtils;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadata;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadataStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.execution.steps.WorkspaceResult;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignImmutableWorkspaceStep<C extends IdentityContext>
implements Step<C, WorkspaceResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssignImmutableWorkspaceStep.class);
    private final Deleter deleter;
    private final FileSystemAccess fileSystemAccess;
    private final ImmutableWorkspaceMetadataStore workspaceMetadataStore;
    private final OutputSnapshotter outputSnapshotter;
    private final Step<? super PreviousExecutionContext, ? extends CachingResult> delegate;
    private final LockingStrategy lockingStrategy;

    public AssignImmutableWorkspaceStep(Deleter deleter, FileSystemAccess fileSystemAccess, ImmutableWorkspaceMetadataStore workspaceMetadataStore, OutputSnapshotter outputSnapshotter, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        this(deleter, fileSystemAccess, workspaceMetadataStore, outputSnapshotter, delegate, OperatingSystem.current().isWindows() ? LockingStrategy.WORKSPACE_LOCK : LockingStrategy.ATOMIC_MOVE);
    }

    @VisibleForTesting
    AssignImmutableWorkspaceStep(Deleter deleter, FileSystemAccess fileSystemAccess, ImmutableWorkspaceMetadataStore workspaceMetadataStore, OutputSnapshotter outputSnapshotter, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate, LockingStrategy lockingStrategy) {
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.workspaceMetadataStore = workspaceMetadataStore;
        this.outputSnapshotter = outputSnapshotter;
        this.delegate = delegate;
        this.lockingStrategy = lockingStrategy;
    }

    @Override
    public WorkspaceResult execute(UnitOfWork work, C context) {
        ImmutableWorkspaceProvider workspaceProvider = ((ImmutableUnitOfWork)work).getWorkspaceProvider();
        String uniqueId = ((IdentityContext)context).getIdentity().getUniqueId();
        if (this.lockingStrategy == LockingStrategy.WORKSPACE_LOCK) {
            ImmutableWorkspaceProvider.LockingImmutableWorkspace workspace = workspaceProvider.getLockingWorkspace(uniqueId);
            return workspace.withWorkspaceLock(() -> this.loadImmutableWorkspaceIfExists(work, workspace).orElseGet(() -> {
                this.deleteStaleFiles(workspace.getImmutableLocation());
                return this.executeInWorkspace(work, context, workspace.getImmutableLocation());
            }));
        }
        ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace workspace = workspaceProvider.getAtomicMoveWorkspace(uniqueId);
        return this.loadImmutableWorkspaceIfExists(work, workspace).orElseGet(() -> this.executeInTemporaryWorkspace(work, context, workspace));
    }

    private void deleteStaleFiles(File workspace) {
        try {
            this.deleter.deleteRecursively(workspace);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<WorkspaceResult> loadImmutableWorkspaceIfExists(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File immutableLocation = workspace.getImmutableLocation();
        FileSystemLocationSnapshot snapshot = this.fileSystemAccess.read(immutableLocation.getAbsolutePath());
        switch (snapshot.getType()) {
            case Directory: {
                return this.loadImmutableWorkspaceIfConsistent(work, workspace);
            }
            case RegularFile: {
                throw new IllegalStateException("Immutable workspace is occupied by a file: " + immutableLocation.getAbsolutePath() + ". Deleting the file in question can allow the content to be recreated.");
            }
            case Missing: {
                return Optional.empty();
            }
        }
        throw new AssertionError();
    }

    private Optional<WorkspaceResult> loadImmutableWorkspaceIfConsistent(UnitOfWork work, ImmutableWorkspaceProvider.ImmutableWorkspace workspace) {
        File immutableLocation = workspace.getImmutableLocation();
        Optional<ImmutableWorkspaceMetadata> metadata = this.workspaceMetadataStore.loadWorkspaceMetadata(immutableLocation);
        if (!metadata.isPresent()) {
            return this.handleMissingMetadata(immutableLocation);
        }
        ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots = this.outputSnapshotter.snapshotOutputs(work, immutableLocation);
        ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(outputSnapshots);
        if (!metadata.get().getOutputPropertyHashes().equals(outputHashes)) {
            this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)immutableLocation.getAbsolutePath()));
            String actualOutputHashes = outputSnapshots.entrySet().stream().map(entry -> (String)entry.getKey() + ":\n" + ((FileSystemSnapshot)entry.getValue()).roots().map(AssignImmutableWorkspaceStep::describeSnapshot).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            throw new IllegalStateException(String.format("The contents of the immutable workspace '%s' have been modified. These workspace directories are not supposed to be modified once they are created. The modification might have been caused by an external process, or could be the result of disk corruption.\n%s", immutableLocation.getAbsolutePath(), actualOutputHashes));
        }
        return Optional.of(AssignImmutableWorkspaceStep.loadImmutableWorkspace(work, immutableLocation, metadata.get(), outputSnapshots));
    }

    private Optional<WorkspaceResult> handleMissingMetadata(File immutableLocation) {
        if (this.lockingStrategy == LockingStrategy.WORKSPACE_LOCK) {
            return Optional.empty();
        }
        this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)immutableLocation.getAbsolutePath()));
        if (immutableLocation.exists()) {
            throw new IllegalStateException(String.format("The immutable workspace '%s' exists, but it does not contain the metadata file. This is unexpected might have been caused by an external process or disk corruption. You can try to delete the immutable workspace directory and re-run the build.", immutableLocation.getAbsolutePath()));
        }
        return Optional.empty();
    }

    private static WorkspaceResult loadImmutableWorkspace(UnitOfWork work, File immutableLocation, ImmutableWorkspaceMetadata metadata, ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        OriginMetadata originMetadata = metadata.getOriginMetadata();
        DefaultExecutionOutputState afterExecutionOutputState = new DefaultExecutionOutputState(true, outputSnapshots, originMetadata, true);
        return new WorkspaceResult(CachingResult.shortcutResult(Duration.ZERO, Execution.skipped(Execution.ExecutionOutcome.UP_TO_DATE, work), afterExecutionOutputState, null, originMetadata), immutableLocation);
    }

    private WorkspaceResult executeInWorkspace(UnitOfWork work, C context, File workspace) {
        WorkspaceContext workspaceContext = new WorkspaceContext((IdentityContext)context, workspace, null, true);
        this.fileSystemAccess.invalidate((Iterable)ImmutableList.of((Object)workspace.getAbsolutePath()));
        PreviousExecutionContext previousExecutionContext = new PreviousExecutionContext(workspaceContext, null);
        CachingResult delegateResult = this.delegate.execute(work, previousExecutionContext);
        if (delegateResult.getExecution().isSuccessful()) {
            ExecutionOutputState executionOutputState = delegateResult.getAfterExecutionOutputState().get();
            ImmutableListMultimap<String, HashCode> outputHashes = AssignImmutableWorkspaceStep.calculateOutputHashes(executionOutputState.getOutputFilesProducedByWork());
            ImmutableWorkspaceMetadata metadata = new ImmutableWorkspaceMetadata(executionOutputState.getOriginMetadata(), outputHashes);
            this.workspaceMetadataStore.storeWorkspaceMetadata(workspace, metadata);
            return new WorkspaceResult(delegateResult, workspace);
        }
        return new WorkspaceResult(delegateResult, null);
    }

    private WorkspaceResult executeInTemporaryWorkspace(UnitOfWork work, C context, ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace workspace) {
        return workspace.withTemporaryWorkspace(temporaryWorkspace -> {
            WorkspaceResult result = this.executeInWorkspace(work, context, temporaryWorkspace);
            if (result.getExecution().isSuccessful()) {
                return this.moveTemporaryWorkspaceToImmutableLocation(workspace, new WorkspaceMoveHandler(work, workspace, temporaryWorkspace, result));
            }
            return result;
        });
    }

    private static ImmutableListMultimap<String, HashCode> calculateOutputHashes(ImmutableSortedMap<String, FileSystemSnapshot> outputSnapshots) {
        return (ImmutableListMultimap)outputSnapshots.entrySet().stream().flatMap(entry -> ((FileSystemSnapshot)entry.getValue()).roots().map(locationSnapshot -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)locationSnapshot.getHash()))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private WorkspaceResult moveTemporaryWorkspaceToImmutableLocation(ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace workspace, WorkspaceMoveHandler move) {
        return move.executeMoveOr(moveFailedException -> {
            LOGGER.debug("Could not move temporary workspace ({}) to immutable location ({}), attempting copy-then-move", new Object[]{move.temporaryWorkspace.getAbsolutePath(), workspace.getImmutableLocation().getAbsolutePath(), moveFailedException});
            return workspace.withTemporaryWorkspace(secondaryTemporaryWorkspace -> {
                WorkspaceResult result = move.duplicateTemporaryWorkspaceTo(secondaryTemporaryWorkspace).executeMoveOrThrow();
                move.removeTemporaryWorkspace();
                return result;
            });
        });
    }

    private static String describeSnapshot(FileSystemLocationSnapshot root) {
        final StringBuilder builder = new StringBuilder();
        root.accept(new FileSystemSnapshotHierarchyVisitor(){
            private int indent = 0;

            public void enterDirectory(DirectorySnapshot directorySnapshot) {
                ++this.indent;
            }

            public void leaveDirectory(DirectorySnapshot directorySnapshot) {
                --this.indent;
            }

            public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
                for (int i = 0; i < this.indent; ++i) {
                    builder.append("  ");
                }
                builder.append(" - ");
                builder.append(snapshot.getName());
                builder.append(" (");
                builder.append(snapshot.getType());
                builder.append(", ");
                builder.append(snapshot.getHash());
                builder.append(")");
                builder.append("\n");
                return SnapshotVisitResult.CONTINUE;
            }
        });
        return builder.toString();
    }

    static enum LockingStrategy {
        WORKSPACE_LOCK,
        ATOMIC_MOVE;

    }

    private class WorkspaceMoveHandler {
        private final UnitOfWork work;
        private final ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace workspace;
        private final File temporaryWorkspace;
        private final CachingResult delegateResult;

        public WorkspaceMoveHandler(UnitOfWork work, ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace workspace, File temporaryWorkspace, CachingResult delegateResult) {
            this.work = work;
            this.workspace = workspace;
            this.temporaryWorkspace = temporaryWorkspace;
            this.delegateResult = delegateResult;
        }

        public WorkspaceResult executeMoveOr(Function<FileSystemException, WorkspaceResult> failedMoveHandler) {
            File immutableLocation = this.workspace.getImmutableLocation();
            try {
                AssignImmutableWorkspaceStep.this.fileSystemAccess.moveAtomically(this.temporaryWorkspace.getAbsolutePath(), immutableLocation.getAbsolutePath());
                return new WorkspaceResult(this.delegateResult, immutableLocation);
            }
            catch (FileSystemException moveWorkspaceException) {
                if (immutableLocation.isDirectory()) {
                    LOGGER.debug("Could not move temporary workspace ({}) to immutable location ({}), assuming it was moved in place concurrently", new Object[]{this.temporaryWorkspace.getAbsolutePath(), immutableLocation.getAbsolutePath(), moveWorkspaceException});
                    return AssignImmutableWorkspaceStep.this.loadImmutableWorkspaceIfConsistent(this.work, this.workspace).map(result -> {
                        this.removeTemporaryWorkspace();
                        return result;
                    }).orElseGet(this::executeMoveOrThrow);
                }
                return failedMoveHandler.apply(moveWorkspaceException);
            }
            catch (IOException e) {
                throw this.unableToMoveBecause(e);
            }
        }

        public WorkspaceResult executeMoveOrThrow() {
            return this.executeMoveOr(moveFailedException -> {
                throw this.unableToMoveBecause((IOException)moveFailedException);
            });
        }

        public WorkspaceMoveHandler duplicateTemporaryWorkspaceTo(File duplicateTemporaryWorkspace) {
            try {
                FileUtils.copyDirectory((File)this.temporaryWorkspace, (File)duplicateTemporaryWorkspace, file -> true, (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
            }
            catch (IOException duplicateCopyException) {
                throw new UncheckedIOException(String.format("Could not make copy of temporary workspace (%s) to (%s)", this.temporaryWorkspace.getAbsolutePath(), duplicateTemporaryWorkspace.getAbsolutePath()), duplicateCopyException);
            }
            return new WorkspaceMoveHandler(this.work, this.workspace, duplicateTemporaryWorkspace, this.delegateResult);
        }

        private void removeTemporaryWorkspace() {
            try {
                AssignImmutableWorkspaceStep.this.deleter.deleteRecursively(this.temporaryWorkspace);
            }
            catch (IOException removeTempException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not remove temporary workspace: {}", (Object)this.temporaryWorkspace.getAbsolutePath(), (Object)removeTempException);
                }
                LOGGER.info("Could not remove temporary workspace: {}: {}", (Object)this.temporaryWorkspace.getAbsolutePath(), (Object)removeTempException.getMessage());
            }
        }

        @CheckReturnValue
        private UncheckedIOException unableToMoveBecause(IOException cause) {
            return new UncheckedIOException(String.format("Could not move temporary workspace (%s) to immutable location (%s)", this.temporaryWorkspace.getAbsolutePath(), this.workspace.getImmutableLocation().getAbsolutePath()), cause);
        }
    }
}

