/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeAliasDescriptor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\"\u0015\u0010\b\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"isContainedByCompiledPartOfOurModule", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "friendPath", "Ljava/io/File;", "getSourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "toSourceElement", "getToSourceElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nmoduleVisibilityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 moduleVisibilityUtils.kt\norg/jetbrains/kotlin/load/kotlin/ModuleVisibilityUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class ModuleVisibilityUtilsKt {
    public static final boolean isContainedByCompiledPartOfOurModule(@NotNull DeclarationDescriptor descriptor, @Nullable File friendPath) {
        block21: {
            KotlinJvmBinaryClass binaryClass;
            KotlinJvmBinaryClass kotlinJvmBinaryClass;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (friendPath == null) {
                return false;
            }
            PackageFragmentDescriptor packageFragment = DescriptorUtils.getParentOfType(descriptor, PackageFragmentDescriptor.class, false);
            if (!(packageFragment instanceof LazyJavaPackageFragment)) {
                return false;
            }
            SourceElement source = ModuleVisibilityUtilsKt.getSourceElement(descriptor);
            SourceElement sourceElement = source;
            if (sourceElement instanceof KotlinJvmBinarySourceElement) {
                kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement) {
                if (descriptor instanceof DeserializedMemberDescriptor) {
                    kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)descriptor);
                    if (kotlinJvmBinaryClass == null) {
                        kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
                    }
                } else {
                    kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
                }
            } else {
                kotlinJvmBinaryClass = binaryClass = null;
            }
            if (!(binaryClass instanceof VirtualFileKotlinClass)) break block21;
            VirtualFile file = ((VirtualFileKotlinClass)binaryClass).getFile();
            switch (file.getFileSystem().getProtocol()) {
                case "file": {
                    File file2 = VfsUtilCore.virtualToIoFile(file);
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
                    File ioFile = file2;
                    return ioFile.toPath().startsWith(friendPath.toPath());
                }
                case "jar": {
                    File file3;
                    VirtualFile virtualFile = VfsUtilCore.getVirtualFileForJar(file);
                    if (virtualFile != null) {
                        VirtualFile p0 = virtualFile;
                        boolean bl = false;
                        file3 = VfsUtilCore.virtualToIoFile(p0);
                    } else {
                        file3 = null;
                    }
                    File ioFile = file3;
                    return ioFile != null && Intrinsics.areEqual((Object)ioFile.toPath(), (Object)friendPath.toPath());
                }
            }
        }
        return false;
    }

    @NotNull
    public static final SourceElement getSourceElement(@NotNull DeclarationDescriptor descriptor) {
        SourceElement sourceElement;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getSource() == SourceElement.NO_SOURCE) {
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            sourceElement = ModuleVisibilityUtilsKt.getSourceElement(declarationDescriptor);
        } else if (descriptor instanceof DeserializedTypeAliasDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((DeserializedTypeAliasDescriptor)descriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            sourceElement = ModuleVisibilityUtilsKt.getSourceElement(declarationDescriptor);
        } else {
            sourceElement = ModuleVisibilityUtilsKt.getToSourceElement(descriptor);
        }
        return sourceElement;
    }

    @NotNull
    public static final SourceElement getToSourceElement(@NotNull DeclarationDescriptor $this$toSourceElement) {
        SourceElement sourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$toSourceElement, (String)"<this>");
        if ($this$toSourceElement instanceof DeclarationDescriptorWithSource) {
            SourceElement sourceElement2 = ((DeclarationDescriptorWithSource)$this$toSourceElement).getSource();
            sourceElement = sourceElement2;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement2, (String)"getSource(...)");
        } else {
            SourceElement sourceElement3 = SourceElement.NO_SOURCE;
            sourceElement = sourceElement3;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement3, (String)"NO_SOURCE");
        }
        return sourceElement;
    }
}

