/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawCodeUnitDependency;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class RawAccessRecord
implements RawCodeUnitDependency<TargetInfo> {
    private final CodeUnit origin;
    private final TargetInfo target;
    private final int lineNumber;
    private final boolean declaredInLambda;

    RawAccessRecord(CodeUnit origin, TargetInfo target, int lineNumber, boolean declaredInLambda) {
        this.origin = Preconditions.checkNotNull(origin);
        this.target = Preconditions.checkNotNull(target);
        this.lineNumber = lineNumber;
        this.declaredInLambda = declaredInLambda;
    }

    @Override
    public CodeUnit getOrigin() {
        return this.origin;
    }

    @Override
    public TargetInfo getTarget() {
        return this.target;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean isDeclaredInLambda() {
        return this.declaredInLambda;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.fieldsAsString() + '}';
    }

    private String fieldsAsString() {
        return "origin=" + this.origin + ", target=" + this.target + ", lineNumber=" + this.lineNumber + ", declaredInLambda=" + this.declaredInLambda;
    }

    static class CodeUnit
    implements MemberSignature {
        private final String name;
        private final String descriptor;
        private final List<JavaClassDescriptor> rawParameterTypes;
        private final List<String> rawParameterTypeNames;
        private final String declaringClassName;
        private final int hashCode;

        CodeUnit(String name, String descriptor, String declaringClassName) {
            this.name = name;
            this.descriptor = descriptor;
            this.rawParameterTypes = JavaClassDescriptorImporter.importAsmMethodArgumentTypes(descriptor);
            this.rawParameterTypeNames = CodeUnit.namesOf(this.rawParameterTypes);
            this.declaringClassName = declaringClassName;
            this.hashCode = Objects.hash(name, descriptor, declaringClassName);
        }

        private static List<String> namesOf(Iterable<JavaClassDescriptor> descriptors) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor descriptor : descriptors) {
                result.add(descriptor.getFullyQualifiedClassName());
            }
            return result.build();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        List<JavaClassDescriptor> getRawParameterTypes() {
            return this.rawParameterTypes;
        }

        List<String> getRawParameterTypeNames() {
            return this.rawParameterTypeNames;
        }

        @Override
        public String getDeclaringClassName() {
            return this.declaringClassName;
        }

        JavaCodeUnit resolveFrom(ImportedClasses classes) {
            for (JavaCodeUnit method : classes.getOrResolve(this.getDeclaringClassName()).getCodeUnits()) {
                if (!this.is(method)) continue;
                return method;
            }
            throw new IllegalStateException("Never found a " + JavaCodeUnit.class.getSimpleName() + " that matches supposed origin " + this);
        }

        private boolean is(JavaCodeUnit method) {
            return this.getName().equals(method.getName()) && this.descriptor.equals(method.getDescriptor()) && this.getDeclaringClassName().equals(method.getOwner().getName());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeUnit codeUnit = (CodeUnit)o;
            return Objects.equals(this.name, codeUnit.name) && Objects.equals(this.descriptor, codeUnit.descriptor) && Objects.equals(this.declaringClassName, codeUnit.declaringClassName);
        }

        public String toString() {
            return "CodeUnit{name='" + this.name + '\'' + ", descriptor=" + this.descriptor + ", declaringClassName='" + this.declaringClassName + '\'' + '}';
        }
    }

    static final class TargetInfo
    implements MemberSignature {
        final JavaClassDescriptor owner;
        final String name;
        final String desc;
        private final int hashCode;

        TargetInfo(String owner, String name, String desc) {
            this.owner = JavaClassDescriptorImporter.createFromAsmObjectTypeName(owner);
            this.name = name;
            this.desc = desc;
            this.hashCode = Objects.hash(owner, name, desc);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.desc;
        }

        @Override
        public String getDeclaringClassName() {
            return this.owner.getFullyQualifiedClassName();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TargetInfo other = (TargetInfo)obj;
            return Objects.equals(this.owner, other.owner) && Objects.equals(this.name, other.name) && Objects.equals(this.desc, other.desc);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{owner='" + this.owner.getFullyQualifiedClassName() + "', name='" + this.name + "', desc='" + this.desc + "'}";
        }
    }

    static class ForField
    extends RawAccessRecord {
        final JavaFieldAccess.AccessType accessType;

        private ForField(CodeUnit origin, TargetInfo target, int lineNumber, JavaFieldAccess.AccessType accessType, boolean declaredInLambda) {
            super(origin, target, lineNumber, declaredInLambda);
            this.accessType = accessType;
        }

        static class Builder
        extends BaseBuilder<ForField, Builder> {
            private JavaFieldAccess.AccessType accessType;

            Builder() {
            }

            Builder withAccessType(JavaFieldAccess.AccessType accessType) {
                this.accessType = accessType;
                return this;
            }

            @Override
            public ForField build() {
                return new ForField(this.origin, this.target, this.lineNumber, this.accessType, this.declaredInLambda);
            }
        }
    }

    static abstract class BaseBuilder<ACCESS extends RawAccessRecord, SELF extends BaseBuilder<ACCESS, SELF>>
    implements RawCodeUnitDependency.Builder<ACCESS, TargetInfo> {
        CodeUnit origin;
        TargetInfo target;
        int lineNumber = -1;
        boolean declaredInLambda = false;

        BaseBuilder() {
        }

        public SELF withOrigin(CodeUnit origin) {
            this.origin = origin;
            return this.self();
        }

        public SELF withTarget(TargetInfo target) {
            this.target = target;
            return this.self();
        }

        public SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        public SELF withDeclaredInLambda(boolean declaredInLambda) {
            this.declaredInLambda = declaredInLambda;
            return this.self();
        }

        SELF self() {
            return (SELF)this;
        }
    }

    static class Builder
    extends BaseBuilder<RawAccessRecord, Builder> {
        Builder() {
        }

        @Override
        public RawAccessRecord build() {
            return new RawAccessRecord(this.origin, this.target, this.lineNumber, this.declaredInLambda);
        }
    }

    static interface MemberSignature {
        public String getName();

        public String getDescriptor();

        public String getDeclaringClassName();
    }
}

