/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemRenderer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.utils.CommonUtils;

public class DashboardRendererDescriptor
extends AbstractContextDescriptor
implements DashboardRendererType {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dashboard.ui";
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final AbstractDescriptor.ObjectType implType;
    private final AbstractDescriptor.ObjectType itemConfigurationEditor;
    private final AbstractDescriptor.ObjectType itemViewSettingsEditor;
    private final DBDashboardDataType[] supportedDataTypes;
    private final boolean nativeRenderer;

    DashboardRendererDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String[] dataTypeNames = CommonUtils.notEmpty((String)config.getAttribute("dataTypes")).split(",");
        this.supportedDataTypes = new DBDashboardDataType[dataTypeNames.length];
        for (int i = 0; i < dataTypeNames.length; ++i) {
            this.supportedDataTypes[i] = (DBDashboardDataType)CommonUtils.valueOf(DBDashboardDataType.class, (String)dataTypeNames[i], (Enum)DBDashboardDataType.timeseries);
        }
        this.nativeRenderer = CommonUtils.toBoolean((Object)config.getAttribute("native"));
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("renderer"));
        this.itemConfigurationEditor = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("configurationEditor"));
        this.itemViewSettingsEditor = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("viewSettingsEditor"));
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DBPImage getIcon() {
        return this.icon;
    }

    @Override
    public DBDashboardDataType[] getSupportedTypes() {
        return this.supportedDataTypes;
    }

    public boolean isNativeRenderer() {
        return this.nativeRenderer;
    }

    @Override
    public DashboardItemRenderer createRenderer() throws DBException {
        return (DashboardItemRenderer)this.implType.createInstance(DashboardItemRenderer.class);
    }

    public IObjectPropertyConfigurator<DashboardItemConfiguration, DashboardItemConfiguration> createItemConfigurationEditor() throws DBException {
        return (IObjectPropertyConfigurator)this.itemConfigurationEditor.createInstance(IObjectPropertyConfigurator.class);
    }

    public IObjectPropertyConfigurator<DashboardItemViewSettings, DashboardItemViewSettings> createItemViewSettingsEditor() throws DBException {
        return (IObjectPropertyConfigurator)this.itemViewSettingsEditor.createInstance(IObjectPropertyConfigurator.class);
    }

    public String toString() {
        return this.id;
    }
}

