/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.utils.CommonUtils;

public class DatabaseChartViewSettingsEditor
implements IObjectPropertyConfigurator<DashboardItemViewSettings, DashboardItemViewSettings> {
    public void createControl(@NotNull Composite composite, final DashboardItemViewSettings dashboardConfig, @NotNull Runnable propertyChangeListener) {
        Composite updateGroup = UIUtils.createTitledComposite((Composite)composite, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardupdate, (int)2, (int)768);
        Text updatePeriodText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardupdate_labels_updateperiod, (String)String.valueOf(dashboardConfig.getUpdatePeriod()), (int)2048, (Object)new GridData(768));
        updatePeriodText.addModifyListener(e -> dashboardConfig.setUpdatePeriod(CommonUtils.toLong((Object)updatePeriodText.getText(), (long)dashboardConfig.getUpdatePeriod())));
        Text maxItemsText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardupdate_labels_maxitems, (String)String.valueOf(dashboardConfig.getMaxItems()), (int)2048, (Object)new GridData(768));
        maxItemsText.addModifyListener(e -> dashboardConfig.setMaxItems(CommonUtils.toInt((Object)maxItemsText.getText(), (int)dashboardConfig.getMaxItems())));
        Composite viewGroup = UIUtils.createTitledComposite((Composite)composite, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview, (int)2, (int)768);
        final Combo typeCombo = UIUtils.createLabelCombo((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_combos_view, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_combos_view_tooltip, (int)2056);
        typeCombo.setLayoutData((Object)new GridData(768));
        final List<DashboardRendererType> viewTypes = DashboardUIRegistry.getInstance().getSupportedViewTypes(dashboardConfig.getItemConfiguration().getDataType());
        for (DashboardRendererType viewType : viewTypes) {
            typeCombo.add(viewType.getTitle());
        }
        typeCombo.setText(dashboardConfig.getViewType().getTitle());
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                dashboardConfig.setViewType((DashboardRendererType)viewTypes.get(typeCombo.getSelectionIndex()));
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_legend, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_legend_tooltip, (boolean)dashboardConfig.isLegendVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                dashboardConfig.setLegendVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_grid, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_grid_tooltip, (boolean)dashboardConfig.isGridVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                dashboardConfig.setGridVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_domainaxis, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_domainaxis_tooltip, (boolean)dashboardConfig.isDomainTicksVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                dashboardConfig.setDomainTicksVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_rangeaxis, (String)UIDashboardMessages.dialog_dashboard_item_config_dashboardview_checkboxes_rangeaxis_tooltip, (boolean)dashboardConfig.isRangeTicksVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                dashboardConfig.setRangeTicksVisible(((Button)e.widget).getSelection());
            }
        });
    }

    public void loadSettings(@NotNull DashboardItemViewSettings viewSettings) {
    }

    public void saveSettings(@NotNull DashboardItemViewSettings viewSettings) {
    }

    public void resetSettings(@NotNull DashboardItemViewSettings viewSettings) {
    }

    public boolean isComplete() {
        return true;
    }
}

