/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNode;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class MySQLPlanNodePlain
extends MySQLPlanNode {
    protected Integer id;
    protected String selectType;
    protected String table;
    protected String type;
    protected String possibleKeys;
    protected String key;
    protected String keyLength;
    protected String ref;
    protected Long rowCount;
    protected Long filtered;
    protected String extra;
    protected MySQLPlanNodePlain parent;
    protected List<MySQLPlanNodePlain> nested;

    public MySQLPlanNodePlain(List<MySQLPlanNodePlain> nodes) {
        this.type = "<plan>";
        if (!nodes.isEmpty()) {
            this.rowCount = nodes.get((int)0).rowCount;
        }
        this.nested = nodes;
    }

    public MySQLPlanNodePlain(MySQLPlanNodePlain parent, ResultSet dbResult) {
        this.parent = parent;
        this.id = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"id");
        this.selectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"select_type");
        this.table = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type");
        this.possibleKeys = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"possible_keys");
        this.key = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"key");
        this.keyLength = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"key_len");
        this.ref = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ref");
        this.rowCount = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"rows");
        this.filtered = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"filtered");
        this.extra = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extra");
    }

    public MySQLPlanNodePlain(MySQLPlanNodePlain parent, Map<String, Object> props) {
        this.parent = parent;
        this.id = props.containsKey("id") ? Integer.valueOf(CommonUtils.toInt((Object)props.get("id"))) : null;
        this.selectType = JSONUtils.getString(props, (String)"select_type");
        this.table = JSONUtils.getString(props, (String)"table");
        this.type = JSONUtils.getString(props, (String)"type");
        this.possibleKeys = JSONUtils.getString(props, (String)"possible_keys");
        this.key = JSONUtils.getString(props, (String)"key");
        this.keyLength = JSONUtils.getString(props, (String)"key_len");
        this.ref = JSONUtils.getString(props, (String)"ref");
        this.rowCount = props.containsKey("rows") ? Long.valueOf(CommonUtils.toLong((Object)props.get("rows"))) : null;
        this.filtered = props.containsKey("filtered") ? Long.valueOf(CommonUtils.toLong((Object)props.get("filtered"))) : null;
        this.extra = JSONUtils.getString(props, (String)"extra");
    }

    public MySQLPlanNodePlain(MySQLPlanNodePlain parent, String type) {
        this.parent = parent;
        this.selectType = type;
    }

    protected MySQLPlanNodePlain(MySQLPlanNodePlain parent, MySQLPlanNodePlain source) {
        this.id = source.id;
        this.selectType = source.selectType;
        this.table = source.table;
        this.type = source.type;
        this.possibleKeys = source.possibleKeys;
        this.key = source.key;
        this.keyLength = source.keyLength;
        this.ref = source.ref;
        this.rowCount = source.rowCount;
        this.filtered = source.filtered;
        this.extra = source.extra;
        this.parent = parent;
        if (source.nested != null) {
            this.nested = new ArrayList<MySQLPlanNodePlain>(source.nested.size());
            for (MySQLPlanNodePlain srcNode : source.nested) {
                this.nested.add(srcNode.copyNode(this));
            }
        }
    }

    public MySQLPlanNodePlain getParent() {
        return this.parent;
    }

    void setParent(MySQLPlanNodePlain node) {
        if (this.parent != null && this.parent.nested != null) {
            this.parent.nested.remove((Object)this);
        }
        this.parent = node;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    private void addChild(MySQLPlanNodePlain node) {
        if (this.nested == null) {
            this.nested = new ArrayList<MySQLPlanNodePlain>();
        }
        this.nested.add(node);
    }

    public String getNodeName() {
        return this.table;
    }

    public DBCPlanNodeKind getNodeKind() {
        if ("SIMPLE".equals(this.selectType)) {
            return DBCPlanNodeKind.SELECT;
        }
        if ("JOIN".equals(this.selectType)) {
            return DBCPlanNodeKind.JOIN;
        }
        if ("UNION".equals(this.selectType)) {
            return DBCPlanNodeKind.UNION;
        }
        return super.getNodeKind();
    }

    public String getNodeDescription() {
        return this.ref;
    }

    @Property(order=3, viewable=true)
    public String getNodeType() {
        return this.selectType;
    }

    public List<MySQLPlanNodePlain> getNested() {
        return this.nested;
    }

    @Property(order=0, viewable=true)
    public Integer getId() {
        return this.id;
    }

    @Property(order=1, viewable=true)
    public String getSelectType() {
        return this.selectType;
    }

    @Property(order=2, viewable=true)
    public String getTable() {
        return this.table;
    }

    @Property(order=4, viewable=true)
    public String getPossibleKeys() {
        return this.possibleKeys;
    }

    @Property(order=5, viewable=true)
    public String getKey() {
        return this.key;
    }

    @Property(order=6, viewable=true)
    public String getKeyLength() {
        return this.keyLength;
    }

    @Property(order=7, viewable=true)
    public String getRef() {
        return this.ref;
    }

    @Property(order=8, viewable=true)
    public Long getRowCount() {
        return this.rowCount;
    }

    @Property(order=9, viewable=true)
    public Long getFiltered() {
        return this.filtered;
    }

    @Property(order=10, viewable=true)
    public String getExtra() {
        return this.extra;
    }

    public Number getNodeCost() {
        return null;
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    public Number getNodeRowCount() {
        return this.rowCount;
    }

    public boolean isCompositeNode() {
        return "PRIMARY".equals(this.selectType);
    }

    public String toString() {
        return this.id + " " + this.selectType + " " + this.table;
    }

    void computeStats() {
        if (this.nested != null) {
            for (MySQLPlanNodePlain child : this.nested) {
                child.computeStats();
            }
        }
        if (this.rowCount == null && this.nested != null) {
            long calcCount = 0L;
            for (MySQLPlanNodePlain child : this.nested) {
                child.computeStats();
                calcCount += CommonUtils.toLong((Object)child.getRowCount());
            }
            this.rowCount = calcCount;
        }
    }

    MySQLPlanNodePlain copyNode(MySQLPlanNodePlain parent) {
        return new MySQLPlanNodePlain(parent, this);
    }
}

