/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.exec;

import java.time.Duration;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScript;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.utils.DurationFormat;
import org.jkiss.dbeaver.utils.DurationFormatter;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SQLScriptProcessor {
    private static final String STAT_LOG_PREFIX = "-----------------> ";
    private final DBCExecutionContext executionContext;
    private final List<SQLScriptElement> queries;
    private final SQLScriptContext scriptContext;
    private final DBDDataReceiver dataReceiver;
    private final Log log;
    private Throwable lastError = null;
    private DBCStatistics statistics;
    private final DBCStatistics totalStatistics = new DBCStatistics();
    private int fetchSize;
    private long offset;
    private long maxRows;
    private long fetchFlags;
    private SQLScriptCommitType commitType = SQLScriptCommitType.AUTOCOMMIT;
    private SQLScriptErrorHandling errorHandling = SQLScriptErrorHandling.STOP_ROLLBACK;

    public SQLScriptProcessor(@NotNull DBCExecutionContext executionContext, @NotNull List<SQLScriptElement> queries, @NotNull SQLScriptContext scriptContext, @NotNull DBDDataReceiver dataReceiver, @NotNull Log log) {
        this.executionContext = executionContext;
        this.queries = queries;
        this.scriptContext = scriptContext;
        this.dataReceiver = dataReceiver;
        this.log = log;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    public void setFetchFlags(long fetchFlags) {
        this.fetchFlags = fetchFlags;
    }

    public SQLScriptCommitType getCommitType() {
        return this.commitType;
    }

    public void setCommitType(SQLScriptCommitType commitType) {
        this.commitType = commitType;
    }

    public SQLScriptErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public void setErrorHandling(SQLScriptErrorHandling errorHandling) {
        this.errorHandling = errorHandling;
    }

    public void runScript(DBRProgressMonitor monitor) throws DBCException {
        RuntimeUtils.setThreadName((String)"SQL script execution");
        this.statistics = new DBCStatistics();
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.executionContext);
            try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.USER_SCRIPT, "SQL Query");){
                boolean newAutoCommit;
                if (session.isLoggingEnabled()) {
                    QMUtils.getDefaultHandler().handleScriptBegin(session);
                }
                boolean oldAutoCommit = txnManager == null || txnManager.isAutoCommit();
                boolean bl = newAutoCommit = this.commitType == SQLScriptCommitType.AUTOCOMMIT;
                if (txnManager != null && txnManager.isSupportsTransactions() && oldAutoCommit != newAutoCommit) {
                    txnManager.setAutoCommit(monitor, newAutoCommit);
                }
                monitor.beginTask("Execute queries (" + this.queries.size() + ")", this.queries.size());
                this.executeScript(session, this.queries, true);
                monitor.done();
                if (txnManager != null && txnManager.isSupportsTransactions() && !oldAutoCommit && this.commitType != SQLScriptCommitType.AUTOCOMMIT) {
                    monitor.beginTask("Finish transaction", 1);
                    if (this.lastError == null || this.errorHandling == SQLScriptErrorHandling.STOP_COMMIT) {
                        if (this.commitType != SQLScriptCommitType.NO_COMMIT) {
                            monitor.subTask("Commit");
                            txnManager.commit(session);
                        }
                    } else if (this.errorHandling == SQLScriptErrorHandling.STOP_ROLLBACK) {
                        monitor.subTask("Rollback");
                        txnManager.rollback(session, null);
                    } else {
                        monitor.subTask("Script executed with errors. Changes were not committed.");
                    }
                    monitor.done();
                }
                if (txnManager != null && txnManager.isSupportsTransactions() && oldAutoCommit != newAutoCommit) {
                    txnManager.setAutoCommit(monitor, oldAutoCommit);
                }
                if (session.isLoggingEnabled()) {
                    QMUtils.getDefaultHandler().handleScriptEnd(session);
                }
            }
        }
        catch (Throwable ex) {
            throw new DBCException("Error during SQL script execution", ex);
        }
        if (this.lastError != null && this.errorHandling != SQLScriptErrorHandling.IGNORE) {
            throw new DBCException("Script execute failed", this.lastError);
        }
    }

    private void executeScript(@NotNull DBCSession session, @NotNull List<SQLScriptElement> script, boolean trackMonitor) {
        for (SQLScriptElement query : script) {
            if (session.getProgressMonitor().isCanceled()) break;
            boolean runNext = this.executeSingleQuery(session, query);
            if (!runNext) {
                if (this.lastError == null) break;
                if (this.errorHandling != SQLScriptErrorHandling.IGNORE) {
                    this.log.error((Object)this.lastError);
                    break;
                }
                this.log.warn((Object)("Query failed: " + this.lastError.getMessage()));
            }
            if (!trackMonitor) continue;
            session.getProgressMonitor().worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSingleQuery(@NotNull DBCSession session, @NotNull SQLScriptElement element) {
        if (element instanceof SQLControlCommand) {
            SQLControlCommand controlCommand = (SQLControlCommand)element;
            this.log.debug((Object)("-----------------> Execute command\n" + element.getText()));
            try {
                SQLControlResult controlResult = this.scriptContext.executeControlCommand(session.getProgressMonitor(), controlCommand);
                if (controlResult.getTransformed() == null) {
                    return true;
                }
                element = controlResult.getTransformed();
            }
            catch (Throwable e) {
                if (!(e instanceof DBException)) {
                    this.log.error((Object)"Unexpected error while processing SQL command", e);
                }
                this.lastError = e;
                return false;
            }
        }
        if (element instanceof SQLScript) {
            SQLScript script = (SQLScript)element;
            this.executeScript(session, script.getScriptElements(), false);
        } else {
            if (!(element instanceof SQLQuery)) {
                this.log.error((Object)("Unsupported SQL element type: " + String.valueOf(element)));
                return false;
            }
            SQLQuery sqlQuery = (SQLQuery)element;
            this.scriptContext.fillQueryParameters(sqlQuery, () -> this.dataReceiver, true);
            this.lastError = null;
            try {
                this.statistics.reset();
                this.statistics.setQueryText(sqlQuery.getText());
                DBExecUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), param -> {
                    long execStartTime = System.currentTimeMillis();
                    this.executeStatement(session, sqlQuery, execStartTime);
                });
            }
            catch (Throwable ex) {
                if (!(ex instanceof DBException)) {
                    this.log.error((Object)"Unexpected error while processing SQL", ex);
                }
                this.lastError = ex;
            }
            finally {
                this.scriptContext.clearStatementContext();
            }
        }
        return this.lastError == null || this.errorHandling == SQLScriptErrorHandling.IGNORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeStatement(@NotNull DBCSession session, SQLQuery sqlQuery, long startTime) throws DBException {
        SQLQueryDataContainer dataContainer = new SQLQueryDataContainer(() -> this.executionContext, sqlQuery, this.scriptContext, this.log);
        AbstractExecutionSource source = new AbstractExecutionSource((DBSDataContainer)dataContainer, session.getExecutionContext(), (Object)this, (Object)sqlQuery);
        DBCStatement statement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)this.offset, (long)this.maxRows);
        DBExecUtils.setStatementFetchSize((DBCStatement)statement, (long)0L, (long)this.maxRows, (int)this.fetchSize);
        try {
            this.log.debug((Object)("-----------------> Execute query\n" + sqlQuery.getText()));
            boolean hasResultSet = statement.executeStatement();
            this.statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            this.statistics.addStatementsCount();
            long updateCount = -1L;
            while (true) {
                if (hasResultSet) {
                    DBCResultSet resultSet = statement.openResultSet();
                    if (resultSet == null) break;
                    hasResultSet = this.fetchQueryData(session, resultSet, this.dataReceiver);
                }
                if (!hasResultSet) {
                    try {
                        updateCount = statement.getUpdateRowCount();
                        if (updateCount >= 0L) {
                            this.statistics.addRowsUpdated(updateCount);
                        }
                    }
                    catch (DBCException e) {
                        this.log.warn((Object)"Can't obtain update count", (Throwable)e);
                    }
                }
                if (!hasResultSet && updateCount < 0L || !session.getDataSource().getInfo().supportsMultipleResults()) break;
                try {
                    hasResultSet = statement.nextResults();
                }
                catch (DBCException e) {
                    if (!session.getDataSource().getInfo().isMultipleResultsFetchBroken()) throw e;
                    this.log.error((Object)e);
                    hasResultSet = statement.nextResults();
                }
                updateCount = hasResultSet ? -1L : 0L;
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable[] warnings = statement.getStatementWarnings();
                if (warnings != null) {
                    for (Throwable warning : warnings) {
                        this.scriptContext.getOutputWriter().println(null, warning.getMessage());
                    }
                }
            }
            catch (Throwable e) {
                this.log.warn((Object)"Can't read execution warnings", e);
            }
            try {
                statement.close();
            }
            catch (Throwable e) {
                this.log.error((Object)"Error closing statement", e);
            }
            String duration = DurationFormatter.format((Duration)Duration.ofMillis(this.statistics.getExecuteTime()), (DurationFormat)DurationFormat.MEDIUM);
            this.log.debug((Object)("-----------------> Time: " + duration + (String)(this.statistics.getRowsFetched() >= 0L ? ", fetched " + this.statistics.getRowsFetched() + " row(s)" : "") + (String)(this.statistics.getRowsUpdated() >= 0L ? ", updated " + this.statistics.getRowsUpdated() + " row(s)" : "")));
            this.totalStatistics.accumulate(this.statistics);
            throw throwable;
        }
        try {
            Throwable[] warnings = statement.getStatementWarnings();
            if (warnings != null) {
                for (Throwable warning : warnings) {
                    this.scriptContext.getOutputWriter().println(null, warning.getMessage());
                }
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Can't read execution warnings", e);
        }
        try {
            statement.close();
        }
        catch (Throwable e) {
            this.log.error((Object)"Error closing statement", e);
        }
        String duration = DurationFormatter.format((Duration)Duration.ofMillis(this.statistics.getExecuteTime()), (DurationFormat)DurationFormat.MEDIUM);
        this.log.debug((Object)("-----------------> Time: " + duration + (String)(this.statistics.getRowsFetched() >= 0L ? ", fetched " + this.statistics.getRowsFetched() + " row(s)" : "") + (String)(this.statistics.getRowsUpdated() >= 0L ? ", updated " + this.statistics.getRowsUpdated() + " row(s)" : "")));
        this.totalStatistics.accumulate(this.statistics);
    }

    private boolean fetchQueryData(DBCSession session, DBCResultSet resultSet, DBDDataReceiver dataReceiver) throws DBException {
        if (dataReceiver == null) {
            return false;
        }
        if (resultSet == null) {
            return false;
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Fetch result set");
        DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)0L, (long)0L);
        try (DBCResultSet dBCResultSet = resultSet;){
            long fetchStartTime = System.currentTimeMillis();
            while (!fetchProgress.isCanceled() && resultSet.nextRow()) {
                dataReceiver.fetchRow(session, resultSet);
                fetchProgress.monitorRowFetch();
            }
            this.statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
        }
        this.statistics.setRowsFetched(fetchProgress.getRowCount());
        monitor.subTask(fetchProgress.getRowCount() + " rows fetched");
        return true;
    }

    public DBCStatistics getTotalStatistics() {
        return this.totalStatistics;
    }
}

