/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PlacementFrame {
    protected int numOfThreads;
    protected int runtime;
    private Cell originalCell;
    private boolean failure = false;
    private Cell redispCell = null;
    private ArrayList<PlacementParameter> allParameters = new ArrayList();

    public abstract void runPlacement(List<PlacementNode> var1, List<PlacementNetwork> var2, List<PlacementAdapter.PlacementExport> var3, String var4, Job var5);

    public abstract String getAlgorithmName();

    public final List<PlacementParameter> getParameters() {
        return this.allParameters;
    }

    public void setParamterValues(int threads, int runtime) {
        this.numOfThreads = threads;
        this.runtime = runtime;
    }

    public void setOriginalCell(Cell cell) {
        this.originalCell = cell;
    }

    public Cell getOriginalCell() {
        return this.originalCell;
    }

    public void setRedispCell(Cell r) {
        this.redispCell = r;
    }

    public Cell getRedispCell() {
        return this.redispCell;
    }

    public void setFailure(boolean f) {
        this.failure = f;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public static double getStandardCellSize(List<PlacementNode> placementNodes, MutableBoolean sizeIsWidth) {
        double girth;
        HashMap<Double, Integer> widths = new HashMap<Double, Integer>();
        HashMap<Double, Integer> heights = new HashMap<Double, Integer>();
        for (PlacementNode p : placementNodes) {
            double width = p.getWidth();
            Double dWidth = width;
            Integer numWid = (Integer)widths.get(dWidth);
            if (numWid == null) {
                numWid = 0;
                widths.put(dWidth, numWid);
            }
            numWid = numWid + 1;
            widths.put(dWidth, numWid);
            double height = p.getHeight();
            Double dHeight = height;
            Integer numHei = (Integer)heights.get(dHeight);
            if (numHei == null) {
                numHei = 0;
                heights.put(dHeight, numHei);
            }
            numHei = numHei + 1;
            heights.put(dHeight, numHei);
        }
        Double mostCommonWidth = null;
        int numMostCommonWidth = 0;
        for (Double g : widths.keySet()) {
            Integer count = (Integer)widths.get(g);
            if (count <= numMostCommonWidth) continue;
            numMostCommonWidth = count;
            mostCommonWidth = g;
        }
        Double mostCommonHeight = null;
        int numMostCommonHeight = 0;
        for (Double g : heights.keySet()) {
            Integer count = (Integer)heights.get(g);
            if (count <= numMostCommonHeight) continue;
            numMostCommonHeight = count;
            mostCommonHeight = g;
        }
        if (numMostCommonWidth > numMostCommonHeight) {
            if (sizeIsWidth != null) {
                sizeIsWidth.setValue(true);
            }
            girth = mostCommonWidth;
        } else {
            if (sizeIsWidth != null) {
                sizeIsWidth.setValue(false);
            }
            girth = mostCommonHeight;
        }
        return girth;
    }

    public static abstract class PlacementNode {
        private double xPos;
        private double yPos;
        private Orientation orient;
        private Object userObject;

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object obj) {
            this.userObject = obj;
        }

        public abstract List<PlacementPort> getPorts();

        public abstract double getWidth();

        public abstract double getHeight();

        public void setPlacement(double x, double y) {
            this.xPos = x;
            this.yPos = y;
        }

        public void setOrientation(Orientation o) {
            this.orient = o;
            for (PlacementPort plPort : this.getPorts()) {
                plPort.computeRotatedOffset();
            }
        }

        public double getPlacementX() {
            return this.xPos;
        }

        public double getPlacementY() {
            return this.yPos;
        }

        public Orientation getPlacementOrientation() {
            return this.orient;
        }

        public abstract String getTypeName();
    }

    public static class PlacementNetwork {
        private List<PlacementPort> portsOnNet;
        private boolean isOnRail;

        public PlacementNetwork(List<PlacementPort> ports, boolean isRail) {
            this.portsOnNet = ports;
            this.isOnRail = isRail;
        }

        public List<PlacementPort> getPortsOnNet() {
            return this.portsOnNet;
        }

        public boolean isOnRail() {
            return this.isOnRail;
        }
    }

    public static class PlacementPort
    implements SteinerTree.SteinerTreePort {
        private EPoint location;
        private double offX;
        private double offY;
        private double rotatedOffX;
        private double rotatedOffY;
        private PlacementNode plNode;
        private PlacementNetwork plNet;

        public PlacementPort(double x, double y) {
            this.offX = x;
            this.offY = y;
        }

        public void setPlacementNode(PlacementNode pn) {
            this.plNode = pn;
        }

        public PlacementNode getPlacementNode() {
            return this.plNode;
        }

        public void setPlacementNetwork(PlacementNetwork pn) {
            this.plNet = pn;
        }

        public PlacementNetwork getPlacementNetwork() {
            return this.plNet;
        }

        public double getOffX() {
            return this.offX;
        }

        public double getOffY() {
            return this.offY;
        }

        @Override
        public EPoint getCenter() {
            if (this.location == null) {
                this.location = EPoint.fromLambda(this.plNode.xPos + this.rotatedOffX, this.plNode.yPos + this.rotatedOffY);
            }
            return this.location;
        }

        public double getRotatedOffX() {
            return this.rotatedOffX;
        }

        public double getRotatedOffY() {
            return this.rotatedOffY;
        }

        public void computeRotatedOffset() {
            Orientation orient = this.plNode.getPlacementOrientation();
            if (orient == Orientation.IDENT) {
                this.rotatedOffX = this.offX;
                this.rotatedOffY = this.offY;
                return;
            }
            FixpTransform trans = orient.pureRotate();
            Point2D.Double offset = new Point2D.Double(this.offX, this.offY);
            trans.transform(offset, offset);
            this.rotatedOffX = ((Point2D)offset).getX();
            this.rotatedOffY = ((Point2D)offset).getY();
        }
    }

    public class PlacementParameter {
        public static final int TYPEINTEGER = 1;
        public static final int TYPESTRING = 2;
        public static final int TYPEDOUBLE = 3;
        public static final int TYPEBOOLEAN = 4;
        final String key;
        private final String name;
        private final String title;
        final Object factoryValue;
        private Object cachedValue;
        private final int type;
        private String[] intMeanings;

        public PlacementParameter(String name, String title, int factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.name = name;
            this.title = title;
            this.cachedValue = this.factoryValue = Integer.valueOf(factory);
            this.type = 1;
            this.intMeanings = null;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, int factory, String[] meanings) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.name = name;
            this.title = title;
            this.cachedValue = this.factoryValue = Integer.valueOf(factory);
            this.type = 1;
            this.intMeanings = meanings;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, String factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.name = name;
            this.title = title;
            this.cachedValue = this.factoryValue = String.valueOf(factory);
            this.type = 2;
            this.intMeanings = null;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, double factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.name = name;
            this.title = title;
            this.cachedValue = this.factoryValue = Double.valueOf(factory);
            this.type = 3;
            this.intMeanings = null;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementParameter(String name, String title, boolean factory) {
            this.key = PlacementFrame.this.getAlgorithmName() + "-" + name;
            this.name = name;
            this.title = title;
            this.cachedValue = this.factoryValue = Boolean.valueOf(factory);
            this.type = 4;
            this.intMeanings = null;
            PlacementFrame.this.allParameters.add(this);
        }

        public PlacementFrame getOwner() {
            return PlacementFrame.this;
        }

        public String getParameterName() {
            return this.name;
        }

        public String getName() {
            return this.title;
        }

        public int getType() {
            return this.type;
        }

        public int getIntValue() {
            return (Integer)this.cachedValue;
        }

        public String[] getIntMeanings() {
            return this.intMeanings;
        }

        public String getStringValue() {
            return (String)this.cachedValue;
        }

        public double getDoubleValue() {
            return (Double)this.cachedValue;
        }

        public boolean getBooleanValue() {
            return (Boolean)this.cachedValue;
        }

        public void setValue(Object value) {
            assert (value.getClass() == this.factoryValue.getClass());
            if (value.equals(this.factoryValue)) {
                value = this.factoryValue;
            }
            this.cachedValue = value;
        }
    }
}

