/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.TopLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class EMenu
extends EMenuItem {
    final List<EMenuItem> items;

    public EMenu(String text, EMenuItem ... items) {
        super(text);
        ArrayList<EMenuItem> l = new ArrayList<EMenuItem>();
        for (EMenuItem item : items) {
            if (item == null) continue;
            l.add(item);
        }
        this.items = Collections.unmodifiableList(l);
    }

    public EMenu(String text, List<EMenuItem> itemsList) {
        this(text, itemsList.toArray(EMenuItem.NULL_ARRAY));
    }

    public List<EMenuItem> getItems() {
        return this.items;
    }

    public void setDynamicItems(List<? extends EMenuItem> dynamicItems) {
        for (EMenuBar.Instance menuBarInstance : TopLevel.getMenuBars()) {
            JMenu menu = (JMenu)menuBarInstance.findMenuItem(this.path);
            while (menu.getMenuComponentCount() > this.items.size()) {
                menu.remove(this.items.size());
            }
            this.genMenuElems(menu, dynamicItems);
        }
    }

    @Override
    void registerTree(EMenuBar menuBar, int[] parentPath, int indexInParent) {
        super.registerTree(menuBar, parentPath, indexInParent);
        for (int index = 0; index < this.items.size(); ++index) {
            EMenuItem item = this.items.get(index);
            item.registerTree(menuBar, this.path, index);
        }
    }

    @Override
    protected void registerItem() {
    }

    @Override
    JMenu genMenu() {
        JMenu subMenu = (JMenu)super.genMenu();
        this.genMenuElems(subMenu, this.items);
        return subMenu;
    }

    @Override
    protected JMenuItem createMenuItem() {
        return new JMenu();
    }

    private void genMenuElems(JMenu menu, List<? extends EMenuItem> items) {
        for (EMenuItem eMenuItem : items) {
            if (eMenuItem == EMenuItem.SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            JMenuItem item = eMenuItem.genMenu();
            menu.add(item);
        }
    }

    @Override
    protected void updateMenuItem(JMenuItem item) {
        item.setEnabled(this.isEnabled());
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }
}

