#ifndef HTML_CHARREFS_H
#define HTML_CHARREFS_H

typedef struct {
   const char *ref;
   const char *html5_str;
   const char *html4_str;
} Charref_t;

#define NumRef 2125
static const Charref_t Charrefs[NumRef] = {
{"AElig", "Æ", "Æ"},
{"AMP", "&", NULL},
{"Aacute", "Á", "Á"},
{"Abreve", "Ă", NULL},
{"Acirc", "Â", "Â"},
{"Acy", "А", NULL},
{"Afr", "𝔄", NULL},
{"Agrave", "À", "À"},
{"Alpha", "Α", "Α"},
{"Amacr", "Ā", NULL},
{"And", "⩓", NULL},
{"Aogon", "Ą", NULL},
{"Aopf", "𝔸", NULL},
{"ApplyFunction", "⁡", NULL},
{"Aring", "Å", "Å"},
{"Ascr", "𝒜", NULL},
{"Assign", "≔", NULL},
{"Atilde", "Ã", "Ã"},
{"Auml", "Ä", "Ä"},
{"Backslash", "∖", NULL},
{"Barv", "⫧", NULL},
{"Barwed", "⌆", NULL},
{"Bcy", "Б", NULL},
{"Because", "∵", NULL},
{"Bernoullis", "ℬ", NULL},
{"Beta", "Β", "Β"},
{"Bfr", "𝔅", NULL},
{"Bopf", "𝔹", NULL},
{"Breve", "˘", NULL},
{"Bscr", "ℬ", NULL},
{"Bumpeq", "≎", NULL},
{"CHcy", "Ч", NULL},
{"COPY", "©", NULL},
{"Cacute", "Ć", NULL},
{"Cap", "⋒", NULL},
{"CapitalDifferentialD", "ⅅ", NULL},
{"Cayleys", "ℭ", NULL},
{"Ccaron", "Č", NULL},
{"Ccedil", "Ç", "Ç"},
{"Ccirc", "Ĉ", NULL},
{"Cconint", "∰", NULL},
{"Cdot", "Ċ", NULL},
{"Cedilla", "¸", NULL},
{"CenterDot", "·", NULL},
{"Cfr", "ℭ", NULL},
{"Chi", "Χ", "Χ"},
{"CircleDot", "⊙", NULL},
{"CircleMinus", "⊖", NULL},
{"CirclePlus", "⊕", NULL},
{"CircleTimes", "⊗", NULL},
{"ClockwiseContourIntegral", "∲", NULL},
{"CloseCurlyDoubleQuote", "”", NULL},
{"CloseCurlyQuote", "’", NULL},
{"Colon", "∷", NULL},
{"Colone", "⩴", NULL},
{"Congruent", "≡", NULL},
{"Conint", "∯", NULL},
{"ContourIntegral", "∮", NULL},
{"Copf", "ℂ", NULL},
{"Coproduct", "∐", NULL},
{"CounterClockwiseContourIntegral", "∳", NULL},
{"Cross", "⨯", NULL},
{"Cscr", "𝒞", NULL},
{"Cup", "⋓", NULL},
{"CupCap", "≍", NULL},
{"DD", "ⅅ", NULL},
{"DDotrahd", "⤑", NULL},
{"DJcy", "Ђ", NULL},
{"DScy", "Ѕ", NULL},
{"DZcy", "Џ", NULL},
{"Dagger", "‡", "‡"},
{"Darr", "↡", NULL},
{"Dashv", "⫤", NULL},
{"Dcaron", "Ď", NULL},
{"Dcy", "Д", NULL},
{"Del", "∇", NULL},
{"Delta", "Δ", "Δ"},
{"Dfr", "𝔇", NULL},
{"DiacriticalAcute", "´", NULL},
{"DiacriticalDot", "˙", NULL},
{"DiacriticalDoubleAcute", "˝", NULL},
{"DiacriticalGrave", "`", NULL},
{"DiacriticalTilde", "˜", NULL},
{"Diamond", "⋄", NULL},
{"DifferentialD", "ⅆ", NULL},
{"Dopf", "𝔻", NULL},
{"Dot", "¨", NULL},
{"DotDot", "⃜", NULL},
{"DotEqual", "≐", NULL},
{"DoubleContourIntegral", "∯", NULL},
{"DoubleDot", "¨", NULL},
{"DoubleDownArrow", "⇓", NULL},
{"DoubleLeftArrow", "⇐", NULL},
{"DoubleLeftRightArrow", "⇔", NULL},
{"DoubleLeftTee", "⫤", NULL},
{"DoubleLongLeftArrow", "⟸", NULL},
{"DoubleLongLeftRightArrow", "⟺", NULL},
{"DoubleLongRightArrow", "⟹", NULL},
{"DoubleRightArrow", "⇒", NULL},
{"DoubleRightTee", "⊨", NULL},
{"DoubleUpArrow", "⇑", NULL},
{"DoubleUpDownArrow", "⇕", NULL},
{"DoubleVerticalBar", "∥", NULL},
{"DownArrow", "↓", NULL},
{"DownArrowBar", "⤓", NULL},
{"DownArrowUpArrow", "⇵", NULL},
{"DownBreve", "̑", NULL},
{"DownLeftRightVector", "⥐", NULL},
{"DownLeftTeeVector", "⥞", NULL},
{"DownLeftVector", "↽", NULL},
{"DownLeftVectorBar", "⥖", NULL},
{"DownRightTeeVector", "⥟", NULL},
{"DownRightVector", "⇁", NULL},
{"DownRightVectorBar", "⥗", NULL},
{"DownTee", "⊤", NULL},
{"DownTeeArrow", "↧", NULL},
{"Downarrow", "⇓", NULL},
{"Dscr", "𝒟", NULL},
{"Dstrok", "Đ", NULL},
{"ENG", "Ŋ", NULL},
{"ETH", "Ð", "Ð"},
{"Eacute", "É", "É"},
{"Ecaron", "Ě", NULL},
{"Ecirc", "Ê", "Ê"},
{"Ecy", "Э", NULL},
{"Edot", "Ė", NULL},
{"Efr", "𝔈", NULL},
{"Egrave", "È", "È"},
{"Element", "∈", NULL},
{"Emacr", "Ē", NULL},
{"EmptySmallSquare", "◻", NULL},
{"EmptyVerySmallSquare", "▫", NULL},
{"Eogon", "Ę", NULL},
{"Eopf", "𝔼", NULL},
{"Epsilon", "Ε", "Ε"},
{"Equal", "⩵", NULL},
{"EqualTilde", "≂", NULL},
{"Equilibrium", "⇌", NULL},
{"Escr", "ℰ", NULL},
{"Esim", "⩳", NULL},
{"Eta", "Η", "Η"},
{"Euml", "Ë", "Ë"},
{"Exists", "∃", NULL},
{"ExponentialE", "ⅇ", NULL},
{"Fcy", "Ф", NULL},
{"Ffr", "𝔉", NULL},
{"FilledSmallSquare", "◼", NULL},
{"FilledVerySmallSquare", "▪", NULL},
{"Fopf", "𝔽", NULL},
{"ForAll", "∀", NULL},
{"Fouriertrf", "ℱ", NULL},
{"Fscr", "ℱ", NULL},
{"GJcy", "Ѓ", NULL},
{"GT", ">", NULL},
{"Gamma", "Γ", "Γ"},
{"Gammad", "Ϝ", NULL},
{"Gbreve", "Ğ", NULL},
{"Gcedil", "Ģ", NULL},
{"Gcirc", "Ĝ", NULL},
{"Gcy", "Г", NULL},
{"Gdot", "Ġ", NULL},
{"Gfr", "𝔊", NULL},
{"Gg", "⋙", NULL},
{"Gopf", "𝔾", NULL},
{"GreaterEqual", "≥", NULL},
{"GreaterEqualLess", "⋛", NULL},
{"GreaterFullEqual", "≧", NULL},
{"GreaterGreater", "⪢", NULL},
{"GreaterLess", "≷", NULL},
{"GreaterSlantEqual", "⩾", NULL},
{"GreaterTilde", "≳", NULL},
{"Gscr", "𝒢", NULL},
{"Gt", "≫", NULL},
{"HARDcy", "Ъ", NULL},
{"Hacek", "ˇ", NULL},
{"Hat", "^", NULL},
{"Hcirc", "Ĥ", NULL},
{"Hfr", "ℌ", NULL},
{"HilbertSpace", "ℋ", NULL},
{"Hopf", "ℍ", NULL},
{"HorizontalLine", "─", NULL},
{"Hscr", "ℋ", NULL},
{"Hstrok", "Ħ", NULL},
{"HumpDownHump", "≎", NULL},
{"HumpEqual", "≏", NULL},
{"IEcy", "Е", NULL},
{"IJlig", "Ĳ", NULL},
{"IOcy", "Ё", NULL},
{"Iacute", "Í", "Í"},
{"Icirc", "Î", "Î"},
{"Icy", "И", NULL},
{"Idot", "İ", NULL},
{"Ifr", "ℑ", NULL},
{"Igrave", "Ì", "Ì"},
{"Im", "ℑ", NULL},
{"Imacr", "Ī", NULL},
{"ImaginaryI", "ⅈ", NULL},
{"Implies", "⇒", NULL},
{"Int", "∬", NULL},
{"Integral", "∫", NULL},
{"Intersection", "⋂", NULL},
{"InvisibleComma", "⁣", NULL},
{"InvisibleTimes", "⁢", NULL},
{"Iogon", "Į", NULL},
{"Iopf", "𝕀", NULL},
{"Iota", "Ι", "Ι"},
{"Iscr", "ℐ", NULL},
{"Itilde", "Ĩ", NULL},
{"Iukcy", "І", NULL},
{"Iuml", "Ï", "Ï"},
{"Jcirc", "Ĵ", NULL},
{"Jcy", "Й", NULL},
{"Jfr", "𝔍", NULL},
{"Jopf", "𝕁", NULL},
{"Jscr", "𝒥", NULL},
{"Jsercy", "Ј", NULL},
{"Jukcy", "Є", NULL},
{"KHcy", "Х", NULL},
{"KJcy", "Ќ", NULL},
{"Kappa", "Κ", "Κ"},
{"Kcedil", "Ķ", NULL},
{"Kcy", "К", NULL},
{"Kfr", "𝔎", NULL},
{"Kopf", "𝕂", NULL},
{"Kscr", "𝒦", NULL},
{"LJcy", "Љ", NULL},
{"LT", "<", NULL},
{"Lacute", "Ĺ", NULL},
{"Lambda", "Λ", "Λ"},
{"Lang", "⟪", NULL},
{"Laplacetrf", "ℒ", NULL},
{"Larr", "↞", NULL},
{"Lcaron", "Ľ", NULL},
{"Lcedil", "Ļ", NULL},
{"Lcy", "Л", NULL},
{"LeftAngleBracket", "⟨", NULL},
{"LeftArrow", "←", NULL},
{"LeftArrowBar", "⇤", NULL},
{"LeftArrowRightArrow", "⇆", NULL},
{"LeftCeiling", "⌈", NULL},
{"LeftDoubleBracket", "⟦", NULL},
{"LeftDownTeeVector", "⥡", NULL},
{"LeftDownVector", "⇃", NULL},
{"LeftDownVectorBar", "⥙", NULL},
{"LeftFloor", "⌊", NULL},
{"LeftRightArrow", "↔", NULL},
{"LeftRightVector", "⥎", NULL},
{"LeftTee", "⊣", NULL},
{"LeftTeeArrow", "↤", NULL},
{"LeftTeeVector", "⥚", NULL},
{"LeftTriangle", "⊲", NULL},
{"LeftTriangleBar", "⧏", NULL},
{"LeftTriangleEqual", "⊴", NULL},
{"LeftUpDownVector", "⥑", NULL},
{"LeftUpTeeVector", "⥠", NULL},
{"LeftUpVector", "↿", NULL},
{"LeftUpVectorBar", "⥘", NULL},
{"LeftVector", "↼", NULL},
{"LeftVectorBar", "⥒", NULL},
{"Leftarrow", "⇐", NULL},
{"Leftrightarrow", "⇔", NULL},
{"LessEqualGreater", "⋚", NULL},
{"LessFullEqual", "≦", NULL},
{"LessGreater", "≶", NULL},
{"LessLess", "⪡", NULL},
{"LessSlantEqual", "⩽", NULL},
{"LessTilde", "≲", NULL},
{"Lfr", "𝔏", NULL},
{"Ll", "⋘", NULL},
{"Lleftarrow", "⇚", NULL},
{"Lmidot", "Ŀ", NULL},
{"LongLeftArrow", "⟵", NULL},
{"LongLeftRightArrow", "⟷", NULL},
{"LongRightArrow", "⟶", NULL},
{"Longleftarrow", "⟸", NULL},
{"Longleftrightarrow", "⟺", NULL},
{"Longrightarrow", "⟹", NULL},
{"Lopf", "𝕃", NULL},
{"LowerLeftArrow", "↙", NULL},
{"LowerRightArrow", "↘", NULL},
{"Lscr", "ℒ", NULL},
{"Lsh", "↰", NULL},
{"Lstrok", "Ł", NULL},
{"Lt", "≪", NULL},
{"Map", "⤅", NULL},
{"Mcy", "М", NULL},
{"MediumSpace", " ", NULL},
{"Mellintrf", "ℳ", NULL},
{"Mfr", "𝔐", NULL},
{"MinusPlus", "∓", NULL},
{"Mopf", "𝕄", NULL},
{"Mscr", "ℳ", NULL},
{"Mu", "Μ", "Μ"},
{"NJcy", "Њ", NULL},
{"Nacute", "Ń", NULL},
{"Ncaron", "Ň", NULL},
{"Ncedil", "Ņ", NULL},
{"Ncy", "Н", NULL},
{"NegativeMediumSpace", "​", NULL},
{"NegativeThickSpace", "​", NULL},
{"NegativeThinSpace", "​", NULL},
{"NegativeVeryThinSpace", "​", NULL},
{"NestedGreaterGreater", "≫", NULL},
{"NestedLessLess", "≪", NULL},
{"NewLine", "\n", NULL},
{"Nfr", "𝔑", NULL},
{"NoBreak", "⁠", NULL},
{"NonBreakingSpace", " ", NULL},
{"Nopf", "ℕ", NULL},
{"Not", "⫬", NULL},
{"NotCongruent", "≢", NULL},
{"NotCupCap", "≭", NULL},
{"NotDoubleVerticalBar", "∦", NULL},
{"NotElement", "∉", NULL},
{"NotEqual", "≠", NULL},
{"NotEqualTilde", "≂̸", NULL},
{"NotExists", "∄", NULL},
{"NotGreater", "≯", NULL},
{"NotGreaterEqual", "≱", NULL},
{"NotGreaterFullEqual", "≧̸", NULL},
{"NotGreaterGreater", "≫̸", NULL},
{"NotGreaterLess", "≹", NULL},
{"NotGreaterSlantEqual", "⩾̸", NULL},
{"NotGreaterTilde", "≵", NULL},
{"NotHumpDownHump", "≎̸", NULL},
{"NotHumpEqual", "≏̸", NULL},
{"NotLeftTriangle", "⋪", NULL},
{"NotLeftTriangleBar", "⧏̸", NULL},
{"NotLeftTriangleEqual", "⋬", NULL},
{"NotLess", "≮", NULL},
{"NotLessEqual", "≰", NULL},
{"NotLessGreater", "≸", NULL},
{"NotLessLess", "≪̸", NULL},
{"NotLessSlantEqual", "⩽̸", NULL},
{"NotLessTilde", "≴", NULL},
{"NotNestedGreaterGreater", "⪢̸", NULL},
{"NotNestedLessLess", "⪡̸", NULL},
{"NotPrecedes", "⊀", NULL},
{"NotPrecedesEqual", "⪯̸", NULL},
{"NotPrecedesSlantEqual", "⋠", NULL},
{"NotReverseElement", "∌", NULL},
{"NotRightTriangle", "⋫", NULL},
{"NotRightTriangleBar", "⧐̸", NULL},
{"NotRightTriangleEqual", "⋭", NULL},
{"NotSquareSubset", "⊏̸", NULL},
{"NotSquareSubsetEqual", "⋢", NULL},
{"NotSquareSuperset", "⊐̸", NULL},
{"NotSquareSupersetEqual", "⋣", NULL},
{"NotSubset", "⊂⃒", NULL},
{"NotSubsetEqual", "⊈", NULL},
{"NotSucceeds", "⊁", NULL},
{"NotSucceedsEqual", "⪰̸", NULL},
{"NotSucceedsSlantEqual", "⋡", NULL},
{"NotSucceedsTilde", "≿̸", NULL},
{"NotSuperset", "⊃⃒", NULL},
{"NotSupersetEqual", "⊉", NULL},
{"NotTilde", "≁", NULL},
{"NotTildeEqual", "≄", NULL},
{"NotTildeFullEqual", "≇", NULL},
{"NotTildeTilde", "≉", NULL},
{"NotVerticalBar", "∤", NULL},
{"Nscr", "𝒩", NULL},
{"Ntilde", "Ñ", "Ñ"},
{"Nu", "Ν", "Ν"},
{"OElig", "Œ", "Œ"},
{"Oacute", "Ó", "Ó"},
{"Ocirc", "Ô", "Ô"},
{"Ocy", "О", NULL},
{"Odblac", "Ő", NULL},
{"Ofr", "𝔒", NULL},
{"Ograve", "Ò", "Ò"},
{"Omacr", "Ō", NULL},
{"Omega", "Ω", "Ω"},
{"Omicron", "Ο", "Ο"},
{"Oopf", "𝕆", NULL},
{"OpenCurlyDoubleQuote", "“", NULL},
{"OpenCurlyQuote", "‘", NULL},
{"Or", "⩔", NULL},
{"Oscr", "𝒪", NULL},
{"Oslash", "Ø", "Ø"},
{"Otilde", "Õ", "Õ"},
{"Otimes", "⨷", NULL},
{"Ouml", "Ö", "Ö"},
{"OverBar", "‾", NULL},
{"OverBrace", "⏞", NULL},
{"OverBracket", "⎴", NULL},
{"OverParenthesis", "⏜", NULL},
{"PartialD", "∂", NULL},
{"Pcy", "П", NULL},
{"Pfr", "𝔓", NULL},
{"Phi", "Φ", "Φ"},
{"Pi", "Π", "Π"},
{"PlusMinus", "±", NULL},
{"Poincareplane", "ℌ", NULL},
{"Popf", "ℙ", NULL},
{"Pr", "⪻", NULL},
{"Precedes", "≺", NULL},
{"PrecedesEqual", "⪯", NULL},
{"PrecedesSlantEqual", "≼", NULL},
{"PrecedesTilde", "≾", NULL},
{"Prime", "″", "″"},
{"Product", "∏", NULL},
{"Proportion", "∷", NULL},
{"Proportional", "∝", NULL},
{"Pscr", "𝒫", NULL},
{"Psi", "Ψ", "Ψ"},
{"QUOT", "\"", NULL},
{"Qfr", "𝔔", NULL},
{"Qopf", "ℚ", NULL},
{"Qscr", "𝒬", NULL},
{"RBarr", "⤐", NULL},
{"REG", "®", NULL},
{"Racute", "Ŕ", NULL},
{"Rang", "⟫", NULL},
{"Rarr", "↠", NULL},
{"Rarrtl", "⤖", NULL},
{"Rcaron", "Ř", NULL},
{"Rcedil", "Ŗ", NULL},
{"Rcy", "Р", NULL},
{"Re", "ℜ", NULL},
{"ReverseElement", "∋", NULL},
{"ReverseEquilibrium", "⇋", NULL},
{"ReverseUpEquilibrium", "⥯", NULL},
{"Rfr", "ℜ", NULL},
{"Rho", "Ρ", "Ρ"},
{"RightAngleBracket", "⟩", NULL},
{"RightArrow", "→", NULL},
{"RightArrowBar", "⇥", NULL},
{"RightArrowLeftArrow", "⇄", NULL},
{"RightCeiling", "⌉", NULL},
{"RightDoubleBracket", "⟧", NULL},
{"RightDownTeeVector", "⥝", NULL},
{"RightDownVector", "⇂", NULL},
{"RightDownVectorBar", "⥕", NULL},
{"RightFloor", "⌋", NULL},
{"RightTee", "⊢", NULL},
{"RightTeeArrow", "↦", NULL},
{"RightTeeVector", "⥛", NULL},
{"RightTriangle", "⊳", NULL},
{"RightTriangleBar", "⧐", NULL},
{"RightTriangleEqual", "⊵", NULL},
{"RightUpDownVector", "⥏", NULL},
{"RightUpTeeVector", "⥜", NULL},
{"RightUpVector", "↾", NULL},
{"RightUpVectorBar", "⥔", NULL},
{"RightVector", "⇀", NULL},
{"RightVectorBar", "⥓", NULL},
{"Rightarrow", "⇒", NULL},
{"Ropf", "ℝ", NULL},
{"RoundImplies", "⥰", NULL},
{"Rrightarrow", "⇛", NULL},
{"Rscr", "ℛ", NULL},
{"Rsh", "↱", NULL},
{"RuleDelayed", "⧴", NULL},
{"SHCHcy", "Щ", NULL},
{"SHcy", "Ш", NULL},
{"SOFTcy", "Ь", NULL},
{"Sacute", "Ś", NULL},
{"Sc", "⪼", NULL},
{"Scaron", "Š", "Š"},
{"Scedil", "Ş", NULL},
{"Scirc", "Ŝ", NULL},
{"Scy", "С", NULL},
{"Sfr", "𝔖", NULL},
{"ShortDownArrow", "↓", NULL},
{"ShortLeftArrow", "←", NULL},
{"ShortRightArrow", "→", NULL},
{"ShortUpArrow", "↑", NULL},
{"Sigma", "Σ", "Σ"},
{"SmallCircle", "∘", NULL},
{"Sopf", "𝕊", NULL},
{"Sqrt", "√", NULL},
{"Square", "□", NULL},
{"SquareIntersection", "⊓", NULL},
{"SquareSubset", "⊏", NULL},
{"SquareSubsetEqual", "⊑", NULL},
{"SquareSuperset", "⊐", NULL},
{"SquareSupersetEqual", "⊒", NULL},
{"SquareUnion", "⊔", NULL},
{"Sscr", "𝒮", NULL},
{"Star", "⋆", NULL},
{"Sub", "⋐", NULL},
{"Subset", "⋐", NULL},
{"SubsetEqual", "⊆", NULL},
{"Succeeds", "≻", NULL},
{"SucceedsEqual", "⪰", NULL},
{"SucceedsSlantEqual", "≽", NULL},
{"SucceedsTilde", "≿", NULL},
{"SuchThat", "∋", NULL},
{"Sum", "∑", NULL},
{"Sup", "⋑", NULL},
{"Superset", "⊃", NULL},
{"SupersetEqual", "⊇", NULL},
{"Supset", "⋑", NULL},
{"THORN", "Þ", "Þ"},
{"TRADE", "™", NULL},
{"TSHcy", "Ћ", NULL},
{"TScy", "Ц", NULL},
{"Tab", "\t", NULL},
{"Tau", "Τ", "Τ"},
{"Tcaron", "Ť", NULL},
{"Tcedil", "Ţ", NULL},
{"Tcy", "Т", NULL},
{"Tfr", "𝔗", NULL},
{"Therefore", "∴", NULL},
{"Theta", "Θ", "Θ"},
{"ThickSpace", "  ", NULL},
{"ThinSpace", " ", NULL},
{"Tilde", "∼", NULL},
{"TildeEqual", "≃", NULL},
{"TildeFullEqual", "≅", NULL},
{"TildeTilde", "≈", NULL},
{"Topf", "𝕋", NULL},
{"TripleDot", "⃛", NULL},
{"Tscr", "𝒯", NULL},
{"Tstrok", "Ŧ", NULL},
{"Uacute", "Ú", "Ú"},
{"Uarr", "↟", NULL},
{"Uarrocir", "⥉", NULL},
{"Ubrcy", "Ў", NULL},
{"Ubreve", "Ŭ", NULL},
{"Ucirc", "Û", "Û"},
{"Ucy", "У", NULL},
{"Udblac", "Ű", NULL},
{"Ufr", "𝔘", NULL},
{"Ugrave", "Ù", "Ù"},
{"Umacr", "Ū", NULL},
{"UnderBar", "_", NULL},
{"UnderBrace", "⏟", NULL},
{"UnderBracket", "⎵", NULL},
{"UnderParenthesis", "⏝", NULL},
{"Union", "⋃", NULL},
{"UnionPlus", "⊎", NULL},
{"Uogon", "Ų", NULL},
{"Uopf", "𝕌", NULL},
{"UpArrow", "↑", NULL},
{"UpArrowBar", "⤒", NULL},
{"UpArrowDownArrow", "⇅", NULL},
{"UpDownArrow", "↕", NULL},
{"UpEquilibrium", "⥮", NULL},
{"UpTee", "⊥", NULL},
{"UpTeeArrow", "↥", NULL},
{"Uparrow", "⇑", NULL},
{"Updownarrow", "⇕", NULL},
{"UpperLeftArrow", "↖", NULL},
{"UpperRightArrow", "↗", NULL},
{"Upsi", "ϒ", NULL},
{"Upsilon", "Υ", "Υ"},
{"Uring", "Ů", NULL},
{"Uscr", "𝒰", NULL},
{"Utilde", "Ũ", NULL},
{"Uuml", "Ü", "Ü"},
{"VDash", "⊫", NULL},
{"Vbar", "⫫", NULL},
{"Vcy", "В", NULL},
{"Vdash", "⊩", NULL},
{"Vdashl", "⫦", NULL},
{"Vee", "⋁", NULL},
{"Verbar", "‖", NULL},
{"Vert", "‖", NULL},
{"VerticalBar", "∣", NULL},
{"VerticalLine", "|", NULL},
{"VerticalSeparator", "❘", NULL},
{"VerticalTilde", "≀", NULL},
{"VeryThinSpace", " ", NULL},
{"Vfr", "𝔙", NULL},
{"Vopf", "𝕍", NULL},
{"Vscr", "𝒱", NULL},
{"Vvdash", "⊪", NULL},
{"Wcirc", "Ŵ", NULL},
{"Wedge", "⋀", NULL},
{"Wfr", "𝔚", NULL},
{"Wopf", "𝕎", NULL},
{"Wscr", "𝒲", NULL},
{"Xfr", "𝔛", NULL},
{"Xi", "Ξ", "Ξ"},
{"Xopf", "𝕏", NULL},
{"Xscr", "𝒳", NULL},
{"YAcy", "Я", NULL},
{"YIcy", "Ї", NULL},
{"YUcy", "Ю", NULL},
{"Yacute", "Ý", "Ý"},
{"Ycirc", "Ŷ", NULL},
{"Ycy", "Ы", NULL},
{"Yfr", "𝔜", NULL},
{"Yopf", "𝕐", NULL},
{"Yscr", "𝒴", NULL},
{"Yuml", "Ÿ", "Ÿ"},
{"ZHcy", "Ж", NULL},
{"Zacute", "Ź", NULL},
{"Zcaron", "Ž", NULL},
{"Zcy", "З", NULL},
{"Zdot", "Ż", NULL},
{"ZeroWidthSpace", "​", NULL},
{"Zeta", "Ζ", "Ζ"},
{"Zfr", "ℨ", NULL},
{"Zopf", "ℤ", NULL},
{"Zscr", "𝒵", NULL},
{"aacute", "á", "á"},
{"abreve", "ă", NULL},
{"ac", "∾", NULL},
{"acE", "∾̳", NULL},
{"acd", "∿", NULL},
{"acirc", "â", "â"},
{"acute", "´", "´"},
{"acy", "а", NULL},
{"aelig", "æ", "æ"},
{"af", "⁡", NULL},
{"afr", "𝔞", NULL},
{"agrave", "à", "à"},
{"alefsym", "ℵ", "ℵ"},
{"aleph", "ℵ", NULL},
{"alpha", "α", "α"},
{"amacr", "ā", NULL},
{"amalg", "⨿", NULL},
{"amp", "&", "&"},
{"and", "∧", "∧"},
{"andand", "⩕", NULL},
{"andd", "⩜", NULL},
{"andslope", "⩘", NULL},
{"andv", "⩚", NULL},
{"ang", "∠", "∠"},
{"ange", "⦤", NULL},
{"angle", "∠", NULL},
{"angmsd", "∡", NULL},
{"angmsdaa", "⦨", NULL},
{"angmsdab", "⦩", NULL},
{"angmsdac", "⦪", NULL},
{"angmsdad", "⦫", NULL},
{"angmsdae", "⦬", NULL},
{"angmsdaf", "⦭", NULL},
{"angmsdag", "⦮", NULL},
{"angmsdah", "⦯", NULL},
{"angrt", "∟", NULL},
{"angrtvb", "⊾", NULL},
{"angrtvbd", "⦝", NULL},
{"angsph", "∢", NULL},
{"angst", "Å", NULL},
{"angzarr", "⍼", NULL},
{"aogon", "ą", NULL},
{"aopf", "𝕒", NULL},
{"ap", "≈", NULL},
{"apE", "⩰", NULL},
{"apacir", "⩯", NULL},
{"ape", "≊", NULL},
{"apid", "≋", NULL},
{"apos", "'", NULL},
{"approx", "≈", NULL},
{"approxeq", "≊", NULL},
{"aring", "å", "å"},
{"ascr", "𝒶", NULL},
{"ast", "*", NULL},
{"asymp", "≈", "≈"},
{"asympeq", "≍", NULL},
{"atilde", "ã", "ã"},
{"auml", "ä", "ä"},
{"awconint", "∳", NULL},
{"awint", "⨑", NULL},
{"bNot", "⫭", NULL},
{"backcong", "≌", NULL},
{"backepsilon", "϶", NULL},
{"backprime", "‵", NULL},
{"backsim", "∽", NULL},
{"backsimeq", "⋍", NULL},
{"barvee", "⊽", NULL},
{"barwed", "⌅", NULL},
{"barwedge", "⌅", NULL},
{"bbrk", "⎵", NULL},
{"bbrktbrk", "⎶", NULL},
{"bcong", "≌", NULL},
{"bcy", "б", NULL},
{"bdquo", "„", "„"},
{"becaus", "∵", NULL},
{"because", "∵", NULL},
{"bemptyv", "⦰", NULL},
{"bepsi", "϶", NULL},
{"bernou", "ℬ", NULL},
{"beta", "β", "β"},
{"beth", "ℶ", NULL},
{"between", "≬", NULL},
{"bfr", "𝔟", NULL},
{"bigcap", "⋂", NULL},
{"bigcirc", "◯", NULL},
{"bigcup", "⋃", NULL},
{"bigodot", "⨀", NULL},
{"bigoplus", "⨁", NULL},
{"bigotimes", "⨂", NULL},
{"bigsqcup", "⨆", NULL},
{"bigstar", "★", NULL},
{"bigtriangledown", "▽", NULL},
{"bigtriangleup", "△", NULL},
{"biguplus", "⨄", NULL},
{"bigvee", "⋁", NULL},
{"bigwedge", "⋀", NULL},
{"bkarow", "⤍", NULL},
{"blacklozenge", "⧫", NULL},
{"blacksquare", "▪", NULL},
{"blacktriangle", "▴", NULL},
{"blacktriangledown", "▾", NULL},
{"blacktriangleleft", "◂", NULL},
{"blacktriangleright", "▸", NULL},
{"blank", "␣", NULL},
{"blk12", "▒", NULL},
{"blk14", "░", NULL},
{"blk34", "▓", NULL},
{"block", "█", NULL},
{"bne", "=⃥", NULL},
{"bnequiv", "≡⃥", NULL},
{"bnot", "⌐", NULL},
{"bopf", "𝕓", NULL},
{"bot", "⊥", NULL},
{"bottom", "⊥", NULL},
{"bowtie", "⋈", NULL},
{"boxDL", "╗", NULL},
{"boxDR", "╔", NULL},
{"boxDl", "╖", NULL},
{"boxDr", "╓", NULL},
{"boxH", "═", NULL},
{"boxHD", "╦", NULL},
{"boxHU", "╩", NULL},
{"boxHd", "╤", NULL},
{"boxHu", "╧", NULL},
{"boxUL", "╝", NULL},
{"boxUR", "╚", NULL},
{"boxUl", "╜", NULL},
{"boxUr", "╙", NULL},
{"boxV", "║", NULL},
{"boxVH", "╬", NULL},
{"boxVL", "╣", NULL},
{"boxVR", "╠", NULL},
{"boxVh", "╫", NULL},
{"boxVl", "╢", NULL},
{"boxVr", "╟", NULL},
{"boxbox", "⧉", NULL},
{"boxdL", "╕", NULL},
{"boxdR", "╒", NULL},
{"boxdl", "┐", NULL},
{"boxdr", "┌", NULL},
{"boxh", "─", NULL},
{"boxhD", "╥", NULL},
{"boxhU", "╨", NULL},
{"boxhd", "┬", NULL},
{"boxhu", "┴", NULL},
{"boxminus", "⊟", NULL},
{"boxplus", "⊞", NULL},
{"boxtimes", "⊠", NULL},
{"boxuL", "╛", NULL},
{"boxuR", "╘", NULL},
{"boxul", "┘", NULL},
{"boxur", "└", NULL},
{"boxv", "│", NULL},
{"boxvH", "╪", NULL},
{"boxvL", "╡", NULL},
{"boxvR", "╞", NULL},
{"boxvh", "┼", NULL},
{"boxvl", "┤", NULL},
{"boxvr", "├", NULL},
{"bprime", "‵", NULL},
{"breve", "˘", NULL},
{"brvbar", "¦", "¦"},
{"bscr", "𝒷", NULL},
{"bsemi", "⁏", NULL},
{"bsim", "∽", NULL},
{"bsime", "⋍", NULL},
{"bsol", "\\", NULL},
{"bsolb", "⧅", NULL},
{"bsolhsub", "⟈", NULL},
{"bull", "•", "•"},
{"bullet", "•", NULL},
{"bump", "≎", NULL},
{"bumpE", "⪮", NULL},
{"bumpe", "≏", NULL},
{"bumpeq", "≏", NULL},
{"cacute", "ć", NULL},
{"cap", "∩", "∩"},
{"capand", "⩄", NULL},
{"capbrcup", "⩉", NULL},
{"capcap", "⩋", NULL},
{"capcup", "⩇", NULL},
{"capdot", "⩀", NULL},
{"caps", "∩︀", NULL},
{"caret", "⁁", NULL},
{"caron", "ˇ", NULL},
{"ccaps", "⩍", NULL},
{"ccaron", "č", NULL},
{"ccedil", "ç", "ç"},
{"ccirc", "ĉ", NULL},
{"ccups", "⩌", NULL},
{"ccupssm", "⩐", NULL},
{"cdot", "ċ", NULL},
{"cedil", "¸", "¸"},
{"cemptyv", "⦲", NULL},
{"cent", "¢", "¢"},
{"centerdot", "·", NULL},
{"cfr", "𝔠", NULL},
{"chcy", "ч", NULL},
{"check", "✓", NULL},
{"checkmark", "✓", NULL},
{"chi", "χ", "χ"},
{"cir", "○", NULL},
{"cirE", "⧃", NULL},
{"circ", "ˆ", "ˆ"},
{"circeq", "≗", NULL},
{"circlearrowleft", "↺", NULL},
{"circlearrowright", "↻", NULL},
{"circledR", "®", NULL},
{"circledS", "Ⓢ", NULL},
{"circledast", "⊛", NULL},
{"circledcirc", "⊚", NULL},
{"circleddash", "⊝", NULL},
{"cire", "≗", NULL},
{"cirfnint", "⨐", NULL},
{"cirmid", "⫯", NULL},
{"cirscir", "⧂", NULL},
{"clubs", "♣", "♣"},
{"clubsuit", "♣", NULL},
{"colon", ":", NULL},
{"colone", "≔", NULL},
{"coloneq", "≔", NULL},
{"comma", ",", NULL},
{"commat", "@", NULL},
{"comp", "∁", NULL},
{"compfn", "∘", NULL},
{"complement", "∁", NULL},
{"complexes", "ℂ", NULL},
{"cong", "≅", "≅"},
{"congdot", "⩭", NULL},
{"conint", "∮", NULL},
{"copf", "𝕔", NULL},
{"coprod", "∐", NULL},
{"copy", "©", "©"},
{"copysr", "℗", NULL},
{"crarr", "↵", "↵"},
{"cross", "✗", NULL},
{"cscr", "𝒸", NULL},
{"csub", "⫏", NULL},
{"csube", "⫑", NULL},
{"csup", "⫐", NULL},
{"csupe", "⫒", NULL},
{"ctdot", "⋯", NULL},
{"cudarrl", "⤸", NULL},
{"cudarrr", "⤵", NULL},
{"cuepr", "⋞", NULL},
{"cuesc", "⋟", NULL},
{"cularr", "↶", NULL},
{"cularrp", "⤽", NULL},
{"cup", "∪", "∪"},
{"cupbrcap", "⩈", NULL},
{"cupcap", "⩆", NULL},
{"cupcup", "⩊", NULL},
{"cupdot", "⊍", NULL},
{"cupor", "⩅", NULL},
{"cups", "∪︀", NULL},
{"curarr", "↷", NULL},
{"curarrm", "⤼", NULL},
{"curlyeqprec", "⋞", NULL},
{"curlyeqsucc", "⋟", NULL},
{"curlyvee", "⋎", NULL},
{"curlywedge", "⋏", NULL},
{"curren", "¤", "¤"},
{"curvearrowleft", "↶", NULL},
{"curvearrowright", "↷", NULL},
{"cuvee", "⋎", NULL},
{"cuwed", "⋏", NULL},
{"cwconint", "∲", NULL},
{"cwint", "∱", NULL},
{"cylcty", "⌭", NULL},
{"dArr", "⇓", "⇓"},
{"dHar", "⥥", NULL},
{"dagger", "†", "†"},
{"daleth", "ℸ", NULL},
{"darr", "↓", "↓"},
{"dash", "‐", NULL},
{"dashv", "⊣", NULL},
{"dbkarow", "⤏", NULL},
{"dblac", "˝", NULL},
{"dcaron", "ď", NULL},
{"dcy", "д", NULL},
{"dd", "ⅆ", NULL},
{"ddagger", "‡", NULL},
{"ddarr", "⇊", NULL},
{"ddotseq", "⩷", NULL},
{"deg", "°", "°"},
{"delta", "δ", "δ"},
{"demptyv", "⦱", NULL},
{"dfisht", "⥿", NULL},
{"dfr", "𝔡", NULL},
{"dharl", "⇃", NULL},
{"dharr", "⇂", NULL},
{"diam", "⋄", NULL},
{"diamond", "⋄", NULL},
{"diamondsuit", "♦", NULL},
{"diams", "♦", "♦"},
{"die", "¨", NULL},
{"digamma", "ϝ", NULL},
{"disin", "⋲", NULL},
{"div", "÷", NULL},
{"divide", "÷", "÷"},
{"divideontimes", "⋇", NULL},
{"divonx", "⋇", NULL},
{"djcy", "ђ", NULL},
{"dlcorn", "⌞", NULL},
{"dlcrop", "⌍", NULL},
{"dollar", "$", NULL},
{"dopf", "𝕕", NULL},
{"dot", "˙", NULL},
{"doteq", "≐", NULL},
{"doteqdot", "≑", NULL},
{"dotminus", "∸", NULL},
{"dotplus", "∔", NULL},
{"dotsquare", "⊡", NULL},
{"doublebarwedge", "⌆", NULL},
{"downarrow", "↓", NULL},
{"downdownarrows", "⇊", NULL},
{"downharpoonleft", "⇃", NULL},
{"downharpoonright", "⇂", NULL},
{"drbkarow", "⤐", NULL},
{"drcorn", "⌟", NULL},
{"drcrop", "⌌", NULL},
{"dscr", "𝒹", NULL},
{"dscy", "ѕ", NULL},
{"dsol", "⧶", NULL},
{"dstrok", "đ", NULL},
{"dtdot", "⋱", NULL},
{"dtri", "▿", NULL},
{"dtrif", "▾", NULL},
{"duarr", "⇵", NULL},
{"duhar", "⥯", NULL},
{"dwangle", "⦦", NULL},
{"dzcy", "џ", NULL},
{"dzigrarr", "⟿", NULL},
{"eDDot", "⩷", NULL},
{"eDot", "≑", NULL},
{"eacute", "é", "é"},
{"easter", "⩮", NULL},
{"ecaron", "ě", NULL},
{"ecir", "≖", NULL},
{"ecirc", "ê", "ê"},
{"ecolon", "≕", NULL},
{"ecy", "э", NULL},
{"edot", "ė", NULL},
{"ee", "ⅇ", NULL},
{"efDot", "≒", NULL},
{"efr", "𝔢", NULL},
{"eg", "⪚", NULL},
{"egrave", "è", "è"},
{"egs", "⪖", NULL},
{"egsdot", "⪘", NULL},
{"el", "⪙", NULL},
{"elinters", "⏧", NULL},
{"ell", "ℓ", NULL},
{"els", "⪕", NULL},
{"elsdot", "⪗", NULL},
{"emacr", "ē", NULL},
{"empty", "∅", "∅"},
{"emptyset", "∅", NULL},
{"emptyv", "∅", NULL},
{"emsp", " ", " "},
{"emsp13", " ", NULL},
{"emsp14", " ", NULL},
{"eng", "ŋ", NULL},
{"ensp", " ", " "},
{"eogon", "ę", NULL},
{"eopf", "𝕖", NULL},
{"epar", "⋕", NULL},
{"eparsl", "⧣", NULL},
{"eplus", "⩱", NULL},
{"epsi", "ε", NULL},
{"epsilon", "ε", "ε"},
{"epsiv", "ϵ", NULL},
{"eqcirc", "≖", NULL},
{"eqcolon", "≕", NULL},
{"eqsim", "≂", NULL},
{"eqslantgtr", "⪖", NULL},
{"eqslantless", "⪕", NULL},
{"equals", "=", NULL},
{"equest", "≟", NULL},
{"equiv", "≡", "≡"},
{"equivDD", "⩸", NULL},
{"eqvparsl", "⧥", NULL},
{"erDot", "≓", NULL},
{"erarr", "⥱", NULL},
{"escr", "ℯ", NULL},
{"esdot", "≐", NULL},
{"esim", "≂", NULL},
{"eta", "η", "η"},
{"eth", "ð", "ð"},
{"euml", "ë", "ë"},
{"euro", "€", "€"},
{"excl", "!", NULL},
{"exist", "∃", "∃"},
{"expectation", "ℰ", NULL},
{"exponentiale", "ⅇ", NULL},
{"fallingdotseq", "≒", NULL},
{"fcy", "ф", NULL},
{"female", "♀", NULL},
{"ffilig", "ﬃ", NULL},
{"fflig", "ﬀ", NULL},
{"ffllig", "ﬄ", NULL},
{"ffr", "𝔣", NULL},
{"filig", "ﬁ", NULL},
{"fjlig", "fj", NULL},
{"flat", "♭", NULL},
{"fllig", "ﬂ", NULL},
{"fltns", "▱", NULL},
{"fnof", "ƒ", "ƒ"},
{"fopf", "𝕗", NULL},
{"forall", "∀", "∀"},
{"fork", "⋔", NULL},
{"forkv", "⫙", NULL},
{"fpartint", "⨍", NULL},
{"frac12", "½", "½"},
{"frac13", "⅓", NULL},
{"frac14", "¼", "¼"},
{"frac15", "⅕", NULL},
{"frac16", "⅙", NULL},
{"frac18", "⅛", NULL},
{"frac23", "⅔", NULL},
{"frac25", "⅖", NULL},
{"frac34", "¾", "¾"},
{"frac35", "⅗", NULL},
{"frac38", "⅜", NULL},
{"frac45", "⅘", NULL},
{"frac56", "⅚", NULL},
{"frac58", "⅝", NULL},
{"frac78", "⅞", NULL},
{"frasl", "⁄", "⁄"},
{"frown", "⌢", NULL},
{"fscr", "𝒻", NULL},
{"gE", "≧", NULL},
{"gEl", "⪌", NULL},
{"gacute", "ǵ", NULL},
{"gamma", "γ", "γ"},
{"gammad", "ϝ", NULL},
{"gap", "⪆", NULL},
{"gbreve", "ğ", NULL},
{"gcirc", "ĝ", NULL},
{"gcy", "г", NULL},
{"gdot", "ġ", NULL},
{"ge", "≥", "≥"},
{"gel", "⋛", NULL},
{"geq", "≥", NULL},
{"geqq", "≧", NULL},
{"geqslant", "⩾", NULL},
{"ges", "⩾", NULL},
{"gescc", "⪩", NULL},
{"gesdot", "⪀", NULL},
{"gesdoto", "⪂", NULL},
{"gesdotol", "⪄", NULL},
{"gesl", "⋛︀", NULL},
{"gesles", "⪔", NULL},
{"gfr", "𝔤", NULL},
{"gg", "≫", NULL},
{"ggg", "⋙", NULL},
{"gimel", "ℷ", NULL},
{"gjcy", "ѓ", NULL},
{"gl", "≷", NULL},
{"glE", "⪒", NULL},
{"gla", "⪥", NULL},
{"glj", "⪤", NULL},
{"gnE", "≩", NULL},
{"gnap", "⪊", NULL},
{"gnapprox", "⪊", NULL},
{"gne", "⪈", NULL},
{"gneq", "⪈", NULL},
{"gneqq", "≩", NULL},
{"gnsim", "⋧", NULL},
{"gopf", "𝕘", NULL},
{"grave", "`", NULL},
{"gscr", "ℊ", NULL},
{"gsim", "≳", NULL},
{"gsime", "⪎", NULL},
{"gsiml", "⪐", NULL},
{"gt", ">", ">"},
{"gtcc", "⪧", NULL},
{"gtcir", "⩺", NULL},
{"gtdot", "⋗", NULL},
{"gtlPar", "⦕", NULL},
{"gtquest", "⩼", NULL},
{"gtrapprox", "⪆", NULL},
{"gtrarr", "⥸", NULL},
{"gtrdot", "⋗", NULL},
{"gtreqless", "⋛", NULL},
{"gtreqqless", "⪌", NULL},
{"gtrless", "≷", NULL},
{"gtrsim", "≳", NULL},
{"gvertneqq", "≩︀", NULL},
{"gvnE", "≩︀", NULL},
{"hArr", "⇔", "⇔"},
{"hairsp", " ", NULL},
{"half", "½", NULL},
{"hamilt", "ℋ", NULL},
{"hardcy", "ъ", NULL},
{"harr", "↔", "↔"},
{"harrcir", "⥈", NULL},
{"harrw", "↭", NULL},
{"hbar", "ℏ", NULL},
{"hcirc", "ĥ", NULL},
{"hearts", "♥", "♥"},
{"heartsuit", "♥", NULL},
{"hellip", "…", "…"},
{"hercon", "⊹", NULL},
{"hfr", "𝔥", NULL},
{"hksearow", "⤥", NULL},
{"hkswarow", "⤦", NULL},
{"hoarr", "⇿", NULL},
{"homtht", "∻", NULL},
{"hookleftarrow", "↩", NULL},
{"hookrightarrow", "↪", NULL},
{"hopf", "𝕙", NULL},
{"horbar", "―", NULL},
{"hscr", "𝒽", NULL},
{"hslash", "ℏ", NULL},
{"hstrok", "ħ", NULL},
{"hybull", "⁃", NULL},
{"hyphen", "‐", NULL},
{"iacute", "í", "í"},
{"ic", "⁣", NULL},
{"icirc", "î", "î"},
{"icy", "и", NULL},
{"iecy", "е", NULL},
{"iexcl", "¡", "¡"},
{"iff", "⇔", NULL},
{"ifr", "𝔦", NULL},
{"igrave", "ì", "ì"},
{"ii", "ⅈ", NULL},
{"iiiint", "⨌", NULL},
{"iiint", "∭", NULL},
{"iinfin", "⧜", NULL},
{"iiota", "℩", NULL},
{"ijlig", "ĳ", NULL},
{"imacr", "ī", NULL},
{"image", "ℑ", "ℑ"},
{"imagline", "ℐ", NULL},
{"imagpart", "ℑ", NULL},
{"imath", "ı", NULL},
{"imof", "⊷", NULL},
{"imped", "Ƶ", NULL},
{"in", "∈", NULL},
{"incare", "℅", NULL},
{"infin", "∞", "∞"},
{"infintie", "⧝", NULL},
{"inodot", "ı", NULL},
{"int", "∫", "∫"},
{"intcal", "⊺", NULL},
{"integers", "ℤ", NULL},
{"intercal", "⊺", NULL},
{"intlarhk", "⨗", NULL},
{"intprod", "⨼", NULL},
{"iocy", "ё", NULL},
{"iogon", "į", NULL},
{"iopf", "𝕚", NULL},
{"iota", "ι", "ι"},
{"iprod", "⨼", NULL},
{"iquest", "¿", "¿"},
{"iscr", "𝒾", NULL},
{"isin", "∈", "∈"},
{"isinE", "⋹", NULL},
{"isindot", "⋵", NULL},
{"isins", "⋴", NULL},
{"isinsv", "⋳", NULL},
{"isinv", "∈", NULL},
{"it", "⁢", NULL},
{"itilde", "ĩ", NULL},
{"iukcy", "і", NULL},
{"iuml", "ï", "ï"},
{"jcirc", "ĵ", NULL},
{"jcy", "й", NULL},
{"jfr", "𝔧", NULL},
{"jmath", "ȷ", NULL},
{"jopf", "𝕛", NULL},
{"jscr", "𝒿", NULL},
{"jsercy", "ј", NULL},
{"jukcy", "є", NULL},
{"kappa", "κ", "κ"},
{"kappav", "ϰ", NULL},
{"kcedil", "ķ", NULL},
{"kcy", "к", NULL},
{"kfr", "𝔨", NULL},
{"kgreen", "ĸ", NULL},
{"khcy", "х", NULL},
{"kjcy", "ќ", NULL},
{"kopf", "𝕜", NULL},
{"kscr", "𝓀", NULL},
{"lAarr", "⇚", NULL},
{"lArr", "⇐", "⇐"},
{"lAtail", "⤛", NULL},
{"lBarr", "⤎", NULL},
{"lE", "≦", NULL},
{"lEg", "⪋", NULL},
{"lHar", "⥢", NULL},
{"lacute", "ĺ", NULL},
{"laemptyv", "⦴", NULL},
{"lagran", "ℒ", NULL},
{"lambda", "λ", "λ"},
{"lang", "⟨", "〈"},
{"langd", "⦑", NULL},
{"langle", "⟨", NULL},
{"lap", "⪅", NULL},
{"laquo", "«", "«"},
{"larr", "←", "←"},
{"larrb", "⇤", NULL},
{"larrbfs", "⤟", NULL},
{"larrfs", "⤝", NULL},
{"larrhk", "↩", NULL},
{"larrlp", "↫", NULL},
{"larrpl", "⤹", NULL},
{"larrsim", "⥳", NULL},
{"larrtl", "↢", NULL},
{"lat", "⪫", NULL},
{"latail", "⤙", NULL},
{"late", "⪭", NULL},
{"lates", "⪭︀", NULL},
{"lbarr", "⤌", NULL},
{"lbbrk", "❲", NULL},
{"lbrace", "{", NULL},
{"lbrack", "[", NULL},
{"lbrke", "⦋", NULL},
{"lbrksld", "⦏", NULL},
{"lbrkslu", "⦍", NULL},
{"lcaron", "ľ", NULL},
{"lcedil", "ļ", NULL},
{"lceil", "⌈", "⌈"},
{"lcub", "{", NULL},
{"lcy", "л", NULL},
{"ldca", "⤶", NULL},
{"ldquo", "“", "“"},
{"ldquor", "„", NULL},
{"ldrdhar", "⥧", NULL},
{"ldrushar", "⥋", NULL},
{"ldsh", "↲", NULL},
{"le", "≤", "≤"},
{"leftarrow", "←", NULL},
{"leftarrowtail", "↢", NULL},
{"leftharpoondown", "↽", NULL},
{"leftharpoonup", "↼", NULL},
{"leftleftarrows", "⇇", NULL},
{"leftrightarrow", "↔", NULL},
{"leftrightarrows", "⇆", NULL},
{"leftrightharpoons", "⇋", NULL},
{"leftrightsquigarrow", "↭", NULL},
{"leftthreetimes", "⋋", NULL},
{"leg", "⋚", NULL},
{"leq", "≤", NULL},
{"leqq", "≦", NULL},
{"leqslant", "⩽", NULL},
{"les", "⩽", NULL},
{"lescc", "⪨", NULL},
{"lesdot", "⩿", NULL},
{"lesdoto", "⪁", NULL},
{"lesdotor", "⪃", NULL},
{"lesg", "⋚︀", NULL},
{"lesges", "⪓", NULL},
{"lessapprox", "⪅", NULL},
{"lessdot", "⋖", NULL},
{"lesseqgtr", "⋚", NULL},
{"lesseqqgtr", "⪋", NULL},
{"lessgtr", "≶", NULL},
{"lesssim", "≲", NULL},
{"lfisht", "⥼", NULL},
{"lfloor", "⌊", "⌊"},
{"lfr", "𝔩", NULL},
{"lg", "≶", NULL},
{"lgE", "⪑", NULL},
{"lhard", "↽", NULL},
{"lharu", "↼", NULL},
{"lharul", "⥪", NULL},
{"lhblk", "▄", NULL},
{"ljcy", "љ", NULL},
{"ll", "≪", NULL},
{"llarr", "⇇", NULL},
{"llcorner", "⌞", NULL},
{"llhard", "⥫", NULL},
{"lltri", "◺", NULL},
{"lmidot", "ŀ", NULL},
{"lmoust", "⎰", NULL},
{"lmoustache", "⎰", NULL},
{"lnE", "≨", NULL},
{"lnap", "⪉", NULL},
{"lnapprox", "⪉", NULL},
{"lne", "⪇", NULL},
{"lneq", "⪇", NULL},
{"lneqq", "≨", NULL},
{"lnsim", "⋦", NULL},
{"loang", "⟬", NULL},
{"loarr", "⇽", NULL},
{"lobrk", "⟦", NULL},
{"longleftarrow", "⟵", NULL},
{"longleftrightarrow", "⟷", NULL},
{"longmapsto", "⟼", NULL},
{"longrightarrow", "⟶", NULL},
{"looparrowleft", "↫", NULL},
{"looparrowright", "↬", NULL},
{"lopar", "⦅", NULL},
{"lopf", "𝕝", NULL},
{"loplus", "⨭", NULL},
{"lotimes", "⨴", NULL},
{"lowast", "∗", "∗"},
{"lowbar", "_", NULL},
{"loz", "◊", "◊"},
{"lozenge", "◊", NULL},
{"lozf", "⧫", NULL},
{"lpar", "(", NULL},
{"lparlt", "⦓", NULL},
{"lrarr", "⇆", NULL},
{"lrcorner", "⌟", NULL},
{"lrhar", "⇋", NULL},
{"lrhard", "⥭", NULL},
{"lrm", "‎", "‎"},
{"lrtri", "⊿", NULL},
{"lsaquo", "‹", "‹"},
{"lscr", "𝓁", NULL},
{"lsh", "↰", NULL},
{"lsim", "≲", NULL},
{"lsime", "⪍", NULL},
{"lsimg", "⪏", NULL},
{"lsqb", "[", NULL},
{"lsquo", "‘", "‘"},
{"lsquor", "‚", NULL},
{"lstrok", "ł", NULL},
{"lt", "<", "<"},
{"ltcc", "⪦", NULL},
{"ltcir", "⩹", NULL},
{"ltdot", "⋖", NULL},
{"lthree", "⋋", NULL},
{"ltimes", "⋉", NULL},
{"ltlarr", "⥶", NULL},
{"ltquest", "⩻", NULL},
{"ltrPar", "⦖", NULL},
{"ltri", "◃", NULL},
{"ltrie", "⊴", NULL},
{"ltrif", "◂", NULL},
{"lurdshar", "⥊", NULL},
{"luruhar", "⥦", NULL},
{"lvertneqq", "≨︀", NULL},
{"lvnE", "≨︀", NULL},
{"mDDot", "∺", NULL},
{"macr", "¯", "¯"},
{"male", "♂", NULL},
{"malt", "✠", NULL},
{"maltese", "✠", NULL},
{"map", "↦", NULL},
{"mapsto", "↦", NULL},
{"mapstodown", "↧", NULL},
{"mapstoleft", "↤", NULL},
{"mapstoup", "↥", NULL},
{"marker", "▮", NULL},
{"mcomma", "⨩", NULL},
{"mcy", "м", NULL},
{"mdash", "—", "—"},
{"measuredangle", "∡", NULL},
{"mfr", "𝔪", NULL},
{"mho", "℧", NULL},
{"micro", "µ", "µ"},
{"mid", "∣", NULL},
{"midast", "*", NULL},
{"midcir", "⫰", NULL},
{"middot", "·", "·"},
{"minus", "−", "−"},
{"minusb", "⊟", NULL},
{"minusd", "∸", NULL},
{"minusdu", "⨪", NULL},
{"mlcp", "⫛", NULL},
{"mldr", "…", NULL},
{"mnplus", "∓", NULL},
{"models", "⊧", NULL},
{"mopf", "𝕞", NULL},
{"mp", "∓", NULL},
{"mscr", "𝓂", NULL},
{"mstpos", "∾", NULL},
{"mu", "μ", "μ"},
{"multimap", "⊸", NULL},
{"mumap", "⊸", NULL},
{"nGg", "⋙̸", NULL},
{"nGt", "≫⃒", NULL},
{"nGtv", "≫̸", NULL},
{"nLeftarrow", "⇍", NULL},
{"nLeftrightarrow", "⇎", NULL},
{"nLl", "⋘̸", NULL},
{"nLt", "≪⃒", NULL},
{"nLtv", "≪̸", NULL},
{"nRightarrow", "⇏", NULL},
{"nVDash", "⊯", NULL},
{"nVdash", "⊮", NULL},
{"nabla", "∇", "∇"},
{"nacute", "ń", NULL},
{"nang", "∠⃒", NULL},
{"nap", "≉", NULL},
{"napE", "⩰̸", NULL},
{"napid", "≋̸", NULL},
{"napos", "ŉ", NULL},
{"napprox", "≉", NULL},
{"natur", "♮", NULL},
{"natural", "♮", NULL},
{"naturals", "ℕ", NULL},
{"nbsp", " ", " "},
{"nbump", "≎̸", NULL},
{"nbumpe", "≏̸", NULL},
{"ncap", "⩃", NULL},
{"ncaron", "ň", NULL},
{"ncedil", "ņ", NULL},
{"ncong", "≇", NULL},
{"ncongdot", "⩭̸", NULL},
{"ncup", "⩂", NULL},
{"ncy", "н", NULL},
{"ndash", "–", "–"},
{"ne", "≠", "≠"},
{"neArr", "⇗", NULL},
{"nearhk", "⤤", NULL},
{"nearr", "↗", NULL},
{"nearrow", "↗", NULL},
{"nedot", "≐̸", NULL},
{"nequiv", "≢", NULL},
{"nesear", "⤨", NULL},
{"nesim", "≂̸", NULL},
{"nexist", "∄", NULL},
{"nexists", "∄", NULL},
{"nfr", "𝔫", NULL},
{"ngE", "≧̸", NULL},
{"nge", "≱", NULL},
{"ngeq", "≱", NULL},
{"ngeqq", "≧̸", NULL},
{"ngeqslant", "⩾̸", NULL},
{"nges", "⩾̸", NULL},
{"ngsim", "≵", NULL},
{"ngt", "≯", NULL},
{"ngtr", "≯", NULL},
{"nhArr", "⇎", NULL},
{"nharr", "↮", NULL},
{"nhpar", "⫲", NULL},
{"ni", "∋", "∋"},
{"nis", "⋼", NULL},
{"nisd", "⋺", NULL},
{"niv", "∋", NULL},
{"njcy", "њ", NULL},
{"nlArr", "⇍", NULL},
{"nlE", "≦̸", NULL},
{"nlarr", "↚", NULL},
{"nldr", "‥", NULL},
{"nle", "≰", NULL},
{"nleftarrow", "↚", NULL},
{"nleftrightarrow", "↮", NULL},
{"nleq", "≰", NULL},
{"nleqq", "≦̸", NULL},
{"nleqslant", "⩽̸", NULL},
{"nles", "⩽̸", NULL},
{"nless", "≮", NULL},
{"nlsim", "≴", NULL},
{"nlt", "≮", NULL},
{"nltri", "⋪", NULL},
{"nltrie", "⋬", NULL},
{"nmid", "∤", NULL},
{"nopf", "𝕟", NULL},
{"not", "¬", "¬"},
{"notin", "∉", "∉"},
{"notinE", "⋹̸", NULL},
{"notindot", "⋵̸", NULL},
{"notinva", "∉", NULL},
{"notinvb", "⋷", NULL},
{"notinvc", "⋶", NULL},
{"notni", "∌", NULL},
{"notniva", "∌", NULL},
{"notnivb", "⋾", NULL},
{"notnivc", "⋽", NULL},
{"npar", "∦", NULL},
{"nparallel", "∦", NULL},
{"nparsl", "⫽⃥", NULL},
{"npart", "∂̸", NULL},
{"npolint", "⨔", NULL},
{"npr", "⊀", NULL},
{"nprcue", "⋠", NULL},
{"npre", "⪯̸", NULL},
{"nprec", "⊀", NULL},
{"npreceq", "⪯̸", NULL},
{"nrArr", "⇏", NULL},
{"nrarr", "↛", NULL},
{"nrarrc", "⤳̸", NULL},
{"nrarrw", "↝̸", NULL},
{"nrightarrow", "↛", NULL},
{"nrtri", "⋫", NULL},
{"nrtrie", "⋭", NULL},
{"nsc", "⊁", NULL},
{"nsccue", "⋡", NULL},
{"nsce", "⪰̸", NULL},
{"nscr", "𝓃", NULL},
{"nshortmid", "∤", NULL},
{"nshortparallel", "∦", NULL},
{"nsim", "≁", NULL},
{"nsime", "≄", NULL},
{"nsimeq", "≄", NULL},
{"nsmid", "∤", NULL},
{"nspar", "∦", NULL},
{"nsqsube", "⋢", NULL},
{"nsqsupe", "⋣", NULL},
{"nsub", "⊄", "⊄"},
{"nsubE", "⫅̸", NULL},
{"nsube", "⊈", NULL},
{"nsubset", "⊂⃒", NULL},
{"nsubseteq", "⊈", NULL},
{"nsubseteqq", "⫅̸", NULL},
{"nsucc", "⊁", NULL},
{"nsucceq", "⪰̸", NULL},
{"nsup", "⊅", NULL},
{"nsupE", "⫆̸", NULL},
{"nsupe", "⊉", NULL},
{"nsupset", "⊃⃒", NULL},
{"nsupseteq", "⊉", NULL},
{"nsupseteqq", "⫆̸", NULL},
{"ntgl", "≹", NULL},
{"ntilde", "ñ", "ñ"},
{"ntlg", "≸", NULL},
{"ntriangleleft", "⋪", NULL},
{"ntrianglelefteq", "⋬", NULL},
{"ntriangleright", "⋫", NULL},
{"ntrianglerighteq", "⋭", NULL},
{"nu", "ν", "ν"},
{"num", "#", NULL},
{"numero", "№", NULL},
{"numsp", " ", NULL},
{"nvDash", "⊭", NULL},
{"nvHarr", "⤄", NULL},
{"nvap", "≍⃒", NULL},
{"nvdash", "⊬", NULL},
{"nvge", "≥⃒", NULL},
{"nvgt", ">⃒", NULL},
{"nvinfin", "⧞", NULL},
{"nvlArr", "⤂", NULL},
{"nvle", "≤⃒", NULL},
{"nvlt", "<⃒", NULL},
{"nvltrie", "⊴⃒", NULL},
{"nvrArr", "⤃", NULL},
{"nvrtrie", "⊵⃒", NULL},
{"nvsim", "∼⃒", NULL},
{"nwArr", "⇖", NULL},
{"nwarhk", "⤣", NULL},
{"nwarr", "↖", NULL},
{"nwarrow", "↖", NULL},
{"nwnear", "⤧", NULL},
{"oS", "Ⓢ", NULL},
{"oacute", "ó", "ó"},
{"oast", "⊛", NULL},
{"ocir", "⊚", NULL},
{"ocirc", "ô", "ô"},
{"ocy", "о", NULL},
{"odash", "⊝", NULL},
{"odblac", "ő", NULL},
{"odiv", "⨸", NULL},
{"odot", "⊙", NULL},
{"odsold", "⦼", NULL},
{"oelig", "œ", "œ"},
{"ofcir", "⦿", NULL},
{"ofr", "𝔬", NULL},
{"ogon", "˛", NULL},
{"ograve", "ò", "ò"},
{"ogt", "⧁", NULL},
{"ohbar", "⦵", NULL},
{"ohm", "Ω", NULL},
{"oint", "∮", NULL},
{"olarr", "↺", NULL},
{"olcir", "⦾", NULL},
{"olcross", "⦻", NULL},
{"oline", "‾", "‾"},
{"olt", "⧀", NULL},
{"omacr", "ō", NULL},
{"omega", "ω", "ω"},
{"omicron", "ο", "ο"},
{"omid", "⦶", NULL},
{"ominus", "⊖", NULL},
{"oopf", "𝕠", NULL},
{"opar", "⦷", NULL},
{"operp", "⦹", NULL},
{"oplus", "⊕", "⊕"},
{"or", "∨", "∨"},
{"orarr", "↻", NULL},
{"ord", "⩝", NULL},
{"order", "ℴ", NULL},
{"orderof", "ℴ", NULL},
{"ordf", "ª", "ª"},
{"ordm", "º", "º"},
{"origof", "⊶", NULL},
{"oror", "⩖", NULL},
{"orslope", "⩗", NULL},
{"orv", "⩛", NULL},
{"oscr", "ℴ", NULL},
{"oslash", "ø", "ø"},
{"osol", "⊘", NULL},
{"otilde", "õ", "õ"},
{"otimes", "⊗", "⊗"},
{"otimesas", "⨶", NULL},
{"ouml", "ö", "ö"},
{"ovbar", "⌽", NULL},
{"par", "∥", NULL},
{"para", "¶", "¶"},
{"parallel", "∥", NULL},
{"parsim", "⫳", NULL},
{"parsl", "⫽", NULL},
{"part", "∂", "∂"},
{"pcy", "п", NULL},
{"percnt", "%", NULL},
{"period", ".", NULL},
{"permil", "‰", "‰"},
{"perp", "⊥", "⊥"},
{"pertenk", "‱", NULL},
{"pfr", "𝔭", NULL},
{"phi", "φ", "φ"},
{"phiv", "ϕ", NULL},
{"phmmat", "ℳ", NULL},
{"phone", "☎", NULL},
{"pi", "π", "π"},
{"pitchfork", "⋔", NULL},
{"piv", "ϖ", "ϖ"},
{"planck", "ℏ", NULL},
{"planckh", "ℎ", NULL},
{"plankv", "ℏ", NULL},
{"plus", "+", NULL},
{"plusacir", "⨣", NULL},
{"plusb", "⊞", NULL},
{"pluscir", "⨢", NULL},
{"plusdo", "∔", NULL},
{"plusdu", "⨥", NULL},
{"pluse", "⩲", NULL},
{"plusmn", "±", "±"},
{"plussim", "⨦", NULL},
{"plustwo", "⨧", NULL},
{"pm", "±", NULL},
{"pointint", "⨕", NULL},
{"popf", "𝕡", NULL},
{"pound", "£", "£"},
{"pr", "≺", NULL},
{"prE", "⪳", NULL},
{"prap", "⪷", NULL},
{"prcue", "≼", NULL},
{"pre", "⪯", NULL},
{"prec", "≺", NULL},
{"precapprox", "⪷", NULL},
{"preccurlyeq", "≼", NULL},
{"preceq", "⪯", NULL},
{"precnapprox", "⪹", NULL},
{"precneqq", "⪵", NULL},
{"precnsim", "⋨", NULL},
{"precsim", "≾", NULL},
{"prime", "′", "′"},
{"primes", "ℙ", NULL},
{"prnE", "⪵", NULL},
{"prnap", "⪹", NULL},
{"prnsim", "⋨", NULL},
{"prod", "∏", "∏"},
{"profalar", "⌮", NULL},
{"profline", "⌒", NULL},
{"profsurf", "⌓", NULL},
{"prop", "∝", "∝"},
{"propto", "∝", NULL},
{"prsim", "≾", NULL},
{"prurel", "⊰", NULL},
{"pscr", "𝓅", NULL},
{"psi", "ψ", "ψ"},
{"puncsp", " ", NULL},
{"qfr", "𝔮", NULL},
{"qint", "⨌", NULL},
{"qopf", "𝕢", NULL},
{"qprime", "⁗", NULL},
{"qscr", "𝓆", NULL},
{"quaternions", "ℍ", NULL},
{"quatint", "⨖", NULL},
{"quest", "?", NULL},
{"questeq", "≟", NULL},
{"quot", "\"", "\""},
{"rAarr", "⇛", NULL},
{"rArr", "⇒", "⇒"},
{"rAtail", "⤜", NULL},
{"rBarr", "⤏", NULL},
{"rHar", "⥤", NULL},
{"race", "∽̱", NULL},
{"racute", "ŕ", NULL},
{"radic", "√", "√"},
{"raemptyv", "⦳", NULL},
{"rang", "⟩", "〉"},
{"rangd", "⦒", NULL},
{"range", "⦥", NULL},
{"rangle", "⟩", NULL},
{"raquo", "»", "»"},
{"rarr", "→", "→"},
{"rarrap", "⥵", NULL},
{"rarrb", "⇥", NULL},
{"rarrbfs", "⤠", NULL},
{"rarrc", "⤳", NULL},
{"rarrfs", "⤞", NULL},
{"rarrhk", "↪", NULL},
{"rarrlp", "↬", NULL},
{"rarrpl", "⥅", NULL},
{"rarrsim", "⥴", NULL},
{"rarrtl", "↣", NULL},
{"rarrw", "↝", NULL},
{"ratail", "⤚", NULL},
{"ratio", "∶", NULL},
{"rationals", "ℚ", NULL},
{"rbarr", "⤍", NULL},
{"rbbrk", "❳", NULL},
{"rbrace", "}", NULL},
{"rbrack", "]", NULL},
{"rbrke", "⦌", NULL},
{"rbrksld", "⦎", NULL},
{"rbrkslu", "⦐", NULL},
{"rcaron", "ř", NULL},
{"rcedil", "ŗ", NULL},
{"rceil", "⌉", "⌉"},
{"rcub", "}", NULL},
{"rcy", "р", NULL},
{"rdca", "⤷", NULL},
{"rdldhar", "⥩", NULL},
{"rdquo", "”", "”"},
{"rdquor", "”", NULL},
{"rdsh", "↳", NULL},
{"real", "ℜ", "ℜ"},
{"realine", "ℛ", NULL},
{"realpart", "ℜ", NULL},
{"reals", "ℝ", NULL},
{"rect", "▭", NULL},
{"reg", "®", "®"},
{"rfisht", "⥽", NULL},
{"rfloor", "⌋", "⌋"},
{"rfr", "𝔯", NULL},
{"rhard", "⇁", NULL},
{"rharu", "⇀", NULL},
{"rharul", "⥬", NULL},
{"rho", "ρ", "ρ"},
{"rhov", "ϱ", NULL},
{"rightarrow", "→", NULL},
{"rightarrowtail", "↣", NULL},
{"rightharpoondown", "⇁", NULL},
{"rightharpoonup", "⇀", NULL},
{"rightleftarrows", "⇄", NULL},
{"rightleftharpoons", "⇌", NULL},
{"rightrightarrows", "⇉", NULL},
{"rightsquigarrow", "↝", NULL},
{"rightthreetimes", "⋌", NULL},
{"ring", "˚", NULL},
{"risingdotseq", "≓", NULL},
{"rlarr", "⇄", NULL},
{"rlhar", "⇌", NULL},
{"rlm", "‏", "‏"},
{"rmoust", "⎱", NULL},
{"rmoustache", "⎱", NULL},
{"rnmid", "⫮", NULL},
{"roang", "⟭", NULL},
{"roarr", "⇾", NULL},
{"robrk", "⟧", NULL},
{"ropar", "⦆", NULL},
{"ropf", "𝕣", NULL},
{"roplus", "⨮", NULL},
{"rotimes", "⨵", NULL},
{"rpar", ")", NULL},
{"rpargt", "⦔", NULL},
{"rppolint", "⨒", NULL},
{"rrarr", "⇉", NULL},
{"rsaquo", "›", "›"},
{"rscr", "𝓇", NULL},
{"rsh", "↱", NULL},
{"rsqb", "]", NULL},
{"rsquo", "’", "’"},
{"rsquor", "’", NULL},
{"rthree", "⋌", NULL},
{"rtimes", "⋊", NULL},
{"rtri", "▹", NULL},
{"rtrie", "⊵", NULL},
{"rtrif", "▸", NULL},
{"rtriltri", "⧎", NULL},
{"ruluhar", "⥨", NULL},
{"rx", "℞", NULL},
{"sacute", "ś", NULL},
{"sbquo", "‚", "‚"},
{"sc", "≻", NULL},
{"scE", "⪴", NULL},
{"scap", "⪸", NULL},
{"scaron", "š", "š"},
{"sccue", "≽", NULL},
{"sce", "⪰", NULL},
{"scedil", "ş", NULL},
{"scirc", "ŝ", NULL},
{"scnE", "⪶", NULL},
{"scnap", "⪺", NULL},
{"scnsim", "⋩", NULL},
{"scpolint", "⨓", NULL},
{"scsim", "≿", NULL},
{"scy", "с", NULL},
{"sdot", "⋅", "⋅"},
{"sdotb", "⊡", NULL},
{"sdote", "⩦", NULL},
{"seArr", "⇘", NULL},
{"searhk", "⤥", NULL},
{"searr", "↘", NULL},
{"searrow", "↘", NULL},
{"sect", "§", "§"},
{"semi", ";", NULL},
{"seswar", "⤩", NULL},
{"setminus", "∖", NULL},
{"setmn", "∖", NULL},
{"sext", "✶", NULL},
{"sfr", "𝔰", NULL},
{"sfrown", "⌢", NULL},
{"sharp", "♯", NULL},
{"shchcy", "щ", NULL},
{"shcy", "ш", NULL},
{"shortmid", "∣", NULL},
{"shortparallel", "∥", NULL},
{"shy", "­", "­"},
{"sigma", "σ", "σ"},
{"sigmaf", "ς", "ς"},
{"sigmav", "ς", NULL},
{"sim", "∼", "∼"},
{"simdot", "⩪", NULL},
{"sime", "≃", NULL},
{"simeq", "≃", NULL},
{"simg", "⪞", NULL},
{"simgE", "⪠", NULL},
{"siml", "⪝", NULL},
{"simlE", "⪟", NULL},
{"simne", "≆", NULL},
{"simplus", "⨤", NULL},
{"simrarr", "⥲", NULL},
{"slarr", "←", NULL},
{"smallsetminus", "∖", NULL},
{"smashp", "⨳", NULL},
{"smeparsl", "⧤", NULL},
{"smid", "∣", NULL},
{"smile", "⌣", NULL},
{"smt", "⪪", NULL},
{"smte", "⪬", NULL},
{"smtes", "⪬︀", NULL},
{"softcy", "ь", NULL},
{"sol", "/", NULL},
{"solb", "⧄", NULL},
{"solbar", "⌿", NULL},
{"sopf", "𝕤", NULL},
{"spades", "♠", "♠"},
{"spadesuit", "♠", NULL},
{"spar", "∥", NULL},
{"sqcap", "⊓", NULL},
{"sqcaps", "⊓︀", NULL},
{"sqcup", "⊔", NULL},
{"sqcups", "⊔︀", NULL},
{"sqsub", "⊏", NULL},
{"sqsube", "⊑", NULL},
{"sqsubset", "⊏", NULL},
{"sqsubseteq", "⊑", NULL},
{"sqsup", "⊐", NULL},
{"sqsupe", "⊒", NULL},
{"sqsupset", "⊐", NULL},
{"sqsupseteq", "⊒", NULL},
{"squ", "□", NULL},
{"square", "□", NULL},
{"squarf", "▪", NULL},
{"squf", "▪", NULL},
{"srarr", "→", NULL},
{"sscr", "𝓈", NULL},
{"ssetmn", "∖", NULL},
{"ssmile", "⌣", NULL},
{"sstarf", "⋆", NULL},
{"star", "☆", NULL},
{"starf", "★", NULL},
{"straightepsilon", "ϵ", NULL},
{"straightphi", "ϕ", NULL},
{"strns", "¯", NULL},
{"sub", "⊂", "⊂"},
{"subE", "⫅", NULL},
{"subdot", "⪽", NULL},
{"sube", "⊆", "⊆"},
{"subedot", "⫃", NULL},
{"submult", "⫁", NULL},
{"subnE", "⫋", NULL},
{"subne", "⊊", NULL},
{"subplus", "⪿", NULL},
{"subrarr", "⥹", NULL},
{"subset", "⊂", NULL},
{"subseteq", "⊆", NULL},
{"subseteqq", "⫅", NULL},
{"subsetneq", "⊊", NULL},
{"subsetneqq", "⫋", NULL},
{"subsim", "⫇", NULL},
{"subsub", "⫕", NULL},
{"subsup", "⫓", NULL},
{"succ", "≻", NULL},
{"succapprox", "⪸", NULL},
{"succcurlyeq", "≽", NULL},
{"succeq", "⪰", NULL},
{"succnapprox", "⪺", NULL},
{"succneqq", "⪶", NULL},
{"succnsim", "⋩", NULL},
{"succsim", "≿", NULL},
{"sum", "∑", "∑"},
{"sung", "♪", NULL},
{"sup", "⊃", "⊃"},
{"sup1", "¹", "¹"},
{"sup2", "²", "²"},
{"sup3", "³", "³"},
{"supE", "⫆", NULL},
{"supdot", "⪾", NULL},
{"supdsub", "⫘", NULL},
{"supe", "⊇", "⊇"},
{"supedot", "⫄", NULL},
{"suphsol", "⟉", NULL},
{"suphsub", "⫗", NULL},
{"suplarr", "⥻", NULL},
{"supmult", "⫂", NULL},
{"supnE", "⫌", NULL},
{"supne", "⊋", NULL},
{"supplus", "⫀", NULL},
{"supset", "⊃", NULL},
{"supseteq", "⊇", NULL},
{"supseteqq", "⫆", NULL},
{"supsetneq", "⊋", NULL},
{"supsetneqq", "⫌", NULL},
{"supsim", "⫈", NULL},
{"supsub", "⫔", NULL},
{"supsup", "⫖", NULL},
{"swArr", "⇙", NULL},
{"swarhk", "⤦", NULL},
{"swarr", "↙", NULL},
{"swarrow", "↙", NULL},
{"swnwar", "⤪", NULL},
{"szlig", "ß", "ß"},
{"target", "⌖", NULL},
{"tau", "τ", "τ"},
{"tbrk", "⎴", NULL},
{"tcaron", "ť", NULL},
{"tcedil", "ţ", NULL},
{"tcy", "т", NULL},
{"tdot", "⃛", NULL},
{"telrec", "⌕", NULL},
{"tfr", "𝔱", NULL},
{"there4", "∴", "∴"},
{"therefore", "∴", NULL},
{"theta", "θ", "θ"},
{"thetasym", "ϑ", "ϑ"},
{"thetav", "ϑ", NULL},
{"thickapprox", "≈", NULL},
{"thicksim", "∼", NULL},
{"thinsp", " ", " "},
{"thkap", "≈", NULL},
{"thksim", "∼", NULL},
{"thorn", "þ", "þ"},
{"tilde", "˜", "˜"},
{"times", "×", "×"},
{"timesb", "⊠", NULL},
{"timesbar", "⨱", NULL},
{"timesd", "⨰", NULL},
{"tint", "∭", NULL},
{"toea", "⤨", NULL},
{"top", "⊤", NULL},
{"topbot", "⌶", NULL},
{"topcir", "⫱", NULL},
{"topf", "𝕥", NULL},
{"topfork", "⫚", NULL},
{"tosa", "⤩", NULL},
{"tprime", "‴", NULL},
{"trade", "™", "™"},
{"triangle", "▵", NULL},
{"triangledown", "▿", NULL},
{"triangleleft", "◃", NULL},
{"trianglelefteq", "⊴", NULL},
{"triangleq", "≜", NULL},
{"triangleright", "▹", NULL},
{"trianglerighteq", "⊵", NULL},
{"tridot", "◬", NULL},
{"trie", "≜", NULL},
{"triminus", "⨺", NULL},
{"triplus", "⨹", NULL},
{"trisb", "⧍", NULL},
{"tritime", "⨻", NULL},
{"trpezium", "⏢", NULL},
{"tscr", "𝓉", NULL},
{"tscy", "ц", NULL},
{"tshcy", "ћ", NULL},
{"tstrok", "ŧ", NULL},
{"twixt", "≬", NULL},
{"twoheadleftarrow", "↞", NULL},
{"twoheadrightarrow", "↠", NULL},
{"uArr", "⇑", "⇑"},
{"uHar", "⥣", NULL},
{"uacute", "ú", "ú"},
{"uarr", "↑", "↑"},
{"ubrcy", "ў", NULL},
{"ubreve", "ŭ", NULL},
{"ucirc", "û", "û"},
{"ucy", "у", NULL},
{"udarr", "⇅", NULL},
{"udblac", "ű", NULL},
{"udhar", "⥮", NULL},
{"ufisht", "⥾", NULL},
{"ufr", "𝔲", NULL},
{"ugrave", "ù", "ù"},
{"uharl", "↿", NULL},
{"uharr", "↾", NULL},
{"uhblk", "▀", NULL},
{"ulcorn", "⌜", NULL},
{"ulcorner", "⌜", NULL},
{"ulcrop", "⌏", NULL},
{"ultri", "◸", NULL},
{"umacr", "ū", NULL},
{"uml", "¨", "¨"},
{"uogon", "ų", NULL},
{"uopf", "𝕦", NULL},
{"uparrow", "↑", NULL},
{"updownarrow", "↕", NULL},
{"upharpoonleft", "↿", NULL},
{"upharpoonright", "↾", NULL},
{"uplus", "⊎", NULL},
{"upsi", "υ", NULL},
{"upsih", "ϒ", "ϒ"},
{"upsilon", "υ", "υ"},
{"upuparrows", "⇈", NULL},
{"urcorn", "⌝", NULL},
{"urcorner", "⌝", NULL},
{"urcrop", "⌎", NULL},
{"uring", "ů", NULL},
{"urtri", "◹", NULL},
{"uscr", "𝓊", NULL},
{"utdot", "⋰", NULL},
{"utilde", "ũ", NULL},
{"utri", "▵", NULL},
{"utrif", "▴", NULL},
{"uuarr", "⇈", NULL},
{"uuml", "ü", "ü"},
{"uwangle", "⦧", NULL},
{"vArr", "⇕", NULL},
{"vBar", "⫨", NULL},
{"vBarv", "⫩", NULL},
{"vDash", "⊨", NULL},
{"vangrt", "⦜", NULL},
{"varepsilon", "ϵ", NULL},
{"varkappa", "ϰ", NULL},
{"varnothing", "∅", NULL},
{"varphi", "ϕ", NULL},
{"varpi", "ϖ", NULL},
{"varpropto", "∝", NULL},
{"varr", "↕", NULL},
{"varrho", "ϱ", NULL},
{"varsigma", "ς", NULL},
{"varsubsetneq", "⊊︀", NULL},
{"varsubsetneqq", "⫋︀", NULL},
{"varsupsetneq", "⊋︀", NULL},
{"varsupsetneqq", "⫌︀", NULL},
{"vartheta", "ϑ", NULL},
{"vartriangleleft", "⊲", NULL},
{"vartriangleright", "⊳", NULL},
{"vcy", "в", NULL},
{"vdash", "⊢", NULL},
{"vee", "∨", NULL},
{"veebar", "⊻", NULL},
{"veeeq", "≚", NULL},
{"vellip", "⋮", NULL},
{"verbar", "|", NULL},
{"vert", "|", NULL},
{"vfr", "𝔳", NULL},
{"vltri", "⊲", NULL},
{"vnsub", "⊂⃒", NULL},
{"vnsup", "⊃⃒", NULL},
{"vopf", "𝕧", NULL},
{"vprop", "∝", NULL},
{"vrtri", "⊳", NULL},
{"vscr", "𝓋", NULL},
{"vsubnE", "⫋︀", NULL},
{"vsubne", "⊊︀", NULL},
{"vsupnE", "⫌︀", NULL},
{"vsupne", "⊋︀", NULL},
{"vzigzag", "⦚", NULL},
{"wcirc", "ŵ", NULL},
{"wedbar", "⩟", NULL},
{"wedge", "∧", NULL},
{"wedgeq", "≙", NULL},
{"weierp", "℘", "℘"},
{"wfr", "𝔴", NULL},
{"wopf", "𝕨", NULL},
{"wp", "℘", NULL},
{"wr", "≀", NULL},
{"wreath", "≀", NULL},
{"wscr", "𝓌", NULL},
{"xcap", "⋂", NULL},
{"xcirc", "◯", NULL},
{"xcup", "⋃", NULL},
{"xdtri", "▽", NULL},
{"xfr", "𝔵", NULL},
{"xhArr", "⟺", NULL},
{"xharr", "⟷", NULL},
{"xi", "ξ", "ξ"},
{"xlArr", "⟸", NULL},
{"xlarr", "⟵", NULL},
{"xmap", "⟼", NULL},
{"xnis", "⋻", NULL},
{"xodot", "⨀", NULL},
{"xopf", "𝕩", NULL},
{"xoplus", "⨁", NULL},
{"xotime", "⨂", NULL},
{"xrArr", "⟹", NULL},
{"xrarr", "⟶", NULL},
{"xscr", "𝓍", NULL},
{"xsqcup", "⨆", NULL},
{"xuplus", "⨄", NULL},
{"xutri", "△", NULL},
{"xvee", "⋁", NULL},
{"xwedge", "⋀", NULL},
{"yacute", "ý", "ý"},
{"yacy", "я", NULL},
{"ycirc", "ŷ", NULL},
{"ycy", "ы", NULL},
{"yen", "¥", "¥"},
{"yfr", "𝔶", NULL},
{"yicy", "ї", NULL},
{"yopf", "𝕪", NULL},
{"yscr", "𝓎", NULL},
{"yucy", "ю", NULL},
{"yuml", "ÿ", "ÿ"},
{"zacute", "ź", NULL},
{"zcaron", "ž", NULL},
{"zcy", "з", NULL},
{"zdot", "ż", NULL},
{"zeetrf", "ℨ", NULL},
{"zeta", "ζ", "ζ"},
{"zfr", "𝔷", NULL},
{"zhcy", "ж", NULL},
{"zigrarr", "⇝", NULL},
{"zopf", "𝕫", NULL},
{"zscr", "𝓏", NULL},
{"zwj", "‍", "‍"},
{"zwnj", "‌", "‌"},
};
#endif /* HTML_CHARREFS_H */
