/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.DefaultConfigurableFilePermissions;
import org.gradle.api.internal.file.DefaultExpandDetails;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.file.copy.FilterChain;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.reflect.Instantiator;

public class DefaultFileCopyDetails
extends AbstractFileTreeElement
implements FileVisitDetails,
FileCopyDetailsInternal {
    private final FileVisitDetails fileDetails;
    private final CopySpecResolver specResolver;
    private final Instantiator instantiator;
    private final FilterChain filterChain;
    private final PropertyFactory propertyFactory;
    private boolean defaultDuplicatesStrategy;
    private RelativePath relativePath;
    private boolean excluded;
    private DefaultConfigurableFilePermissions permissions;
    private DuplicatesStrategy duplicatesStrategy;

    @Inject
    public DefaultFileCopyDetails(FileVisitDetails fileDetails, CopySpecResolver specResolver, Instantiator instantiator, PropertyFactory propertyFactory, Chmod chmod) {
        super(chmod);
        this.filterChain = new FilterChain(specResolver.getFilteringCharset());
        this.fileDetails = fileDetails;
        this.specResolver = specResolver;
        this.instantiator = instantiator;
        this.propertyFactory = propertyFactory;
        this.duplicatesStrategy = specResolver.getDuplicatesStrategy();
        this.defaultDuplicatesStrategy = specResolver.isDefaultDuplicateStrategy();
    }

    @Override
    public boolean isIncludeEmptyDirs() {
        return this.specResolver.getIncludeEmptyDirs();
    }

    public String getDisplayName() {
        return this.fileDetails.toString();
    }

    public void stopVisiting() {
        this.fileDetails.stopVisiting();
    }

    public File getFile() {
        if (this.filterChain.hasFilters()) {
            throw new UnsupportedOperationException();
        }
        return this.fileDetails.getFile();
    }

    public boolean isDirectory() {
        return this.fileDetails.isDirectory();
    }

    public long getLastModified() {
        return this.fileDetails.getLastModified();
    }

    public long getSize() {
        if (this.filterChain.hasFilters()) {
            ByteCountingOutputStream outputStream = new ByteCountingOutputStream();
            this.copyTo(outputStream);
            return outputStream.size;
        }
        return this.fileDetails.getSize();
    }

    public InputStream open() {
        if (this.filterChain.hasFilters()) {
            return this.filterChain.transform(this.fileDetails.open());
        }
        return this.fileDetails.open();
    }

    public void copyTo(OutputStream output) {
        if (this.filterChain.hasFilters()) {
            super.copyTo(output);
        } else {
            this.fileDetails.copyTo(output);
        }
    }

    public boolean copyTo(File target) {
        if (this.filterChain.hasFilters()) {
            return super.copyTo(target);
        }
        boolean copied = this.fileDetails.copyTo(target);
        this.adaptPermissions(target);
        return copied;
    }

    private void adaptPermissions(File target) {
        int specMode = this.getPermissions().toUnixNumeric();
        this.getChmod().chmod(target, specMode);
    }

    public RelativePath getRelativePath() {
        if (this.relativePath == null) {
            RelativePath path = this.fileDetails.getRelativePath();
            this.relativePath = this.specResolver.getDestPath().append(path.isFile(), path.getSegments());
        }
        return this.relativePath;
    }

    public FilePermissions getPermissions() {
        if (this.permissions != null) {
            return this.permissions;
        }
        Provider<FilePermissions> specMode = this.getSpecMode();
        if (specMode.isPresent()) {
            return (FilePermissions)specMode.get();
        }
        return this.fileDetails.getPermissions();
    }

    private Provider<FilePermissions> getSpecMode() {
        return this.fileDetails.isDirectory() ? this.specResolver.getImmutableDirPermissions() : this.specResolver.getImmutableFilePermissions();
    }

    public void setRelativePath(RelativePath path) {
        this.relativePath = path;
    }

    public void setName(String name) {
        this.relativePath = this.getRelativePath().replaceLastName(name);
    }

    public void setPath(String path) {
        this.relativePath = RelativePath.parse((boolean)this.getRelativePath().isFile(), (String)path);
    }

    boolean isExcluded() {
        return this.excluded;
    }

    public void exclude() {
        this.excluded = true;
    }

    @Deprecated
    public void setMode(int mode) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(CopyProcessingSpec.class, (String)"setMode()").replaceWith((Object)"permissions(Action)")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "unix_file_permissions_deprecated")).nagUser();
        this.getPermissionsHolder().unix(mode);
    }

    public void permissions(Action<? super ConfigurableFilePermissions> configureAction) {
        configureAction.execute((Object)this.getPermissionsHolder());
    }

    public void setPermissions(FilePermissions permissions) {
        this.getPermissionsHolder().unix(permissions.toUnixNumeric());
    }

    private DefaultConfigurableFilePermissions getPermissionsHolder() {
        if (this.permissions == null) {
            this.permissions = (DefaultConfigurableFilePermissions)this.instantiator.newInstance(DefaultConfigurableFilePermissions.class, new Object[]{DefaultConfigurableFilePermissions.getDefaultUnixNumeric((boolean)this.fileDetails.isDirectory())});
        }
        return this.permissions;
    }

    public ContentFilterable filter(Closure closure) {
        return this.filter(new ClosureBackedTransformer(closure));
    }

    public ContentFilterable filter(Transformer<String, String> transformer) {
        this.filterChain.add(transformer);
        return this;
    }

    public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.filterChain.add(filterType, properties);
        return this;
    }

    public ContentFilterable filter(Class<? extends FilterReader> filterType) {
        this.filterChain.add(filterType);
        return this;
    }

    public ContentFilterable expand(Map<String, ?> properties) {
        return this.expand(properties, (Action<? super ExpandDetails>)Actions.doNothing());
    }

    public ContentFilterable expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
        ExpandDetails details = (ExpandDetails)this.instantiator.newInstance(DefaultExpandDetails.class, new Object[]{this.propertyFactory});
        action.execute((Object)details);
        this.filterChain.expand(properties, (Provider<Boolean>)details.getEscapeBackslash());
        return this;
    }

    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
        this.defaultDuplicatesStrategy = strategy == DuplicatesStrategy.INHERIT;
    }

    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.duplicatesStrategy;
    }

    @Override
    public boolean isDefaultDuplicatesStrategy() {
        return this.defaultDuplicatesStrategy;
    }

    public String getSourceName() {
        return this.fileDetails.getName();
    }

    public String getSourcePath() {
        return this.fileDetails.getPath();
    }

    public RelativePath getRelativeSourcePath() {
        return this.fileDetails.getRelativePath();
    }

    private static class ByteCountingOutputStream
    extends OutputStream {
        long size;

        private ByteCountingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.size += (long)len;
        }
    }
}

