// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2012 Konrad Twardowski

#pragma once

#include "version.h" // HACK: check KS_* defines early

#include "config.h"
#include "kshutdown.h"

#include <QMenu>

class BookmarksMenu;

class BookmarkAction final: private QAction {
public:
	explicit BookmarkAction(
		const QString &text,
		const QString &actionID, const QString &triggerID,
		const QString &actionOption, const QString &triggerOption
	);
	virtual ~BookmarkAction() = default;
	QString originalText() const { return m_originalText; }
private:
	Q_DISABLE_COPY(BookmarkAction)
	friend class BookmarksMenu;
	bool m_confirmAction = true;
	bool m_userText;
	QString m_actionID;
	QString m_actionOption;
	QString m_originalText;
	QString m_triggerID;
	QString m_triggerOption;

	// event handlers:
	void onAction();
};

class BookmarksMenu final: public QMenu {
public:
	explicit BookmarksMenu(QWidget *parent);
	virtual ~BookmarksMenu() = default;
	static QString makeText(Action *action, Trigger *trigger, const QString &actionOption, const QString &triggerOption);
private:
	Q_DISABLE_COPY(BookmarksMenu)
	QAction *m_addAction;
	QList<BookmarkAction *> m_list;
	void sortList();
	void syncConfig();

	// event handlers:
	void onAddBookmark();
	void onRemoveBookmark(BookmarkAction *bookmark);
	void onUpdateMenu();
};
