/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.jvm.component.internal.DefaultJvmSoftwareComponent;

public abstract class JavaTestFixturesPlugin
implements Plugin<Project> {
    @Inject
    public JavaTestFixturesPlugin() {
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaBasePlugin.class);
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet testFixturesSourceSet = (SourceSet)extension.getSourceSets().maybeCreate("testFixtures");
        DefaultJvmFeature feature = new DefaultJvmFeature("testFixtures", testFixturesSourceSet, Collections.singleton(new ProjectDerivedCapability(project, "testFixtures")), (ProjectInternal)project, true, false);
        feature.withApi();
        project.getPluginManager().withPlugin("java", arg_0 -> this.lambda$apply$0(project, (JvmFeatureInternal)feature, arg_0));
    }

    private void createImplicitTestFixturesDependencies(JvmFeatureInternal feature, Project project) {
        DependencyHandler dependencies = project.getDependencies();
        feature.getApiConfiguration().getDependencies().add((Object)dependencies.create((Object)project));
        SourceSet testSourceSet = JavaPluginHelper.getDefaultTestSuite((Project)project).getSources();
        Configuration testImplementation = project.getConfigurations().getByName(testSourceSet.getImplementationConfigurationName());
        testImplementation.getDependencies().add((Object)dependencies.testFixtures((Object)dependencies.create((Object)project)));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{configurations.getByName(testSourceSet.getCompileClasspathConfigurationName())}));
        testSourceSet.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{testSourceSet.getOutput(), configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName())}));
    }

    private /* synthetic */ void lambda$apply$0(Project project, JvmFeatureInternal feature, AppliedPlugin plugin) {
        DefaultJvmSoftwareComponent component = (DefaultJvmSoftwareComponent)JavaPluginHelper.getJavaComponent((Project)project);
        component.getFeatures().add((Object)feature);
        component.addVariantsFromConfiguration(feature.getApiElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("compile", true, feature.getCompileClasspathConfiguration()));
        component.addVariantsFromConfiguration(feature.getRuntimeElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("runtime", true, feature.getRuntimeClasspathConfiguration()));
        this.createImplicitTestFixturesDependencies(feature, project);
    }
}

