/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer.checker;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrConstExpressionValuesEqualityCheckerKt;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualChecker;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualCheckersUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualCollectionArgumentsCompatibilityCheckStrategy;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrAnnotationConflictingDefaultArgumentValueKmpChecker;", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker;", "<init>", "()V", "check", "", "context", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker$Context;", "reportError", "expectAnnotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "actualDefaultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "actualParam", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "ir.actualization"})
public final class IrAnnotationConflictingDefaultArgumentValueKmpChecker
implements IrExpectActualChecker {
    @NotNull
    public static final IrAnnotationConflictingDefaultArgumentValueKmpChecker INSTANCE = new IrAnnotationConflictingDefaultArgumentValueKmpChecker();

    private IrAnnotationConflictingDefaultArgumentValueKmpChecker() {
    }

    @Override
    public void check(@NotNull IrExpectActualChecker.Context context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        IrExpectActualChecker.Context $this$check_u24lambda_u240 = context2;
        boolean bl = false;
        for (Map.Entry<IrSymbol, IrSymbol> entry : $this$check_u24lambda_u240.getExpectActualMap().getExpectToActual().entrySet()) {
            IrClass expectClass;
            IrSymbol expectSymbol = entry.getKey();
            IrSymbol actualSymbol = entry.getValue();
            if (!(expectSymbol instanceof IrConstructorSymbol) || !(actualSymbol instanceof IrConstructorSymbol) || (expectClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrConstructorSymbol)expectSymbol).getOwner())).getKind() != ClassKind.ANNOTATION_CLASS) continue;
            List<IrValueParameter> expectValueParams = ((IrConstructor)((IrConstructorSymbol)expectSymbol).getOwner()).getParameters();
            List<IrValueParameter> actualValueParams = ((IrConstructor)((IrConstructorSymbol)actualSymbol).getOwner()).getParameters();
            if (expectValueParams.size() != actualValueParams.size()) continue;
            for (Pair pair : CollectionsKt.zip((Iterable)expectValueParams, (Iterable)actualValueParams)) {
                IrValueParameter expectParam = (IrValueParameter)pair.component1();
                IrValueParameter actualParam = (IrValueParameter)pair.component2();
                IrElementBase irElementBase = expectParam.getDefaultValue();
                if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) continue;
                IrElementBase expectDefaultValue = irElementBase;
                IrElementBase irElementBase2 = actualParam.getDefaultValue();
                if (irElementBase2 == null || (irElementBase2 = irElementBase2.getExpression()) == null) continue;
                IrElementBase actualDefaultValue = irElementBase2;
                IrExpectActualMatchingContext $this$check_u24lambda_u240_u240 = $this$check_u24lambda_u240.getMatchingContext();
                boolean bl2 = false;
                if (IrConstExpressionValuesEqualityCheckerKt.areIrExpressionConstValuesEqual($this$check_u24lambda_u240_u240, expectDefaultValue, actualDefaultValue, ExpectActualCollectionArgumentsCompatibilityCheckStrategy.Default.INSTANCE)) continue;
                INSTANCE.reportError($this$check_u24lambda_u240, expectClass, (IrExpression)actualDefaultValue, actualParam);
            }
        }
    }

    private final void reportError(IrExpectActualChecker.Context $this$reportError, IrClass expectAnnotationClass, IrExpression actualDefaultValue, IrValueParameter actualParam) {
        IrTypeAlias actualTypealias;
        IrTypeAliasSymbol irTypeAliasSymbol = IrExpectActualCheckersUtilsKt.getTypealiasSymbolIfActualizedViaTypealias(expectAnnotationClass, $this$reportError.getClassActualizationInfo());
        IrTypeAlias irTypeAlias = actualTypealias = irTypeAliasSymbol != null ? (IrTypeAlias)irTypeAliasSymbol.getOwner() : null;
        if (actualTypealias != null) {
            IrActualizerUtilsKt.reportActualAnnotationConflictingDefaultArgumentValue($this$reportError.getDiagnosticsReporter(), actualTypealias, IrUtilsKt.getFile(actualTypealias), actualParam);
            return;
        }
        IrActualizerUtilsKt.reportActualAnnotationConflictingDefaultArgumentValue($this$reportError.getDiagnosticsReporter(), actualDefaultValue, IrUtilsKt.getFile(actualParam), actualParam);
    }
}

