/* frv simulator support code
   Copyright (C) 2000, 2001, 2003, 2007, 2008, 2009
   Free Software Foundation, Inc.
   Contributed by Red Hat.

This file is part of the GNU simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#define WANT_CPU
#define WANT_CPU_FRVBF

#include "sim-main.h"
#include "bfd.h"

#define IMPL 1 /* Implemented */
#define SUP  1 /* Supervisor register */
#define USER 0 /* User register */

#define RESERVED {0x00000000, 0x00000000, 0x00000000, 0xffffffff, ! IMPL, USER}

/* SPR definitions for the general FRV architecture.
   All registers and all features should be enabled.
   Initial and reset values are taken from the fr500 LSI.  */
static FRV_SPR_CONTROL_INFO frv_spr[] =
{
  {0x0000107e, 0x0000007c, 0x000060fd, 0xffff9600,   IMPL,   SUP}, /* PSR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000003,   IMPL,   SUP}, /* PCSR */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000003,   IMPL,   SUP}, /* BPCSR */
  {0x00000000, 0x00000000, 0x00000000, 0x000007ff,   IMPL,   SUP}, /* TBR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffeffe,   IMPL,   SUP}, /* BPSR */

  /* spr registers 5-15 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x000003c0, 0x00000000, 0xce400000, 0x313fec38,   IMPL,   SUP}, /* HSR0 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR7 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR15 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR23 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR31 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR39 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR47 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR55 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* HSR63 */

  /* spr registers 80-255 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* CCR */

  /* spr registers 257-262 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffff0000,   IMPL,  USER}, /* CCCR */

  /* spr registers 264-271 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000003,   IMPL,  USER}, /* LR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* LCR */

  /* spr registers 274-279 and 282-287 are reserved.  */
  /* spr registers 280 and 281 are iacc0h and iacc0l (fr405).  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0H */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0L */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0xe0000021, 0x20000000, 0xe0000000, 0xffffffc2,   IMPL,  USER}, /* ISR */

  /* spr registers 289-351 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NEEAR0 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NEEAR7 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NEEAR15 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NEEAR23 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NEEAR31 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NESR0 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NESR7 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NESR15 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NESR23 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,  USER}, /* NESR31 */

  {0x0000007f, 0x0000007f, 0x00000000, 0xffffffff,   IMPL,  USER}, /* NECR */

  /* spr registers 417-431 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER1 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER1 */

  /* spr registers 436-511 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR63 */

  {0x00000100, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR0 */
  {0x00000026, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR7 */
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR63 */

  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* EIR0 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* EIR7 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* EIR15 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* EIR23 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* EIR31 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR1 */

  /* spr registers 674-767 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* SR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* SR3 */

  /* spr registers 772-1023 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00800000, 0x00000000, 0x00000000, 0xc0f103ff,   IMPL,  USER}, /* FSR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* FSR63 */

  /* Each FQ register is a pair of 32 bit registers.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ0 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ7 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ15 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ23 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ31 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},

  /* spr registers 1152-1271 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* MCILR0 */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000000,   IMPL,   SUP}, /* MCILR1 */

  /* spr registers 1274-1279 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x01e00000, 0x3fff8fc0,   IMPL,  USER}, /* MSR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffc1,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* MSR63 */

  /* Each MQ register is a pair of 32 bit registers.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MQ0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MQ7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MQ15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MQ23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MQ31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* Accumulators are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC63 */

  /* Accumulator guards are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG63 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR63 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR63 */

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMLR63 */

  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IAMPR63 */

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMLR63 */

  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP}, /* DAMPR0 */
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP}, /* DAMPR7 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR15 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR31 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR39 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR47 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR55 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DAMPR63 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* AMCR  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* STBAR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* MMCR */

  /* spr registers 1923-2047 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* BRR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* NMAR */

  RESERVED, /* spr register 2051 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR3 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR3 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR03 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR13 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR33 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR03 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR13 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR23 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR33 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* CPCFR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPSR */

  RESERVED, /* spr register 2095 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPESR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPESR1 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPEMR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* CPEMR1 */

  /* spr registers 2100-2199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2200-2299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2300-2399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2400-2499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2500-2599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2600-2699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2700-2799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2800-2899 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2900-2999 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3000-3099 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3100-3199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3200-3299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3300-3399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3400-3499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3500-3599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3600-3699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3700-3799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3800-3847 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0xffffffff, 0xfffffffe,   IMPL,   SUP}, /* IHSR8 */

  /* spr registers 3849-4095 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED
};

/* SPR definitions for the fr500 machine.
   See the FR500 LSI for implementation details.  */
static FRV_SPR_CONTROL_INFO fr500_spr[] =
{
  {0x1000107e, 0x1000107c, 0xff0071fd, 0xffff9e00,   IMPL,   SUP}, /* PSR */
  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,   SUP}, /* PCSR */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000003,   IMPL,   SUP}, /* BPCSR */
  {0x00000000, 0x00000000, 0x0000000f, 0x000007ff,   IMPL,   SUP}, /* TBR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffeffe,   IMPL,   SUP}, /* BPSR */

  /* spr registers 5-15 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x000003c0, 0x00000000, 0xce000c00, 0x313fec38,   IMPL,   SUP}, /* HSR0 */

  /* HSR1-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 80-255 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* CCR */

  /* spr registers 257-262 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffff0000,   IMPL,  USER}, /* CCCR */

  /* spr registers 264-271 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,  USER}, /* LR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* LCR */

  /* spr registers 274-287 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x20000021, 0x20000000, 0xa0000000, 0xffffffc2,   IMPL,  USER}, /* ISR */

  /* spr registers 289-351 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NEEAR0-31 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NESR0-31 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NECR is unimplemented on the fr500.  */
  RESERVED,

  /* spr registers 417-431 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER1 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER1 */

  /* spr registers 436-511 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* EPCR2-7 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR8 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR13 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* EPCR16-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000100, 0x00000100, 0x00000100, 0xffffffff,   IMPL,   SUP}, /* ESR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* ESR2-7 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR8 */
  {0x00000800, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000800, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000800, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR13 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* ESR16-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EIR0-31 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* ESFR0 is unimplemented on the fr500.  */
  RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR1 */

  /* spr registers 674-767 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* SR0-SR3 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 772-1023 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00800000, 0x00800000, 0x00800000, 0xc0f103ff,   IMPL,  USER}, /* FSR0 */

  /* FSR1-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* Each FQ register is a pair of 32 bit registers.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ0 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* FQ7 */
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP},

  /* FQ10-31 are unimplemented on the fr500.  */
  /* Each FQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 1152-1271 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* MCILR0-1 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  /* spr registers 1274-1279 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x01e00000, 0x3fff8fc0,   IMPL,  USER}, /* MSR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffc1,   IMPL,  USER},

  /* MSR2-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* MQ0-31 are unimplemented on the fr500.  */
  /* Each MQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulators are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC7 */

  /* ACC8-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulator guards are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG7 */

  /* ACCG8-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EAR0-7 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR8 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR13 */

  /* EAR14-63 are unimplemented on the fr500.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EDR0-1 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR2 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* EDR4-5 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR6 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* EDR8-9 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* EDR12-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR7 */

  /* IAMLR08-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR7 */

  /* IAMPR08-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR7 */

  /* DAMLR08-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* DAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* DAMPR7 */

  /* DAMPR08-63 are unimplemented on the fr500.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000808, 0x00000808, 0x0000ffff, 0xffffffff,   IMPL,   SUP}, /* AMCR  */

  /* STBAR, MMCR not implemented on the fr500.  */
  RESERVED, RESERVED,

  /* spr registers 1923-2047 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* BRR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* NMAR */

  RESERVED, /* spr register 2051 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR02-03 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR12-13 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR22-23 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR32-33 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR02-03 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR12-13 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR22-23 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR32-33 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  /* CPCFR, CPCR and CPSR are unimplemented on the fr500.  */
  RESERVED, RESERVED, RESERVED,

  RESERVED, /* spr register 2095 */

  /* CPESR0-1 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  /* CPEMR0-1 are unimplemented on the fr500.  */
  RESERVED, RESERVED,

  /* spr registers 2100-2199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2200-2299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2300-2399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2400-2499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2500-2599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2600-2699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2700-2799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2800-2899 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2900-2999 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3000-3099 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3100-3199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3200-3299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3300-3399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3400-3499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3500-3599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3600-3699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3700-3799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3800-3847 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xfffffffe,   IMPL,   SUP}, /* IHSR8 */

  /* spr registers 3849-4095 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED
};

/* SPR definitions for the fr550 machine.
   See the FR550 LSI for implementation details.  */
static FRV_SPR_CONTROL_INFO fr550_spr[] =
{
  {0x3000107e, 0x3000107c, 0xff0071fd, 0xffff9e00,   IMPL,   SUP}, /* PSR */
  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,   SUP}, /* PCSR */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000003,   IMPL,   SUP}, /* BPCSR */
  {0x00000000, 0x00000000, 0x0000000f, 0x000007ff,   IMPL,   SUP}, /* TBR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffeffe,   IMPL,   SUP}, /* BPSR */

  /* spr registers 5-15 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x000003c0, 0x00000000, 0xce000c00, 0x313fec38,   IMPL,   SUP}, /* HSR0 */

  /* HSR1-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 80-255 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* CCR */

  /* spr registers 257-262 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffff0000,   IMPL,  USER}, /* CCCR */

  /* spr registers 264-271 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,  USER}, /* LR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* LCR */

  /* spr registers 274-287 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x20000030, 0x20000000, 0xa0000000, 0xffffffd3,   IMPL,  USER}, /* ISR */

  /* spr registers 289-351 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NEEAR0-31 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NESR0-31 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NECR is unimplemented on the fr550.  */
  RESERVED,

  /* spr registers 417-431 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* GNER1 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* FNER1 */

  /* spr registers 436-511 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR0 */
  RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR2 */

  /* EPCR3-7 are unimplemented on the fr550.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR8 */

  /* EPCR9-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000100, 0x00000100, 0x00000100, 0xffffffff,   IMPL,   SUP}, /* ESR0 */
  RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR2 */

  /* ESR3-7 are unimplemented on the fr550.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000200, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR8 */

  /* ESR9-13 are unimplemented on the fr550.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR14 */
  {0x00000020, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* ESR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EIR0-31 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* ESFR0 is unimplemented on the fr550.  */
  RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR1 */

  /* spr registers 674-767 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* SR0-SR3 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 772-1023 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00800000, 0x00800000, 0xc0e00000, 0xc0fe03ff,   IMPL,  USER}, /* FSR0 */

  /* FSR1-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* FQ0-31 are unimplemented on the fr550.  */
  /* Each FQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* spr registers 1152-1271 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* MCILR0-1 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  /* spr registers 1274-1279 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00001002, 0x00000000, 0x01e00000, 0x07ffffc2,   IMPL,  USER}, /* MSR0 */

  /* MSR1-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* MQ0-31 are unimplemented on the fr550.  */
  /* Each MQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulators are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC7 */

  /* ACC8-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulator guards are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG7 */

  /* ACCG8-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EAR0-7 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR8 */

  /* EAR9-14 are unimplemented on the fr550.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR15 */

  /* EAR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EDR0-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR8 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* IAMLR15 */

  /* IAMLR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR8 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* IAMPR15 */

  /* IAMPR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR8 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fffff,   IMPL,   SUP}, /* DAMLR15 */

  /* DAMLR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* DAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* DAMPR8 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff00,   IMPL,   SUP}, /* DAMPR15 */

  /* DAMPR16-63 are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00001010, 0x00001010, 0x0000ffff, 0xffffffff,   IMPL,   SUP}, /* AMCR  */

  /* STBAR, MMCR not implemented on the fr550.  */
  RESERVED, RESERVED,

  /* spr registers 1923-2047 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* BRR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* NMAR */

  RESERVED, /* spr register 2051 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR02-03 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR12-13 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR22-23 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR32-33 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR02-03 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR12-13 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR20 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR22-23 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR30 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR32-33 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  /* CPCFR, CPCR and CPSR are unimplemented on the fr550.  */
  RESERVED, RESERVED, RESERVED,

  RESERVED, /* spr register 2095 */

  /* CPESR0-1 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  /* CPEMR0-1 are unimplemented on the fr550.  */
  RESERVED, RESERVED,

  /* spr registers 2100-2199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2200-2299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2300-2399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2400-2499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2500-2599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2600-2699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2700-2799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2800-2899 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2900-2999 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3000-3099 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3100-3199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3200-3299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3300-3399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3400-3499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3500-3599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3600-3699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3700-3799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3800-3847 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000001, 0x00000000, 0x00000000, 0xffff88fd,   IMPL,   SUP}, /* IHSR8 */

  /* spr registers 3849-4095 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED
};

/* SPR definitions for the fr400 machine.
   See the FR400 LSI for implementation details.  */
static FRV_SPR_CONTROL_INFO fr400_spr[] =
{
  {0x200030fe, 0x200030fc, 0xf00030fd, 0xffffff80,   IMPL,   SUP}, /* PSR */
  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,   SUP}, /* PCSR */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000003,   IMPL,   SUP}, /* BPCSR */
  {0x00000000, 0x00000000, 0x0000000f, 0x000007ff,   IMPL,   SUP}, /* TBR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffeffe,   IMPL,   SUP}, /* BPSR */

  /* spr registers 5-15 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000d40, 0x00000d40, 0xcc400fc0, 0x317feff8,   IMPL,   SUP}, /* HSR0 */

  /* HSR1-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 80-255 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* CCR */

  /* spr registers 257-262 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffff0000,   IMPL,  USER}, /* CCCR */

  /* spr registers 264-271 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,  USER}, /* LR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* LCR */

  /* spr registers 274-279 and 282-287 are reserved.  */
  /* spr registers 280 and 281 are iacc0h and iacc0l (fr405).  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0H */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0L */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x20000021, 0x20000000, 0xa0000000, 0xffffffc2,   IMPL,  USER}, /* ISR */

  /* spr registers 289-351 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NEEAR0-31 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NESR0-31 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* NECR is unimplemented on the fr400.  */
  RESERVED,

  /* spr registers 417-431 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* GNER0, GNER1, FNER0, FNER1 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 436-511 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR0 */

  /* EPCR1-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000100, 0x00000100, 0x00000100, 0xffffffff,   IMPL,   SUP}, /* ESR0 */

  /* ESR1-13 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR14 */
  {0x00000800, 0x00000800, 0x00000800, 0xffffffff,   IMPL,   SUP},

  /* ESR16-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EIR0-31 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* ESFR0 is unimplemented on the fr400.  */
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR1 */

  /* spr registers 674-767 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* SR0-3 ARE unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 772-1023 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* FSR0-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* FQ0-31 are unimplemented on the fr400.  */
  /* Each FQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 1152-1271 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* MCILR0-1 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  /* spr registers 1274-1279 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x01c00000, 0x0fff8fc0,   IMPL,  USER}, /* MSR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffcd,   IMPL,  USER},

  /* MSR2-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* MQ0-31 are unimplemented on the fr400.  */
  /* Each MQ register is a pair of 32 bit registers.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulators are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  /* ACC4-63 are unimplemented on the fr400.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* Accumulator guards are read-only by the user except for special
     insns and side effect of other insns.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  /* ACCG4-63 are unimplemented on the fr400.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EAR0-14 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR15 */

  /* EAR16-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* EDR0-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* IAMLR0-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP}, /* IAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x000fff02,   IMPL,   SUP}, /* IAMPR7 */

  /* IAMPR08-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* DAMLR0-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP}, /* DAMPR0 */
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x000fff00,   IMPL,   SUP}, /* DAMPR7 */

  /* DAMPR08-63 are unimplemented on the fr400.  */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000808, 0x00000808, 0x00000808, 0xffffffff,   IMPL,   SUP}, /* AMCR  */

  /* STBAR, MMCR not implemented on the fr400.  */
  RESERVED, RESERVED,

  /* spr registers 1923-2047 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* BRR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* NMAR */

  RESERVED, /* spr register 2051 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBAR2-3 not implemented on the fr400.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR02-03 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBDR12-13 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  /* DBDR20-23 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* DBDR30-33 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR02-03 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* DBMR12-13 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  /* DBMR20-23 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* DBMR30-33 are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED, RESERVED,

  /* CPCFR, CPCR and CPSR are unimplemented on the fr400.  */
  RESERVED, RESERVED, RESERVED,

  RESERVED, /* spr register 2095 */

  /* CPESR0-1 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  /* CPEMR0-1 are unimplemented on the fr400.  */
  RESERVED, RESERVED,

  /* spr registers 2100-2199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2200-2299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2300-2399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2400-2499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2500-2599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2600-2699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2700-2799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2800-2899 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 2900-2999 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3000-3099 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3100-3199 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3200-3299 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3300-3399 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3400-3499 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3500-3599 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3600-3699 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3700-3799 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3800-3899 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 3900-3999 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  /* spr registers 4000-4095 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED
};

/* SPR definitions for the fr450 machine.
   See the FR451 LSI for implementation details.  */
static FRV_SPR_CONTROL_INFO fr450_spr[] =
{
  {0x200030fe, 0x200030fc, 0xf00030fd, 0xffffff80,   IMPL,   SUP}, /* PSR */
  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,   SUP}, /* PCSR */
  {0x00000000, 0x00000000, 0xffffffff, 0x00000003,   IMPL,   SUP}, /* BPCSR */
  {0x00000000, 0x00000000, 0x0000000f, 0x00000fff,   IMPL,   SUP}, /* TBR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffeffe,   IMPL,   SUP}, /* BPSR */

  /* spr registers 5-15 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000d40, 0x00000d40, 0xcc400fc0, 0x20742ff8,   IMPL,   SUP}, /* HSR0 */

  /* spr registers 17-255 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* CCR */

  /* spr registers 257-262 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffff0000,   IMPL,  USER}, /* CCCR */

  /* spr registers 264-271 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000003, 0x00000003,   IMPL,  USER}, /* LR */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* LCR */

  /* spr registers 274-279 and reserved.  */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0H */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,  USER}, /* IACC0L */

  /* spr registers 282-287 and reserved.  */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x20000021, 0x20000000, 0xa0000000, 0xffffffc2,   IMPL,  USER}, /* ISR */

  /* spr registers 289-511 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EPCR0 */

  /* spr registers 513-575 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000100, 0x00000100, 0x00000100, 0xffffffff,   IMPL,   SUP}, /* ESR0 */

  /* spr registers 577-589 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESR14 */
  {0x00000800, 0x00000800, 0x00000800, 0xffffffff,   IMPL,   SUP},

  /* spr registers 592-672 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* ESFR1 */

  /* spr registers 674-831 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* SCR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP},

  /* spr registers 836-1279 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x01c00000, 0x0fff8fc0,   IMPL,  USER}, /* MSR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffcd,   IMPL,  USER},

  /* spr registers 1282-1407 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  /* Accumulators are read-only by the user except for special insns and
     side effect of other insns.  ACC0-3 (1408-1411) and ACC8-11 (1416-1419)
     are implemented, ACC4-7 are not.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACC8 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  /* spr registers 1420-1471 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  /* Accumulator guards (1472-1483).  See comments above ACC0.  */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER}, /* ACCG8 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,  USER},

  /* spr registers 1484-1535 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR0 */

  /* spr registers 1537-1550 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* EAR15 */

  /* spr registers 1552-1663 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP}, /* IAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP}, /* IAMLR7 */

  /* spr registers 1672-1727 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP}, /* IAMPR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002902,   IMPL,   SUP}, /* IAMPR7 */

  /* spr registers 1736-1791 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP}, /* DAMLR0 */
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP}, /* DAMLR11 */

  /* spr registers 1804-1855 are reserved */
  RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP}, /* DAMPR0 */
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000001, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002000,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0x00002000,   IMPL,   SUP}, /* DAMPR11 */

  /* spr registers 1868-1919 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000808, 0x00000808, 0x00000808, 0xffffffff,   IMPL,   SUP}, /* AMCR  */

  /* spr registers 1921-1924 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffff00,   IMPL,   SUP}, /* IAMVR1 */
  RESERVED,
  {0x00000000, 0x00000000, 0x00000000, 0xfffff000,   IMPL,   SUP}, /* DAMVR1 */

  /* spr registers 1928-1935 are reserved */
  RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xfffff000,   IMPL,   SUP}, /* CXNR */
  {0x00000000, 0x00000000, 0x00000000, 0x000007fc,   IMPL,   SUP}, /* TTBR */
  {0x00000000, 0x00000000, 0x00000000, 0x00003000,   IMPL,   SUP}, /* TPLR */
  {0x00000000, 0x00000000, 0x00000000, 0x000031f0,   IMPL,   SUP}, /* TPPR */
  {0x00000000, 0x00000000, 0x00000000, 0x0fffffff,   IMPL,   SUP}, /* TPXR */

  /* spr registers 1941-1951 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* TIMERH */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* TIMERL */
  {0x00000000, 0x00000000, 0x00000000, 0x00000000,   IMPL,   SUP}, /* TIMERD */

  /* spr registers 1955-2047 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DCR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* BRR */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* NMAR */

  {0x00000000, 0x00000000, 0x00000000, 0x00000ffe,   IMPL,   SUP}, /* BTBR */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* IBAR3 */

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR0 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBAR2 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR02 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBDR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* spr registers 2066-2075 are reserved */
  RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR00 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* spr registers 2078 and 2079 are reserved */
  RESERVED, RESERVED,

  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP}, /* DBMR10 */
  {0x00000000, 0x00000000, 0x00000000, 0xffffffff,   IMPL,   SUP},

  /* spr registers 2082-4095 are reserved */
  RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED, RESERVED, RESERVED, RESERVED, RESERVED,
  RESERVED,
};

/* Initialize register control for this cpu */
void
frv_register_control_init (SIM_CPU *cpu)
{
  FRV_REGISTER_CONTROL *control = CPU_REGISTER_CONTROL (cpu);
  SIM_DESC sd = CPU_STATE (cpu);
  int mach = STATE_ARCHITECTURE (sd)->mach;

  if (sizeof (fr400_spr) != FRV_MAX_SPR * sizeof (*fr400_spr))
    abort ();
  if (sizeof (fr450_spr) != FRV_MAX_SPR * sizeof (*fr450_spr))
    abort ();
  if (sizeof (fr500_spr) != FRV_MAX_SPR * sizeof (*fr500_spr))
    abort ();
  if (sizeof (fr550_spr) != FRV_MAX_SPR * sizeof (*fr550_spr))
    abort ();
  if (sizeof (frv_spr) != FRV_MAX_SPR * sizeof (*frv_spr))
    abort ();

  switch (mach)
    {
    case bfd_mach_frvtomcat:
    case bfd_mach_fr500:
      control->fr = 1;
      control->cpr = 0;
      control->spr = fr500_spr;
      return;
    case bfd_mach_fr550:
      control->fr = 1;
      control->cpr = 0;
      control->spr = fr550_spr;
      return;
    case bfd_mach_fr450:
      control->fr = 1;
      control->cpr = 0;
      control->spr = fr450_spr;
      return;
    case bfd_mach_fr400:
      control->fr = 1;
      control->cpr = 0;
      control->spr = fr400_spr;
      return;
    case bfd_mach_frvsimple:
      control->fr = 0;
      control->cpr = 0;
      control->spr = fr500_spr; /* Use the same spr configuration as fr500.  */
      return;
    case bfd_mach_frv:
      control->fr = 1;
      control->cpr = 1;
      control->spr = frv_spr;
      return;
    }

  {      
    IADDR pc = CPU_PC_GET (cpu);
    sim_engine_abort (sd, cpu, pc,
		      "Register control not defined for bfd machine %d\n",
		      mach);
  }
}

/* Initialize spr registers.  Used during startup and during hardware reset.  */
void
frv_initialize_spr (SIM_CPU *current_cpu)
{
  FRV_REGISTER_CONTROL *control = CPU_REGISTER_CONTROL (current_cpu);
  FRV_SPR_CONTROL_INFO *spr_control;
  USI save_mask;
  int i;

  /* Make sure that PSR.S is set in order to avoid access problems.
     Set the hardware directly to avoid user/supervisor state change. */
  CPU (h_psr_s) = 1;

  /* Now initialize each register except PSR.  */
  for (i = 0; i < FRV_MAX_SPR; ++i)
    {
      /* Make sure that the register is implemented and is not PSR.  */
      spr_control = & control->spr[i];
      if (spr_control->implemented && i != H_SPR_PSR)
	{
	  /* Temporarily disable the read-only mask for this register in order
	     to initialize read-only fields.  */
	  save_mask = spr_control->read_only_mask;
	  spr_control->read_only_mask = 0;
	  SET_H_SPR (i, spr_control->init_value);
	  spr_control->read_only_mask = save_mask;
	}
    }

  /* Now explicitely set PSR in order to get the correct setting for PSR.S.  */
  spr_control = & control->spr[H_SPR_PSR];
  save_mask = spr_control->read_only_mask;
  spr_control->read_only_mask = 0;
  SET_H_SPR (H_SPR_PSR, spr_control->init_value);
  spr_control->read_only_mask = save_mask;
}

/* Reset spr registers.  Used during software reset.  */
void
frv_reset_spr (SIM_CPU *current_cpu)
{
  FRV_REGISTER_CONTROL *control = CPU_REGISTER_CONTROL (current_cpu);
  FRV_SPR_CONTROL_INFO *spr_control;
  USI mask;
  USI new_val;
  int i;
  int psr_s;

  /* Save PSR.S so that it can be stored in PSR.PS when initialization is
     complete.  */
  psr_s = GET_H_PSR_S ();

  /* Make sure that PSR.S is set in order to avoid access problems.
     Set the hardware directly to avoid user/supervisor state change. */
  CPU (h_psr_s) = 1;

  /* Now reset each register except PSR.  */
  for (i = 0; i < FRV_MAX_SPR; ++i)
    {
      /* Make sure that the register is implemented and is not PSR.  */
      spr_control = & control->spr[i];
      if (spr_control->implemented && i != H_SPR_PSR)
	{
	  mask = spr_control->reset_mask;
	  new_val = GET_H_SPR (i) & ~mask;
	  new_val |= spr_control->reset_value & mask;
	  SET_H_SPR (i, new_val);
	}
    }

  /* Now explicitely set PSR in order to get the correct setting for PSR.S.  */
  spr_control = & control->spr[H_SPR_PSR];
  mask = spr_control->reset_mask;
  new_val = GET_H_SPR (H_SPR_PSR) & ~mask;
  new_val |= spr_control->reset_value & mask;
  SET_H_SPR (H_SPR_PSR, new_val);

  /* Now set PSR.PS with the previous value of PSR.S.  */
  SET_H_PSR_PS (psr_s);
}

/* Check access to spr registers.  */
void
frv_check_spr_read_access (SIM_CPU *current_cpu, UINT spr)
{
  FRV_REGISTER_CONTROL *control = CPU_REGISTER_CONTROL (current_cpu);

  if (! control->spr[spr].implemented)
    {
      SIM_DESC sd = CPU_STATE (current_cpu);
      switch (STATE_ARCHITECTURE (sd)->mach)
	{
	case bfd_mach_fr400:
	case bfd_mach_fr450:
	  /* On the fr4xx series: if this is an unimplemented accumulator,
	     then generate an illegal_instruction_interrupt, otherwise no
	     interrupt.  */
	  if (SPR_IS_ACC (spr))
	    frv_queue_program_interrupt (current_cpu, FRV_ILLEGAL_INSTRUCTION);
	  break;
	case bfd_mach_fr550:
	  /* No interrupt on the fr550 */
	  break;
	default:
	  frv_queue_register_exception_interrupt (current_cpu, FRV_REC_UNIMPLEMENTED);
	  break;
	}
    }
}

void
frv_check_spr_write_access (SIM_CPU *current_cpu, UINT spr)
{
  /* Both a register exception (unimplemented) and a privileged insn exception
     are possible. Check for both and the let the priority be resolved by the
     exception handling code.  */
  FRV_REGISTER_CONTROL *control = CPU_REGISTER_CONTROL (current_cpu);

  /* Write access check is a superset of the read access check.  */
  frv_check_spr_read_access (current_cpu, spr);

  /* Check for write to supervisor register.  */
  if (control->spr[spr].supervisor && ! GET_H_PSR_S ())
    frv_queue_program_interrupt (current_cpu, FRV_PRIVILEGED_INSTRUCTION);
}

void
frv_fr_registers_available (
  SIM_CPU *current_cpu, int *hi_available, int *lo_available
)
{
  int all_implemented;
  SI hsr0 = GET_HSR0 ();

  /* If ! all_implemented, then registers 0-32 are available, otherwise check
     availability of the hi/lo banks by checking the HSR0 register.  */
  all_implemented = ! GET_HSR0_FRN (hsr0);
  *hi_available = all_implemented && GET_HSR0_FRHE (hsr0);
  *lo_available = (! all_implemented) || GET_HSR0_FRLE (hsr0);
}

void
frv_gr_registers_available (
  SIM_CPU *current_cpu, int *hi_available, int *lo_available
)
{
  int all_implemented;
  SI hsr0 = GET_HSR0 ();

  /* If ! all_implemented, then registers 0-32 are available, otherwise check
     availability of the hi/lo banks by checking the HSR0 register.  */
  all_implemented = ! GET_HSR0_GRN (hsr0);
  *hi_available = all_implemented && GET_HSR0_GRHE (hsr0);
  *lo_available = (! all_implemented) || GET_HSR0_GRLE (hsr0);
}

/* Return 1 if the given register is available, 0 otherwise.  TARGET_INDEX==-1
   means to check for any register available.  */
int
frv_check_register_access (
  SIM_CPU *current_cpu,
  SI target_index,
  int hi_available,
  int lo_available
)
{
  SIM_DESC sd;
  if (target_index > 31)
    {
      if (hi_available)
	return 1;
    }
  else
    {
      if (lo_available)
	return 1;

      if (target_index == -1 && hi_available)
	return 1;
    }

  /* The register is not available. Generate an exception.  */
  sd = CPU_STATE (current_cpu);
  switch (STATE_ARCHITECTURE (sd)->mach)
    {
    case bfd_mach_fr400:
    case bfd_mach_fr450:
    case bfd_mach_fr550:
      /* On some machines this generates an illegal_instruction interrupt.  */
      frv_queue_program_interrupt (current_cpu, FRV_ILLEGAL_INSTRUCTION);
      break;
    default:
      /* On other machines, it's a register_exception.  */
      frv_queue_register_exception_interrupt (current_cpu, FRV_REC_UNIMPLEMENTED);
      break;
    }
  return 0;
}

/* Return 1 if the given register is available, 0 otherwise.  TARGET_INDEX==-1
   means to check for any register available.  */
int
frv_check_gr_access (SIM_CPU *current_cpu, SI target_index)
{
  int hi_available;
  int lo_available;

  frv_gr_registers_available (current_cpu, & hi_available, & lo_available);
  return frv_check_register_access (current_cpu, target_index,
				    hi_available, lo_available);
}

/* Return 1 if the given register is available, 0 otherwise.  TARGET_INDEX==-1
   means to check for any register available.  */
int
frv_check_fr_access (SIM_CPU *current_cpu, SI target_index)
{
  int hi_available;
  int lo_available;

  frv_fr_registers_available (current_cpu, & hi_available, & lo_available);
  return frv_check_register_access (current_cpu, target_index,
				    hi_available, lo_available);
}
