


CLISP(1)                                                 CLISP(1)


NNAAMMEE
       clisp - Common Lisp language interpreter and compiler

SSYYNNOOPPSSIISS
       cclliisspp [ --hh ] [ --mm _m_e_m_s_i_z_e ] [ --MM _m_e_m_f_i_l_e ] [ --LL _l_a_n_g_u_a_g_e ]
       [ --NN _d_i_r_e_c_t_o_r_y ] [ --qq ] [ --II ] [ --ii _i_n_i_t_f_i_l_e ...  ] [ --cc [
       --ll  ] _l_i_s_p_f_i_l_e [ --oo _o_u_t_p_u_t_f_i_l_e ] ...  ] [ --pp _p_a_c_k_a_g_e_n_a_m_e ]
       [ --xx _e_x_p_r_e_s_s_i_o_n ]

DDEESSCCRRIIPPTTIIOONN
       Invokes the common lisp interpreter and compiler.  Invoked
       without  arguments,  executes  a  read-eval-print loop, in
       which expressions are in turn read  from  standard  input,
       evaluated  by the lisp interpreter, and their results out-
       put to standard output.  Invoked with  --cc,  the  specified
       lisp files are compiled to a bytecode that can be executed
       more efficiently.

OOPPTTIIOONNSS
       --hh     Displays a help message on how to use cclliisspp.

       --mm _m_e_m_s_i_z_e
              Sets the amount of memory cclliisspp tries  to  grab  on
              startup.   The amount may be given as _n_n_n_n_n_n_n (mea-
              sured in bytes), _n_n_n_nKK or _n_n_n_nKKBB (measured in kilo-
              bytes)  or  _nMM  or  _nMMBB  (measured  in  megabytes).
              Default is  2  megabytes.   The  argument  is  con-
              strained between 100 KB and 16 MB.  -- This version
              of cclliisspp allocates memory dynamically.  _m_e_m_s_i_z_e  is
              essentially ignored.

       --MM _m_e_m_f_i_l_e
              Specifies the initial memory image.  This must be a
              memory dump produced by the _s_a_v_e_i_n_i_t_m_e_m function.

       --LL _l_a_n_g_u_a_g_e
              Specifies the language cclliisspp  uses  to  communicate
              with  the user. This may be eenngglliisshh, ddeeuuttsscchh, ffrraann--
              ccaaiiss.

       --NN _d_i_r_e_c_t_o_r_y
              Specifies where the locale  message  files  may  be
              found.

       --qq     Quiet:  cclliisspp  displays no banner at startup and no
              good-bye message when quitting.

       --II     ILISP friendly: cclliisspp interacts in a way that ILISP
              (a  popular  Emacs  LISP  interface) can deal with.
              Currently the only effect of this is that  unneces-
              sary prompts are not suppressed.

       --ii _i_n_i_t_f_i_l_e _._._.
              Specifies  initialization  files  to  be  _l_o_a_ded at



                           15 June 1995                         1





CLISP(1)                                                 CLISP(1)


              startup. These should be lisp files (source or com-
              piled).

       --cc _l_i_s_p_f_i_l_e _._._.
              Compiles  the  specified _l_i_s_p_f_i_l_es to bytecode. The
              compiled files can then be _l_o_a_ded  instead  of  the
              sources to gain efficiency.

       --oo _o_u_t_p_u_t_f_i_l_e
              Specifies the output file or directory for the com-
              pilation of the last specified _l_i_s_p_f_i_l_e.

       --ll     A bytecode listing of the files being compiled will
              be produced.  Useful only for debugging purposes.

       --pp _p_a_c_k_a_g_e_n_a_m_e
              At startup the value of the variable _*_p_a_c_k_a_g_e_* will
              be set to the package named _p_a_c_k_a_g_e_n_a_m_e.

       --xx _e_x_p_r_e_s_s_i_o_n_s
              Executes a series of arbitrary expressions  instead
              of  a  read-eval-print  loop.   The  values  of the
              expressions will be output to standard output.  Due
              to  the  argument processing done by the shell, the
              _e_x_p_r_e_s_s_i_o_n_s must be enclosed in single quotes,  and
              double  quotes  and backslashes must be preceded by
              backslashes.

       @@_o_p_t_i_o_n_f_i_l_e
              substitutes the contents  of  _o_p_t_i_o_n_f_i_l_e  as  argu-
              ments. Each line of _o_p_t_i_o_n_f_i_l_e is treated as a sep-
              arate argument to cclliisspp.


RREEFFEERREENNCCEE
       The language implemented conforms to
              Guy L. Steele Jr.: Common Lisp - The Language.
              Digital Press. 1st edition 1984, 465 pages.
              ("CLtL1" for short)
       and to the older parts of
              Guy L. Steele Jr.: Common Lisp - The Language.
              Digital Press. 2nd edition 1990, 1032 pages.
              ("CLtL2" for short)

UUSSEE
       hheellpp   to get some on-line help.

       ((aapprrooppooss _n_a_m_e))
              lists the symbols relating to _n_a_m_e.

       ((eexxiitt)) or ((qquuiitt)) or ((bbyyee))
              to quit cclliisspp.





                           15 June 1995                         2





CLISP(1)                                                 CLISP(1)


       EOF (Ctrl-Z)
              to leave the current read-eval-print loop.

       arrow keys
              for editing and viewing the input history.

       Tab key
              to complete the symbol's name you are just  typing.

FFIILLEESS
       _l_i_s_p_._e_x_e
              main executable

       _l_i_s_p_i_n_i_t_._m_e_m
              initial memory image

       _c_o_n_f_i_g_._l_s_p
              site-dependent configuration

       _*_._l_s_p  lisp source

       _*_._f_a_s  lisp code, compiled by cclliisspp

       _*_._l_i_b  lisp source library information, generated and used
              by the cclliisspp compiler

       _*_._c    C code, compiled from lisp source by cclliisspp

EENNVVIIRROONNMMEENNTT
       CCLLIISSPP__LLAANNGGUUAAGGEE
              specifies the language cclliisspp  uses  to  communicate
              with  the  user. The value may be eenngglliisshh, ddeeuuttsscchh,
              ffrraannccaaiiss and defaults to eenngglliisshh.   The  --LL  option
              can  be used to override this environment variable.

       LLAANNGG   specifies the language cclliisspp  uses  to  communicate
              with  the  user,  unless  it  is  already specified
              through the environment variable CCLLIISSPP__LLAANNGGUUAAGGEE  or
              the  --LL option. The value may begin with a two-let-
              ter ISO 639 language code, for example eenn, ddee,  ffrr.

       CCOOMMSSPPEECC (DOS, OS/2 implementations only)
              is  used  to find the command interpreter called by
              the function _s_h_e_l_l.

       TTEERRMM   specifies the terminal emulation cclliisspp  relies  on.
              If  you  have  ANSI.SYS loaded, possible values are
              _a_n_s_i, _a_n_s_i_-_c_o_l_o_r_-_2, _a_n_s_i_-_c_o_l_o_r_-_3 and _m_o_n_o.

       TTEERRMMCCAAPP
              should be set to the slashified file  name  of  the
              terminal capabilities database _t_e_r_m_c_a_p_._d_a_t.





                           15 June 1995                         3





CLISP(1)                                                 CLISP(1)


SSEEEE AALLSSOO
       _c_m_u_l_i_s_p(1), _e_m_a_c_s(1).

BBUUGGSS
       The function _i_n_s_p_e_c_t is not implemented.

       The memory management scheme is not very flexible.

       Not all extensions from CLtL2 are supported.

       No  on-line  documentation  beyond _a_p_r_o_p_o_s and _d_e_s_c_r_i_b_e is
       available.

       Stack overflow aborts the  program  ungracefully,  with  a
       register dump.

       Pressing Control-C may not interrupt cclliisspp in every situa-
       tion.

       Calling the function _e_x_e_c_u_t_e on batch  files  crashes  the
       machine.

PPRROOJJEECCTTSS
       Writing on-line documentation.

       Write _i_n_s_p_e_c_t.

       Enhance  the  compiler such that it can inline local func-
       tions.

       Specify a portable set of window and graphics  operations.

AAUUTTHHOORRSS
       Bruno   Haible  <haible@ma2s2.mathematik.uni-karlsruhe.de>
       and Michael Stoll.






















                           15 June 1995                         4


