/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.expandbarkit.ExpandBarThemeAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 24;
    static final int INTERNAL_SPACING = 4;
    static final int CHEVRON_SIZE = 24;
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, style, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.parent.destroyItem(this);
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
            super.dispose();
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int headerHeight = Math.max(this.parent.getBandHeight(), this.imageHeight);
        return headerHeight += this.getItemHeaderBorderWidth();
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        int result = 0;
        if (!this.isDisposed()) {
            Image image = this.getImage();
            int w = image == null ? 0 : image.getBounds().width;
            String text = this.getText();
            if (text != null) {
                if (w > 0) {
                    w += 4;
                }
                Font parentFont = this.getParent().getFont();
                w += TextSizeUtil.stringExtent((Font)parentFont, (String)text).x;
            }
            result = w + 4 + 24;
        }
        return result;
    }

    Rectangle getBounds() {
        Rectangle result = this.expanded ? new Rectangle(this.x, this.y, this.width, this.getHeaderHeight() + this.height) : new Rectangle(this.x, this.y, this.width, this.getHeaderHeight());
        return result;
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        int headerHeight = this.getHeaderHeight();
        int aX = x;
        int aY = y;
        int aWidth = width;
        int aHeight = height;
        if (move) {
            if (this.imageHeight > headerHeight) {
                aY += this.imageHeight - headerHeight;
            }
            this.x = aX;
            this.y = aY;
        }
        if (size) {
            this.width = aWidth;
            this.height = aHeight;
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (!this.parent.isAppThemed()) {
                int border = this.getItemBorderWidth();
                aX += border;
                aWidth = Math.max(0, aWidth - border * 2);
                aHeight = Math.max(0, aHeight - border);
            }
            if (move && size) {
                this.control.setBounds(aX, aY + headerHeight, aWidth, aHeight);
            }
            if (move && !size) {
                this.control.setLocation(aX, aY + headerHeight);
            }
            if (!move && size) {
                this.control.setSize(aWidth, aHeight);
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int headerHeight = this.getHeaderHeight();
            control.setVisible(this.expanded);
            if (!this.parent.isAppThemed()) {
                int border = this.getItemBorderWidth();
                int width = Math.max(0, this.width - border * 2);
                int height = Math.max(0, this.height - border);
                control.setBounds(this.x + border, this.y + headerHeight, width, height);
            } else {
                control.setBounds(this.x, this.y + headerHeight, this.width, this.height);
            }
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        this.parent.showItem(this);
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height >= 0) {
            this.setBounds(0, 0, this.width, height, false, true);
            if (this.expanded) {
                this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.getImage()) {
            super.setImage(image);
            this.updateBounds();
        }
        int oldImageHeight = this.imageHeight;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            this.imageHeight = bounds.height;
            this.imageWidth = bounds.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (oldImageHeight != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (!string.equals(this.getText())) {
            super.setText(string);
            this.updateBounds();
        }
    }

    private void updateBounds() {
        int parentWidth = this.parent.computeSize((int)-1, (int)-1, (boolean)false).x;
        int scrollBarWidth = this.parent.getVScrollBarWidth();
        int availableWidth = parentWidth - 2 * this.parent.spacing - scrollBarWidth;
        this.width = Math.max(this.getPreferredWidth(), availableWidth);
        this.setBounds(0, 0, this.width, this.height, false, true);
    }

    int getItemBorderWidth() {
        ExpandBarThemeAdapter themeAdapter = (ExpandBarThemeAdapter)this.parent.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemBorderWidth(this.parent);
    }

    int getItemHeaderBorderWidth() {
        ExpandBarThemeAdapter themeAdapter = (ExpandBarThemeAdapter)this.parent.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemHeaderBorderWidth(this.parent);
    }
}

