/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.helper.Helper;

public class CodeGenerator {
    protected Writer output = new StringWriter();
    protected ClassDefinition currentClass;
    protected boolean useUnicode = true;

    public CodeGenerator() {
    }

    public CodeGenerator(boolean useUnicode) {
        this();
        this.useUnicode = useUnicode;
    }

    public void cr() {
        this.write(Helper.cr());
    }

    public ClassDefinition getCurrentClass() {
        return this.currentClass;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void setCurrentClass(ClassDefinition currentClass) {
        this.currentClass = currentClass;
    }

    public void setOutput(Writer output) {
        this.output = output;
    }

    public void tab() {
        this.write("\t");
    }

    public void tab(int indent) {
        int index = 0;
        while (index < indent) {
            this.tab();
            ++index;
        }
    }

    public String toString() {
        return this.getOutput().toString();
    }

    public void write(Object value) {
        try {
            if (!this.useUnicode) {
                this.getOutput().write(String.valueOf(value));
            } else {
                String test = String.valueOf(value);
                StringBuffer escapedStr = new StringBuffer(test.length() * 4);
                int i = 0;
                while (i < test.length()) {
                    char c = test.charAt(i);
                    if (c < '\u007f') {
                        escapedStr.append(c);
                    } else {
                        String escapedChar = Long.toHexString(c).toUpperCase();
                        switch (escapedChar.length()) {
                            case 1: {
                                escapedStr.append("\\u000" + escapedChar);
                                break;
                            }
                            case 2: {
                                escapedStr.append("\\u00" + escapedChar);
                                break;
                            }
                            case 3: {
                                escapedStr.append("\\u0" + escapedChar);
                                break;
                            }
                            default: {
                                escapedStr.append("\\u" + escapedChar);
                            }
                        }
                    }
                    ++i;
                }
                this.getOutput().write(escapedStr.toString());
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void writeln(Object value) {
        this.write(value);
        this.cr();
    }

    public void writeType(String typeName) {
        int index;
        String localTypeName = typeName;
        if (this.getCurrentClass() != null && (index = typeName.lastIndexOf(46)) != -1) {
            String packageName = typeName.substring(index);
            if (this.getCurrentClass().getImports().contains(packageName)) {
                localTypeName = typeName.substring(index, typeName.length());
            }
        }
        this.write(localTypeName);
    }
}

