/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.Interceptor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.xml.WebBeansErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WebBeansXMLConfigurator {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansXMLConfigurator.class);
    private String currentScanFileName = null;

    public void configure(InputStream xmlStream) {
        try {
            if (xmlStream.available() > 0) {
                this.configureSpecSpecific(xmlStream, "No-name XML Stream");
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    public void configure(InputStream xmlStream, String fileName) {
        this.configure(xmlStream, fileName, null);
    }

    public void configure(InputStream xmlStream, String fileName, ScannerService scanner) {
        try {
            if (xmlStream.available() > 0) {
                this.configureSpecSpecific(xmlStream, fileName, scanner);
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    public void configureSpecSpecific(InputStream xmlStream, String fileName) {
        this.configureSpecSpecific(xmlStream, fileName, null);
    }

    public void configureSpecSpecific(InputStream xmlStream, String fileName, ScannerService scanner) {
        try {
            if (xmlStream.available() > 0) {
                Asserts.assertNotNull(xmlStream, "xmlStream parameter can not be null!");
                Asserts.assertNotNull(fileName, "fileName parameter can not be null!");
                this.currentScanFileName = fileName;
                Element webBeansRoot = this.getSpecStrictRootElement(xmlStream);
                this.configureSpecSpecific(webBeansRoot, fileName, scanner);
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    private Element getSpecStrictRootElement(InputStream stream) throws WebBeansException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new WebBeansErrorHandler());
            Element root = documentBuilder.parse(stream).getDocumentElement();
            return root;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "FATAL_0002", e);
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString("EXCEPT_0013"), e);
        }
    }

    private String getName(Element element) {
        Asserts.assertNotNull(element, "element argument can not be null");
        return element.getLocalName();
    }

    private void configureSpecSpecific(Element webBeansRoot, String fileName, ScannerService scanner) {
        NodeList ns = webBeansRoot.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (this.getName(child).equals("interceptors")) {
                this.configureInterceptorsElement(child, fileName, scanner);
                continue;
            }
            if (this.getName(child).equals("decorators")) {
                this.configureDecoratorsElement(child, fileName, scanner);
                continue;
            }
            if (!this.getName(child).equals("alternatives")) continue;
            this.configureAlternativesElement(child, fileName, scanner);
        }
    }

    private void configureInterceptorsElement(Element interceptorsElement, String fileName, ScannerService scanner) {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        InterceptorsManager manager = webBeansContext.getInterceptorsManager();
        HashSet interceptorsInFile = new HashSet();
        NodeList ns = interceptorsElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            boolean isBDAScanningEnabled;
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> clazz = null;
            clazz = ClassUtil.getClassFromName(child.getTextContent().trim());
            if (clazz == null) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + child.getTextContent().trim() + " not found");
            }
            Object annotatedType = webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
            GProcessAnnotatedType processAnnotatedEvent = webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
            if (processAnnotatedEvent.isVeto()) {
                return;
            }
            annotatedType = processAnnotatedEvent.getAnnotatedType();
            Set annTypeAnnotations = annotatedType.getAnnotations();
            Annotation[] classAnnotations = annTypeAnnotations != null ? annTypeAnnotations.toArray(new Annotation[annTypeAnnotations.size()]) : new Annotation[]{};
            if (AnnotationUtil.hasAnnotation(classAnnotations, Interceptor.class) && !webBeansContext.getAnnotationManager().hasInterceptorBindingMetaAnnotation(classAnnotations)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + child.getTextContent().trim() + " must have at least one @InterceptorBinding");
            }
            if (interceptorsInFile.contains(clazz)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + child.getTextContent().trim() + " already defined in this beans.xml file!");
            }
            interceptorsInFile.add(clazz);
            boolean bl = isBDAScanningEnabled = scanner != null && scanner.isBDABeansXmlScanningEnabled();
            if (!isBDAScanningEnabled && manager.isInterceptorEnabled(clazz) || isBDAScanningEnabled && !scanner.getBDABeansXmlScanner().addInterceptor(clazz, fileName)) {
                logger.warning("Interceptor class : " + child.getTextContent().trim() + " is already defined");
                continue;
            }
            manager.addNewInterceptor(clazz);
        }
    }

    private void configureDecoratorsElement(Element decoratorsElement, String fileName, ScannerService scanner) {
        DecoratorsManager manager = WebBeansContext.getInstance().getDecoratorsManager();
        NodeList ns = decoratorsElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            boolean isBDAScanningEnabled;
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> clazz = null;
            clazz = ClassUtil.getClassFromName(child.getTextContent().trim());
            if (clazz == null) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Decorator class : " + child.getTextContent().trim() + " not found");
            }
            boolean bl = isBDAScanningEnabled = scanner != null && scanner.isBDABeansXmlScanningEnabled();
            if (isBDAScanningEnabled && !scanner.getBDABeansXmlScanner().addDecorator(clazz, fileName) || !isBDAScanningEnabled && manager.isDecoratorEnabled(clazz)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Decorator class : " + child.getTextContent().trim() + " is already defined");
            }
            manager.addNewDecorator(clazz);
        }
    }

    private void configureAlternativesElement(Element alternativesElement, String fileName, ScannerService scanner) {
        NodeList ns = alternativesElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (this.getName(child).equals("stereotype") || this.getName(child).equals("Stereotype")) {
                this.addAlternative(child, true, fileName, scanner);
                continue;
            }
            if (this.getName(child).equals("class") || this.getName(child).equals("Class")) {
                this.addAlternative(child, false, fileName, scanner);
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.log(Level.WARNING, "WARN_0002", this.getName(child));
        }
    }

    private void addAlternative(Element child, boolean isStereoType, String fileName, ScannerService scanner) {
        Class<?> clazz = null;
        clazz = ClassUtil.getClassFromName(child.getTextContent().trim());
        if (clazz == null) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Alternative class : " + this.getName(child) + " not found");
        }
        AlternativesManager manager = WebBeansContext.getInstance().getAlternativesManager();
        if (isStereoType) {
            manager.addStereoTypeAlternative(clazz, fileName, scanner);
        } else {
            manager.addClazzAlternative(clazz, fileName, scanner);
        }
    }

    private String createConfigurationFailedMessage() {
        return "WebBeans XML configuration defined in " + this.currentScanFileName + " is failed. Reason is : ";
    }
}

