/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.Nonbinding;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtil {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private AnnotationUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasMethodAnnotation(Method method, Class<? extends Annotation> clazz) {
        Annotation[] anns;
        Method element = method;
        for (Annotation annotation : anns = AnnotationUtil.getDeclaredAnnotations(element)) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        try {
            return element.getDeclaredAnnotations();
        }
        catch (LinkageError e) {
            return element.getDeclaredAnnotations();
        }
    }

    public static boolean hasMethodParameterAnnotation(Method method, Class<? extends Annotation> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static <X> boolean hasAnnotatedMethodParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Type[] getMethodParameterGenericTypesWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Type> list = new ArrayList<Type>();
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type[] genericTypes = method.getGenericParameterTypes();
        int i = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                list.add(genericTypes[i]);
                break;
            }
            ++i;
        }
        Type[] result = new Type[list.size()];
        result = list.toArray(result);
        return result;
    }

    public static Type[] getConstructorParameterGenericTypesWithGivenAnnotation(Constructor<?> constructor, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(constructor, "constructor argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Type> list = new ArrayList<Type>();
        Annotation[][] parameterAnns = constructor.getParameterAnnotations();
        Type[] genericTypes = constructor.getGenericParameterTypes();
        int i = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                list.add(genericTypes[i]);
                break;
            }
            ++i;
        }
        Type[] result = new Type[list.size()];
        result = list.toArray(result);
        return result;
    }

    public static boolean hasMethodMultipleParameterAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        boolean found = false;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                if (!param.annotationType().equals(clazz)) continue;
                if (!found) {
                    found = true;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public static <X> boolean hasAnnotatedMethodMultipleParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        boolean found = false;
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public static Type getMethodFirstParameterWithAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type[] params = method.getGenericParameterTypes();
        int index = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return params[index];
            }
            ++index;
        }
        return null;
    }

    public static <X> Type getAnnotatedMethodFirstParameterWithAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return parameter.getBaseType();
        }
        return null;
    }

    @Deprecated
    public static <X> Annotation[] getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        return WebBeansContext.getInstance().getAnnotationManager().getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, clazz);
    }

    public static Class<?> getMethodFirstParameterTypeClazzWithAnnotation(Method method, Class<? extends Annotation> clazz) {
        Type type = AnnotationUtil.getMethodFirstParameterWithAnnotation(method, clazz);
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    @Deprecated
    public static Annotation[] getMethodFirstParameterQualifierWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        return WebBeansContext.getInstance().getAnnotationManager().getMethodFirstParameterQualifierWithGivenAnnotation(method, clazz);
    }

    public static Type getTypeOfParameterWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type result = null;
        int index = 0;
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                found = true;
                break;
            }
            if (found) {
                result = method.getGenericParameterTypes()[index];
                break;
            }
            ++index;
        }
        return result;
    }

    public static <T extends Annotation> T getMethodFirstParameterAnnotation(Method method, Class<T> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return (T)((Annotation)clazz.cast(param));
            }
        }
        return null;
    }

    public static <X, T extends Annotation> T getAnnotatedMethodFirstParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<T> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return (T)((Annotation)clazz.cast(parameter.getAnnotation(clazz)));
        }
        return null;
    }

    public static boolean hasMethodParameterAnnotationCrossRef(Method method, Class<? extends Annotation> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Annotation[] btype;
                for (Annotation b : btype = AnnotationUtil.getDeclaredAnnotations(param.annotationType())) {
                    if (!b.annotationType().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isQualifierEqual(Annotation qualifier1, Annotation qualifier2) {
        Asserts.assertNotNull(qualifier1, "qualifier1 argument can not be null");
        Asserts.assertNotNull(qualifier2, "qualifier2 argument can not be null");
        Class<? extends Annotation> qualifier1AnnotationType = qualifier1.annotationType();
        if (qualifier1AnnotationType == null || !qualifier1AnnotationType.equals(qualifier2.annotationType())) {
            return false;
        }
        List<Method> bindingQualifierMethods = AnnotationUtil.getBindingQualifierMethods(qualifier1AnnotationType);
        for (Method method : bindingQualifierMethods) {
            Object value2;
            Object value1 = AnnotationUtil.callMethod(qualifier1, method);
            if (AnnotationUtil.checkEquality(value1, value2 = AnnotationUtil.callMethod(qualifier2, method))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEquality(Object value1, Object value2) {
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        Class<?> valueClass = value1.getClass();
        if (!valueClass.equals(value2.getClass())) {
            return false;
        }
        if (valueClass.isPrimitive()) {
            return value1 == value2;
        }
        if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            if (arrayType.isPrimitive()) {
                if (Long.TYPE == arrayType) {
                    return Arrays.equals((long[])value1, (long[])value2);
                }
                if (Integer.TYPE == arrayType) {
                    return Arrays.equals((int[])value1, (int[])value2);
                }
                if (Short.TYPE == arrayType) {
                    return Arrays.equals((short[])value1, (short[])value2);
                }
                if (Double.TYPE == arrayType) {
                    return Arrays.equals((double[])value1, (double[])value2);
                }
                if (Float.TYPE == arrayType) {
                    return Arrays.equals((float[])value1, (float[])value2);
                }
                if (Boolean.TYPE == arrayType) {
                    return Arrays.equals((boolean[])value1, (boolean[])value2);
                }
                if (Byte.TYPE == arrayType) {
                    return Arrays.equals((byte[])value1, (byte[])value2);
                }
                if (Character.TYPE == arrayType) {
                    return Arrays.equals((char[])value1, (char[])value2);
                }
                return false;
            }
            return Arrays.equals((Object[])value1, (Object[])value2);
        }
        return value1.equals(value2);
    }

    private static Object callMethod(Object instance, Method method) {
        try {
            if (!method.isAccessible()) {
                AnnotationUtil.doPrivilegedSetAccessible(method, true);
            }
            return method.invoke(instance, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new WebBeansException("Exception in method call : " + method.getName(), e);
        }
    }

    private static Object doPrivilegedSetAccessible(AccessibleObject obj, boolean flag) {
        AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(obj, flag));
        return null;
    }

    private static List<Method> getBindingQualifierMethods(Class<? extends Annotation> qualifierAnnotationType) {
        Method[] qualifierMethods = SecurityUtil.doPrivilegedGetDeclaredMethods(qualifierAnnotationType);
        if (qualifierMethods.length > 0) {
            ArrayList<Method> bindingMethods = new ArrayList<Method>();
            for (Method qualifierMethod : qualifierMethods) {
                Annotation[] qualifierMethodAnnotations = AnnotationUtil.getDeclaredAnnotations(qualifierMethod);
                if (qualifierMethodAnnotations.length > 0) {
                    boolean nonbinding = false;
                    for (Annotation qualifierMethodAnnotation : qualifierMethodAnnotations) {
                        if (!Nonbinding.class.equals(qualifierMethodAnnotation.annotationType())) continue;
                        nonbinding = true;
                        break;
                    }
                    if (nonbinding) continue;
                    bindingMethods.add(qualifierMethod);
                    continue;
                }
                bindingMethods.add(qualifierMethod);
            }
            return bindingMethods;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static Annotation[] getQualifierAnnotations(Annotation ... annotations) {
        return WebBeansContext.getInstance().getAnnotationManager().getQualifierAnnotations(annotations);
    }

    public static Method[] getMethodsWithParameterAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        ArrayList<Method> list = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
                if (!AnnotationUtil.hasMethodParameterAnnotation(m, annotation)) continue;
                list.add(m);
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        Method[] rMethod = list.toArray(new Method[list.size()]);
        return rMethod;
    }

    public static boolean hasClassAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        try {
            Annotation a = clazz.getAnnotation(annotation);
            if (a != null) {
                return true;
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasMetaAnnotation(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Annotation[] anns, Class<? extends Annotation> annotation) {
        return AnnotationUtil.getAnnotation(anns, annotation) != null;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] anns, Class<T> annotation) {
        Asserts.assertNotNull(anns, "anns argument can not be null");
        Asserts.assertNotNull(annotation, "annotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().equals(annotation)) continue;
            return (T)annot;
        }
        return null;
    }

    public static Annotation[] getMetaAnnotations(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            annots.add(annot);
        }
        Annotation[] result = new Annotation[annots.size()];
        result = annots.toArray(result);
        return result;
    }

    public static boolean hasAnyQualifier(Bean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Set qualifiers = bean.getQualifiers();
        for (Annotation ann : qualifiers) {
            if (!ann.annotationType().equals(Any.class)) continue;
            return true;
        }
        return false;
    }

    public static Annotation hasOwbInjectableResource(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            for (String name : WebBeansConstants.OWB_INJECTABLE_RESOURCE_ANNOTATIONS) {
                if (!anno.annotationType().getName().equals(name)) continue;
                return anno;
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isInterceptorBindingAnnotation(Class<? extends Annotation> clazz) {
        return WebBeansContext.getInstance().getAnnotationManager().isInterceptorBindingAnnotation(clazz);
    }

    @Deprecated
    public static Annotation[] getInterceptorBindingMetaAnnotations(Annotation[] anns) {
        return WebBeansContext.getInstance().getAnnotationManager().getInterceptorBindingMetaAnnotations(anns);
    }

    @Deprecated
    public static Annotation[] getStereotypeMetaAnnotations(Annotation[] anns) {
        return WebBeansContext.getInstance().getAnnotationManager().getStereotypeMetaAnnotations(anns);
    }

    @Deprecated
    public static boolean hasStereoTypeMetaAnnotation(Annotation[] anns) {
        return WebBeansContext.getInstance().getAnnotationManager().hasStereoTypeMetaAnnotation(anns);
    }

    @Deprecated
    public static boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz) {
        return WebBeansContext.getInstance().getAnnotationManager().isStereoTypeAnnotation(clazz);
    }

    @Deprecated
    public static Annotation[] getRealizesGenericAnnotations(Class<?> clazz, Annotation[] anns) {
        return WebBeansContext.getInstance().getAnnotationManager().getRealizesGenericAnnotations(clazz, anns);
    }

    public static Annotation[] getAnnotationsFromSet(Set<Annotation> set) {
        if (set != null) {
            Annotation[] anns = new Annotation[set.size()];
            anns = set.toArray(anns);
            return anns;
        }
        return new Annotation[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivilegedActionForAccessibleObject
    implements PrivilegedAction<Object> {
        private AccessibleObject object;
        private boolean flag;

        protected PrivilegedActionForAccessibleObject(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }
}

