/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Set;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.commons.EmptyVisitor;

public class TempClassLoader
extends URLClassLoader {
    private final Set<Skip> skip;
    private final ClassLoader system;
    private final boolean embedded;
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(6144);

    public TempClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.skip = SystemInstance.get().getOptions().getAll("openejb.tempclassloader.skip", (Enum[])new Skip[]{Skip.NONE});
        this.system = ClassLoader.getSystemClassLoader();
        this.embedded = this.getClass().getClassLoader() == this.system;
    }

    public void skip(Skip s) {
        this.skip.add(s);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return URLClassLoaderFirst.filterResources(name, super.getResources(name));
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String packageName;
        byte[] bytes;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.skip(name)) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        if (!this.embedded && URLClassLoaderFirst.canBeLoadedFromSystem(name)) {
            try {
                c = this.system.loadClass(name);
                if (c != null) {
                    return c;
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        String resourceName = name.replace('.', '/') + ".class";
        this.bout.reset();
        InputStream in = null;
        try {
            in = this.getResourceAsStream(resourceName);
            if (in != null && !(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            if (in == null) {
                throw new ClassNotFoundException(name);
            }
            IO.copy((InputStream)in, (OutputStream)this.bout);
            bytes = this.bout.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            IO.close((Closeable)in);
        }
        if (this.skip.contains((Object)Skip.ANNOTATIONS) && TempClassLoader.isAnnotationClass(bytes)) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        if (this.skip.contains((Object)Skip.ENUMS) && TempClassLoader.isEnum(bytes)) {
            return Class.forName(name, resolve, this.getClass().getClassLoader());
        }
        int packageEndIndex = name.lastIndexOf(46);
        if (packageEndIndex != -1 && this.getPackage(packageName = name.substring(0, packageEndIndex)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        try {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (SecurityException e) {
            return super.loadClass(name, resolve);
        }
        catch (LinkageError le) {
            return super.loadClass(name, resolve);
        }
    }

    private boolean skip(String name) {
        return this.skip.contains((Object)Skip.ALL) || URLClassLoaderFirst.shouldSkip(name);
    }

    private static boolean isEnum(byte[] bytes) {
        IsEnumVisitor isEnumVisitor = new IsEnumVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isEnumVisitor, 2);
        return isEnumVisitor.isEnum;
    }

    private static boolean isAnnotationClass(byte[] bytes) {
        IsAnnotationVisitor isAnnotationVisitor = new IsAnnotationVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isAnnotationVisitor, 2);
        return isAnnotationVisitor.isAnnotation;
    }

    public static class IsEnumVisitor
    extends EmptyVisitor {
        public boolean isEnum = false;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isEnum = (access & 0x4000) != 0;
        }
    }

    public static class IsAnnotationVisitor
    extends EmptyVisitor {
        public boolean isAnnotation = false;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isAnnotation = (access & 0x2000) != 0;
        }
    }

    public static enum Skip {
        NONE,
        ANNOTATIONS,
        ENUMS,
        ALL;

    }
}

