/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.jpql.AbstractRangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.mappings.DatabaseMapping;

final class RangeDeclaration
extends AbstractRangeDeclaration {
    private List<Join> joinFetches;
    public Class<?> type;

    RangeDeclaration(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    @Override
    void addJoin(Join join) {
        super.addJoin(join);
        if (join.hasFetch()) {
            this.addJoinFetch(join);
        }
    }

    private void addJoinFetch(Join join) {
        if (this.joinFetches == null) {
            this.joinFetches = new LinkedList<Join>();
        }
        this.joinFetches.add(join);
    }

    @Override
    Expression buildQueryExpression() {
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            this.convertUnqualifiedDeclaration();
            return this.queryContext.getBaseExpression();
        }
        return new ExpressionBuilder(descriptor.getJavaClass());
    }

    private void convertUnqualifiedDeclaration() {
        Declaration parentDeclaration = this.queryContext.getParent().getFirstDeclarationImp();
        String outerVariableName = parentDeclaration.getVariableName();
        this.queryContext.getDeclarationResolver().convertUnqualifiedDeclaration(this, outerVariableName);
    }

    List<Join> getJoinFetches() {
        return this.joinFetches == null ? Collections.emptyList() : this.joinFetches;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isFullyQualifiedClassName() {
        return this.type != null;
    }

    public boolean isRange() {
        return true;
    }

    @Override
    ClassDescriptor resolveDescriptor() {
        if (this.type != null) {
            return this.queryContext.getDescriptor(this.type);
        }
        return this.queryContext.getDescriptor(this.rootPath);
    }

    @Override
    DatabaseMapping resolveMapping() {
        return null;
    }
}

