/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFromClause
extends AbstractExpression {
    private AbstractExpression declaration;
    private boolean hasSpace;
    private String identifier;

    protected AbstractFromClause(AbstractExpression parent) {
        super(parent, "FROM");
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDeclaration().accept(visitor);
    }

    @Override
    protected final void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDeclaration());
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("FROM"));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.declaration != null) {
            children.add(this.declaration);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getDeclaration());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public abstract String declarationBNF();

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getDeclaration() {
        if (this.declaration == null) {
            this.declaration = this.buildNullExpression();
        }
        return this.declaration;
    }

    public final boolean hasDeclaration() {
        return this.declaration != null && !this.declaration.isNull();
    }

    public final boolean hasSpaceAfterFrom() {
        return this.hasSpace;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        return wordParser.isArithmeticSymbol(character) || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected final void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("FROM");
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.declaration = this.parse(wordParser, this.declarationBNF(), tolerant);
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return true;
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : "FROM");
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.declaration != null) {
            this.declaration.toParsedText(writer, actual);
        }
    }
}

