/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class CustomCopyPolicyMetadata
extends CopyPolicyMetadata {
    private String copyPolicyClassName;
    private MetadataClass copyPolicyClass;

    public CustomCopyPolicyMetadata() {
        super("<copy-policy");
    }

    public CustomCopyPolicyMetadata(MetadataAnnotation copyPolicy, MetadataAccessor accessor) {
        super(copyPolicy, accessor);
        this.copyPolicyClass = this.getMetadataClass((String)copyPolicy.getAttribute("value"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CustomCopyPolicyMetadata) {
            CustomCopyPolicyMetadata customCopyPoliy = (CustomCopyPolicyMetadata)objectToCompare;
            return this.valuesMatch(this.copyPolicyClassName, customCopyPoliy.getCopyPolicyClassName());
        }
        return false;
    }

    @Override
    public CopyPolicy getCopyPolicy() {
        assert (false);
        return null;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.copyPolicyClass = this.initXMLClassName(this.copyPolicyClassName);
    }

    @Override
    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasCopyPolicy();
        descriptor.getClassDescriptor().setCopyPolicyClassName(this.copyPolicyClass.getName());
    }

    public void setCopyPolicyClassName(String copyPolicyClassName) {
        this.copyPolicyClassName = copyPolicyClassName;
    }
}

