/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.InvocationHandler;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.openejb.util.proxy.QueryProxy;

public class DynamicProxyImplFactory {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, BeanContext.class);

    public static Object newProxy(BeanContext context, java.lang.reflect.InvocationHandler invocationHandler) {
        if (invocationHandler instanceof QueryProxy) {
            EntityManager em;
            String emLookupName = context.getInjections().get(context.getInjections().size() - 1).getJndiName();
            try {
                em = (EntityManager)context.getJndiEnc().lookup(emLookupName);
            }
            catch (NamingException e) {
                throw new RuntimeException("a dynamic bean should reference at least one correct PersistenceContext", e);
            }
            ((QueryProxy)invocationHandler).setEntityManager(em);
        }
        try {
            return ProxyManager.newProxyInstance(context.getLocalInterface(), (InvocationHandler)new Handler(invocationHandler));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("illegal access", e);
        }
    }

    private static class Handler
    implements InvocationHandler {
        private java.lang.reflect.InvocationHandler handler;

        private Handler(java.lang.reflect.InvocationHandler handler) {
            this.handler = handler;
        }

        @Override
        public InvocationHandler getInvocationHandler() {
            return this;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.handler.invoke(proxy, method, args);
        }
    }
}

