/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BundleClassPathURLExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleClassPathURLExtractor.class);
    private static final String JAR_EXTENSION = ".jar";

    BundleClassPathURLExtractor() {
    }

    public static Set<URI> extractBundleClassPathURLs(Bundle bundle) {
        HashSet<URI> results = new HashSet<URI>();
        String bcp = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bcp != null) {
            String[] entries;
            String[] stringArray = entries = bcp.split(",");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (BundleClassPathURLExtractor.isJarEntry(entry)) {
                    URL entryUrl = bundle.getEntry(entry);
                    if (entryUrl != null) {
                        try {
                            URI entryAsJarUrl = new URI("jar", String.valueOf(entryUrl.toString()) + "!/", null);
                            results.add(entryAsJarUrl);
                        }
                        catch (URISyntaxException e) {
                            if (LOGGER.isWarnEnabled()) {
                                LOGGER.warn("Skipping: " + entryUrl, (Throwable)e);
                            }
                        }
                    } else if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Bundle-ClassPath entry '" + entry + "' is not present in bundle " + bundle.getSymbolicName() + " " + bundle.getVersion() + " and has been skipped");
                    }
                }
                ++n2;
            }
        }
        return results;
    }

    private static boolean isJarEntry(String entry) {
        return entry.endsWith(JAR_EXTENSION);
    }
}

