/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTypeConverter
implements TypeConverter {
    private static ConversionService defaultConversionService;
    private final ConversionService conversionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardTypeConverter() {
        StandardTypeConverter standardTypeConverter = this;
        synchronized (standardTypeConverter) {
            if (defaultConversionService == null) {
                defaultConversionService = ConversionServiceFactory.createDefaultConversionService();
            }
        }
        this.conversionService = defaultConversionService;
    }

    public StandardTypeConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    @Override
    public Object convertValue(Object value, TypeDescriptor typeDescriptor) throws EvaluationException {
        try {
            return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), typeDescriptor);
        }
        catch (ConverterNotFoundException cenfe) {
            throw new SpelEvaluationException(cenfe, SpelMessage.TYPE_CONVERSION_ERROR, value != null ? value.getClass() : null, typeDescriptor.asString());
        }
        catch (ConversionException ce) {
            throw new SpelEvaluationException(ce, SpelMessage.TYPE_CONVERSION_ERROR, value != null ? value.getClass() : null, typeDescriptor.asString());
        }
    }
}

