/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.virgo.kernel.artifact.bundle.BundleBridge;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.kernel.userregion.internal.quasi.BundleDescriptionComparator;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.Repository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependencyCalculator {
    private static final String RESOLUTION_STATE_KEY = "resolution.state";
    private static final String REGION_LOCATION_DELIMITER = "@";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResolutionFailureDetective detective;
    private final AtomicLong nextBundleId = new AtomicLong(System.currentTimeMillis());
    private final Repository repository;
    private final Object monitor = new Object();
    private final StateObjectFactory stateObjectFactory;
    private final DumpGenerator dumpGenerator;
    private Region coregion;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public DependencyCalculator(StateObjectFactory stateObjectFactory, ResolutionFailureDetective detective, Repository repository, BundleContext bundleContext) {
        this.repository = repository;
        this.detective = detective;
        this.stateObjectFactory = stateObjectFactory;
        this.dumpGenerator = (DumpGenerator)bundleContext.getService(bundleContext.getServiceReference(DumpGenerator.class));
    }

    public BundleDescription[] calculateDependencies(State state, Region coregion, BundleDescription[] bundles) throws BundleException, UnableToSatisfyDependenciesException {
        this.logger.info("Calculating missing dependencies of bundle(s) '{}'", (Object[])bundles);
        Object object = this.monitor;
        synchronized (object) {
            BundleDescription[] bundleDescriptionArray;
            this.coregion = coregion;
            try {
                BundleDescription[] dependencyDescriptions;
                this.doSatisfyConstraints(bundles, state);
                StateDelta delta = state.resolve(bundles);
                BundleDescription[] bundleDescriptionArray2 = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription description = bundleDescriptionArray2[n2];
                    if (!description.isResolved()) {
                        this.generateDump(state);
                        ResolutionFailureDetective.ResolverErrorsHolder reh = new ResolutionFailureDetective.ResolverErrorsHolder();
                        String failure = this.detective.generateFailureDescription(state, description, reh);
                        ResolverError[] resolverErrors = reh.getResolverErrors();
                        if (resolverErrors != null) {
                            ResolverError[] resolverErrorArray = resolverErrors;
                            int n3 = resolverErrors.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                VersionConstraint unsatisfiedConstraint;
                                ResolverError resolverError = resolverErrorArray[n4];
                                if (resolverError.getType() == 32 && (unsatisfiedConstraint = resolverError.getUnsatisfiedConstraint()) instanceof ImportPackageSpecification) {
                                    ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)unsatisfiedConstraint;
                                    this.logger.debug("Uses conflict: package '{}' version '{}' bundle '{}' version '{}'", new Object[]{importPackageSpecification.getName(), importPackageSpecification.getVersionRange(), importPackageSpecification.getBundleSymbolicName(), importPackageSpecification.getBundleVersionRange()});
                                }
                                ++n4;
                            }
                        }
                        throw new UnableToSatisfyBundleDependenciesException(description.getSymbolicName(), description.getVersion(), failure, state, reh.getResolverErrors());
                    }
                    ++n2;
                }
                BundleDelta[] deltas = delta.getChanges(1, false);
                HashSet<BundleDescription> newBundles = new HashSet<BundleDescription>();
                BundleDelta[] bundleDeltaArray = deltas;
                int reh = deltas.length;
                int n5 = 0;
                while (n5 < reh) {
                    BundleDelta bundleDelta = bundleDeltaArray[n5];
                    newBundles.add(bundleDelta.getBundle());
                    ++n5;
                }
                Set<BundleDescription> dependenciesSet = this.getNewTransitiveDependencies(new HashSet<BundleDescription>(Arrays.asList(bundles)), newBundles);
                ArrayList<BundleDescription> dependencies = new ArrayList<BundleDescription>(dependenciesSet);
                this.logger.info("The dependencies of '{}' are '{}'", (Object)Arrays.toString(bundles), dependencies);
                Collections.sort(dependencies, new BundleDescriptionComparator());
                bundleDescriptionArray = dependencyDescriptions = dependencies.toArray(new BundleDescription[dependencies.size()]);
                this.coregion = null;
            }
            catch (Throwable throwable) {
                this.coregion = null;
                throw throwable;
            }
            return bundleDescriptionArray;
        }
    }

    private Set<BundleDescription> getNewTransitiveDependencies(Set<BundleDescription> dependingBundles, Collection<BundleDescription> newBundles) {
        HashSet<BundleDescription> transitiveDependencies = new HashSet<BundleDescription>();
        while (!dependingBundles.isEmpty()) {
            HashSet<BundleDescription> newDependencies = new HashSet<BundleDescription>();
            for (BundleDescription bundle : dependingBundles) {
                newDependencies.addAll(this.getNewImmediateDependencies(bundle, newBundles));
            }
            newDependencies.removeAll(transitiveDependencies);
            dependingBundles = newDependencies;
            transitiveDependencies.addAll(newDependencies);
        }
        return transitiveDependencies;
    }

    private Set<BundleDescription> getNewImmediateDependencies(BundleDescription bundle, Collection<BundleDescription> newBundles) {
        HashSet<BundleDescription> immediateDependencies = new HashSet<BundleDescription>();
        immediateDependencies.addAll(Arrays.asList(bundle.getFragments()));
        immediateDependencies.addAll(Arrays.asList(bundle.getResolvedRequires()));
        immediateDependencies.addAll(this.getPackageProviders(bundle));
        HostSpecification hostSpecification = bundle.getHost();
        if (hostSpecification != null) {
            BundleDescription[] bundleDescriptionArray = hostSpecification.getHosts();
            int n = bundleDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription host = bundleDescriptionArray[n2];
                immediateDependencies.add(host);
                ++n2;
            }
        }
        immediateDependencies.retainAll(newBundles);
        return immediateDependencies;
    }

    private Set<BundleDescription> getPackageProviders(BundleDescription bundleDescription) {
        ExportPackageDescription[] resolvedImports;
        HashSet<BundleDescription> packageProviders = new HashSet<BundleDescription>();
        ExportPackageDescription[] exportPackageDescriptionArray = resolvedImports = bundleDescription.getResolvedImports();
        int n = resolvedImports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription resolvedImport = exportPackageDescriptionArray[n2];
            packageProviders.add(resolvedImport.getExporter());
            ++n2;
        }
        return packageProviders;
    }

    private void doSatisfyConstraints(BundleDescription description, State state) throws BundleException {
        this.doSatisfyConstraints(new BundleDescription[]{description}, state);
    }

    private void doSatisfyConstraints(BundleDescription[] descriptions, State state) throws BundleException {
        VersionConstraint[] unsatisfiedConstraints = this.findUnsatisfiedConstraints(descriptions, state);
        ArrayList<BundleDescription> constraintsSatisfiers = new ArrayList<BundleDescription>();
        VersionConstraint[] versionConstraintArray = unsatisfiedConstraints;
        int n = unsatisfiedConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            VersionConstraint versionConstraint = versionConstraintArray[n2];
            boolean found = false;
            BundleDescription[] bundleDescriptionArray = descriptions;
            int n3 = descriptions.length;
            int n4 = 0;
            while (n4 < n3) {
                BundleDescription description = bundleDescriptionArray[n4];
                if (description == versionConstraint.getBundle()) {
                    found = true;
                }
                ++n4;
            }
            if (found) {
                if (versionConstraint instanceof ImportPackageSpecification) {
                    this.satisfyImportPackage((ImportPackageSpecification)versionConstraint, state, constraintsSatisfiers);
                } else if (versionConstraint instanceof BundleSpecification) {
                    this.satisfyRequireBundle(versionConstraint, state, constraintsSatisfiers);
                } else if (versionConstraint instanceof HostSpecification) {
                    this.satisfyFragmentHost(versionConstraint, state, constraintsSatisfiers);
                }
            }
            ++n2;
        }
        versionConstraintArray = descriptions;
        n = descriptions.length;
        n2 = 0;
        while (n2 < n) {
            VersionConstraint description = versionConstraintArray[n2];
            this.satisfyFragments((BundleDescription)description, state, constraintsSatisfiers);
            ++n2;
        }
        Collections.sort(constraintsSatisfiers, new BundleDescriptionComparator());
        for (BundleDescription constraintSatisfier : constraintsSatisfiers) {
            if (this.isBundlePresentInState(constraintSatisfier.getName(), constraintSatisfier.getVersion(), state)) continue;
            state.addBundle(constraintSatisfier);
            this.coregion.addBundle(constraintSatisfier.getBundleId());
            this.doSatisfyConstraints(constraintSatisfier, state);
        }
    }

    private void satisfyFragments(BundleDescription description, State state, List<BundleDescription> constraintSatisfiers) throws BundleException {
        Set fragmentArtefacts = this.repository.createQuery("type", "bundle").addFilter("Fragment-Host", description.getSymbolicName()).run();
        for (ArtifactDescriptor fragmentArtefact : fragmentArtefacts) {
            this.addBundle(fragmentArtefact, state, constraintSatisfiers);
        }
    }

    private void satisfyFragmentHost(VersionConstraint constraint, State state, List<BundleDescription> constraintSatisfiers) throws BundleException {
        Set hostArtefacts = this.repository.createQuery("type", "bundle").addFilter("Bundle-SymbolicName", constraint.getName()).run();
        for (ArtifactDescriptor hostArtefact : hostArtefacts) {
            this.addBundle(hostArtefact, state, constraintSatisfiers);
        }
    }

    private void satisfyRequireBundle(VersionConstraint constraint, State state, List<BundleDescription> constraintSatisfiers) throws BundleException {
        Set requiredBundleArtefacts = this.repository.createQuery("type", "bundle").addFilter("Bundle-SymbolicName", constraint.getName()).run();
        for (ArtifactDescriptor requiredBundleArtefact : requiredBundleArtefacts) {
            this.addBundle(requiredBundleArtefact, state, constraintSatisfiers);
        }
    }

    private void satisfyImportPackage(ImportPackageSpecification constraint, State state, List<BundleDescription> constraintSatisfiers) throws BundleException {
        VersionRange packageVersionRange = constraint.getVersionRange();
        Query query = this.repository.createQuery("type", "bundle");
        boolean loosePackageVersionRange = false;
        if (packageVersionRange != null && packageVersionRange.getMaximum().equals((Object)packageVersionRange.getMinimum())) {
            HashMap<String, HashSet<String>> properties = new HashMap<String, HashSet<String>>();
            properties.put("version", new HashSet<String>(Arrays.asList(packageVersionRange.getMaximum().toString())));
            query.addFilter("Export-Package", constraint.getName(), properties);
        } else {
            query.addFilter("Export-Package", constraint.getName());
            loosePackageVersionRange = packageVersionRange != null;
        }
        String bundleSymbolicName = constraint.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            query.addFilter("Bundle-SymbolicName", bundleSymbolicName);
        }
        VersionRange bundleVersionRange = constraint.getBundleVersionRange();
        boolean looseBundleVersionRange = false;
        if (bundleVersionRange != null && bundleVersionRange.getMaximum().equals((Object)bundleVersionRange.getMinimum())) {
            query.addFilter("Bundle-Version", bundleVersionRange.getMaximum().toString());
        } else {
            looseBundleVersionRange = bundleVersionRange != null;
        }
        Set packageExportingArtefacts = query.run();
        for (ArtifactDescriptor packageExportingArtefact : packageExportingArtefacts) {
            if (loosePackageVersionRange && !this.packageVersionInRange(packageExportingArtefact, packageVersionRange, constraint.getName()) || looseBundleVersionRange && !this.bundleVersionInRange(packageExportingArtefact, bundleVersionRange)) continue;
            this.addBundle(packageExportingArtefact, state, constraintSatisfiers);
        }
    }

    private boolean packageVersionInRange(ArtifactDescriptor packageExportingArtefact, VersionRange packageVersionRange, String packageName) {
        for (Attribute attribute : packageExportingArtefact.getAttribute("Export-Package")) {
            Set versions;
            Version version;
            if (!attribute.getValue().equals(packageName) || !packageVersionRange.isIncluded(version = new Version((versions = (Set)attribute.getProperties().get("version")) == null || versions.isEmpty() ? "0" : (String)versions.iterator().next()))) continue;
            return true;
        }
        return false;
    }

    private boolean bundleVersionInRange(ArtifactDescriptor packageExportingArtefact, VersionRange bundleVersionRange) {
        return bundleVersionRange.isIncluded(packageExportingArtefact.getVersion());
    }

    private void addBundle(ArtifactDescriptor artefact, State state, List<BundleDescription> constraintSatisfiers) throws BundleException {
        if (!this.isBundlePresentInState(artefact.getName(), artefact.getVersion(), state)) {
            BundleDescription description = this.createBundleDescription(artefact, state);
            constraintSatisfiers.add(description);
        }
    }

    private boolean isBundlePresentInState(String bundleSymbolicName, Version version, State state) {
        BundleDescription[] bundleDescriptions;
        BundleDescription[] bundleDescriptionArray = bundleDescriptions = state.getBundles(bundleSymbolicName);
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription = bundleDescriptionArray[n2];
            if (bundleDescription.getVersion().equals((Object)version)) {
                long bundleId = bundleDescription.getBundleId();
                if (bundleId == 0L || this.coregion.contains(bundleId)) {
                    return true;
                }
                Set edges = this.coregion.getEdges();
                Iterator iterator = edges.iterator();
                if (iterator.hasNext()) {
                    RegionDigraph.FilteredRegion edge = (RegionDigraph.FilteredRegion)iterator.next();
                    Region userRegion = edge.getRegion();
                    RegionFilter filter = edge.getFilter();
                    if (filter.isAllowed((BundleRevision)bundleDescription) && userRegion.contains(bundleId)) {
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    private BundleDescription createBundleDescription(ArtifactDescriptor artifact, State state) throws BundleException {
        Dictionary manifest = BundleBridge.convertToDictionary((ArtifactDescriptor)artifact);
        try {
            URI uri = artifact.getUri();
            String installLocation = "file".equals(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
            BundleDescription bundleDescription = this.stateObjectFactory.createBundleDescription(state, manifest, String.valueOf(this.coregion.getName()) + REGION_LOCATION_DELIMITER + installLocation, this.nextBundleId.getAndIncrement());
            this.coregion.addBundle(bundleDescription.getBundleId());
            return bundleDescription;
        }
        catch (RuntimeException e) {
            throw new BundleException("Unable to read bundle at '" + artifact.getUri() + "'", (Throwable)e);
        }
        catch (BundleException be) {
            throw new BundleException("Failed to create BundleDescriptor for artifact at '" + artifact.getUri() + "'", (Throwable)be);
        }
    }

    private VersionConstraint[] findUnsatisfiedConstraints(BundleDescription[] bundles, State state) {
        return state.getStateHelper().getUnsatisfiedLeaves(bundles);
    }

    private void generateDump(State state) {
        HashMap<String, State> context = new HashMap<String, State>();
        context.put(RESOLUTION_STATE_KEY, state);
        this.dumpGenerator.generateDump("resolutionFailure", context, new Throwable[0]);
    }

    public long getNextBundleId() {
        return this.nextBundleId.getAndIncrement();
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.DependencyCalculator");
    }
}

