/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.formatting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.shell.internal.formatting.InstallArtifactCommandFormatter;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public abstract class AbstractInstallArtifactCommandFormatter<T extends ManageableArtifact>
implements InstallArtifactCommandFormatter<T> {
    protected static final int MAX_LINE_LENGTH = 80;
    private static final String NAME_COLUMN_NAME = "Name";
    private static final int NAME_COLUMN_MIN_WIDTH;
    private static final String VERSION_COLUMN_NAME = "Version";
    private static final int VERSION_COLUMN_MIN_WIDTH;
    private static final String STATE_COLUMN_NAME = "State";
    private static final int STATE_COLUMN_MIN_WIDTH = 11;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("AbstractInstallArtifactCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatList", "org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter", "java.util.List:", "artifacts:", "", "java.util.List"), 42);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter");
        NAME_COLUMN_MIN_WIDTH = NAME_COLUMN_NAME.length();
        VERSION_COLUMN_MIN_WIDTH = VERSION_COLUMN_NAME.length();
    }

    @Override
    public List<String> formatList(List<T> artifacts) {
        try {
            AbstractInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Collections.sort(artifacts, new ManageableArtifactComparator());
            int maxNameLength = NAME_COLUMN_MIN_WIDTH;
            int maxVersionLength = VERSION_COLUMN_MIN_WIDTH;
            for (ManageableArtifact artifact : artifacts) {
                int nameLength = artifact.getName().length();
                maxNameLength = nameLength > maxNameLength ? nameLength : maxNameLength;
                int versionLength = artifact.getVersion().length();
                int n = maxVersionLength = versionLength > maxVersionLength ? versionLength : maxVersionLength;
            }
            ArrayList<String> lines = new ArrayList<String>();
            int stateLength = 80 - (2 + maxNameLength + maxVersionLength);
            if (stateLength < 11) {
                stateLength = 11;
            }
            String singleLineFormat = String.format("%%-%ds %%-%ds %%%ds", maxNameLength, maxVersionLength, stateLength);
            lines.add(String.format(singleLineFormat, NAME_COLUMN_NAME, VERSION_COLUMN_NAME, STATE_COLUMN_NAME));
            for (ManageableArtifact artifact : artifacts) {
                lines.add(String.format(singleLineFormat, artifact.getName(), artifact.getVersion(), artifact.getState()));
            }
            ArrayList<String> arrayList = lines;
            AbstractInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static class ManageableArtifactComparator<T extends ManageableArtifact>
    implements Comparator<T> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ManageableArtifactComparator() {
        }

        @Override
        public int compare(T artifact1, T artifact2) {
            try {
                ManageableArtifactComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                int value = artifact1.getName().compareTo(artifact2.getName());
                int n = value != 0 ? value : artifact1.getVersion().compareTo(artifact2.getVersion());
                ManageableArtifactComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                ManageableArtifactComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("AbstractInstallArtifactCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter$ManageableArtifactComparator"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter$ManageableArtifactComparator", "org.eclipse.virgo.kernel.model.management.ManageableArtifact:org.eclipse.virgo.kernel.model.management.ManageableArtifact:", "artifact1:artifact2:", "", "int"), 71);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter$ManageableArtifactComparator");
        }
    }
}

