/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;

public final class RegionBundleEventHook
implements EventHook {
    private final RegionDigraph regionDigraph;
    private final FindHook bundleFindHook;
    private final ThreadLocal<Region> threadLocal;

    public RegionBundleEventHook(RegionDigraph regionDigraph, FindHook bundleFindBook, ThreadLocal<Region> threadLocal) {
        this.regionDigraph = regionDigraph;
        this.bundleFindHook = bundleFindBook;
        this.threadLocal = threadLocal;
    }

    public void event(BundleEvent event, Collection<BundleContext> contexts) {
        Bundle eventBundle = event.getBundle();
        if (event.getType() == 1) {
            this.bundleInstalled(eventBundle, event.getOrigin());
        }
        Iterator<BundleContext> i = contexts.iterator();
        while (i.hasNext()) {
            if (this.find(i.next(), eventBundle)) continue;
            i.remove();
        }
        if (event.getType() == 16) {
            this.bundleUninstalled(eventBundle);
        }
    }

    private boolean find(BundleContext finderBundleContext, Bundle candidateBundle) {
        ArrayList<Bundle> candidates = new ArrayList<Bundle>(1);
        candidates.add(candidateBundle);
        this.bundleFindHook.find(finderBundleContext, candidates);
        return !candidates.isEmpty();
    }

    private void bundleInstalled(Bundle eventBundle, Bundle originBundle) {
        Region installRegion = this.threadLocal.get();
        if (installRegion != null) {
            try {
                installRegion.addBundle(eventBundle);
            }
            catch (BundleException e) {
                e.printStackTrace();
                throw new RuntimeException("Bundle could not be added to region", e);
            }
        }
        Region originRegion = this.regionDigraph.getRegion(originBundle);
        if (originRegion != null) {
            try {
                originRegion.addBundle(eventBundle);
            }
            catch (BundleException e) {
                e.printStackTrace();
                throw new RuntimeException("Bundle could not be added to region", e);
            }
        }
    }

    private void bundleUninstalled(Bundle eventBundle) {
        Region region = this.regionDigraph.getRegion(eventBundle);
        if (region != null) {
            region.removeBundle(eventBundle);
        }
    }
}

