/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;

public class BoundedReferenceType
extends ReferenceType {
    private ResolvedType lowerBound;
    private ResolvedType upperBound;
    protected ReferenceType[] additionalInterfaceBounds = new ReferenceType[0];
    protected boolean isExtends = true;
    protected boolean isSuper = false;

    public UnresolvedType getUpperBound() {
        return this.upperBound;
    }

    public UnresolvedType getLowerBound() {
        return this.lowerBound;
    }

    public BoundedReferenceType(ReferenceType aBound, boolean isExtends, World world) {
        super((isExtends ? "+" : "-") + aBound.signature, aBound.signatureErasure, world);
        this.isExtends = isExtends;
        boolean bl = this.isSuper = !isExtends;
        if (isExtends) {
            this.upperBound = aBound;
        } else {
            this.lowerBound = aBound;
            this.upperBound = world.resolve(UnresolvedType.OBJECT);
        }
        this.setDelegate(new ReferenceTypeReferenceTypeDelegate((ReferenceType)this.getUpperBound()));
    }

    public BoundedReferenceType(ReferenceType aBound, boolean isExtends, World world, ReferenceType[] additionalInterfaces) {
        this(aBound, isExtends, world);
        this.additionalInterfaceBounds = additionalInterfaces;
    }

    public ReferenceType[] getAdditionalBounds() {
        return this.additionalInterfaceBounds;
    }

    public UnresolvedType parameterize(Map typeBindings) {
        ReferenceType[] parameterizedAdditionalInterfaces = new ReferenceType[this.additionalInterfaceBounds == null ? 0 : this.additionalInterfaceBounds.length];
        for (int i = 0; i < parameterizedAdditionalInterfaces.length; ++i) {
            parameterizedAdditionalInterfaces[i] = (ReferenceType)this.additionalInterfaceBounds[i].parameterize(typeBindings);
        }
        if (this.isExtends) {
            return new BoundedReferenceType((ReferenceType)this.getUpperBound().parameterize(typeBindings), this.isExtends, this.world, parameterizedAdditionalInterfaces);
        }
        return new BoundedReferenceType((ReferenceType)this.getLowerBound().parameterize(typeBindings), this.isExtends, this.world, parameterizedAdditionalInterfaces);
    }

    protected BoundedReferenceType(String sig, String sigErasure, World world) {
        super(sig, sigErasure, world);
        this.upperBound = world.resolve(UnresolvedType.OBJECT);
        this.setDelegate(new ReferenceTypeReferenceTypeDelegate((ReferenceType)this.getUpperBound()));
    }

    public ReferenceType[] getInterfaceBounds() {
        return this.additionalInterfaceBounds;
    }

    public boolean hasLowerBound() {
        return this.getLowerBound() != null;
    }

    public boolean isExtends() {
        return this.isExtends && !this.getUpperBound().getSignature().equals("Ljava/lang/Object;");
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean alwaysMatches(ResolvedType aCandidateType) {
        if (this.isExtends()) {
            return ((ReferenceType)this.getUpperBound()).isAssignableFrom(aCandidateType);
        }
        if (this.isSuper()) {
            return aCandidateType.isAssignableFrom((ReferenceType)this.getLowerBound());
        }
        return true;
    }

    public boolean canBeCoercedTo(ResolvedType aCandidateType) {
        if (this.alwaysMatches(aCandidateType)) {
            return true;
        }
        if (aCandidateType.isGenericWildcard()) {
            BoundedReferenceType boundedRT = (BoundedReferenceType)aCandidateType;
            ResolvedType myUpperBound = (ResolvedType)this.getUpperBound();
            ResolvedType myLowerBound = (ResolvedType)this.getLowerBound();
            if (this.isExtends()) {
                if (boundedRT.isExtends()) {
                    return myUpperBound.isAssignableFrom((ResolvedType)boundedRT.getUpperBound());
                }
                if (boundedRT.isSuper()) {
                    return myUpperBound == boundedRT.getLowerBound();
                }
                return true;
            }
            if (this.isSuper()) {
                if (boundedRT.isSuper()) {
                    return ((ResolvedType)boundedRT.getLowerBound()).isAssignableFrom(myLowerBound);
                }
                if (boundedRT.isExtends()) {
                    return myLowerBound == boundedRT.getUpperBound();
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public String getSimpleName() {
        if (!this.isExtends() && !this.isSuper()) {
            return "?";
        }
        if (this.isExtends()) {
            return "? extends " + this.getUpperBound().getSimpleName();
        }
        return "? super " + this.getLowerBound().getSimpleName();
    }

    public ResolvedType[] getDeclaredInterfaces() {
        ResolvedType[] interfaces = super.getDeclaredInterfaces();
        if (this.additionalInterfaceBounds.length > 0) {
            ResolvedType[] allInterfaces = new ResolvedType[interfaces.length + this.additionalInterfaceBounds.length];
            System.arraycopy(interfaces, 0, allInterfaces, 0, interfaces.length);
            System.arraycopy(this.additionalInterfaceBounds, 0, allInterfaces, interfaces.length, this.additionalInterfaceBounds.length);
            return allInterfaces;
        }
        return interfaces;
    }

    public boolean isGenericWildcard() {
        return true;
    }

    protected static class ReferenceTypeReferenceTypeDelegate
    extends AbstractReferenceTypeDelegate {
        public ReferenceTypeReferenceTypeDelegate(ReferenceType backing) {
            super(backing, false);
        }

        public boolean isAspect() {
            return this.resolvedTypeX.isAspect();
        }

        public boolean isAnnotationStyleAspect() {
            return this.resolvedTypeX.isAnnotationStyleAspect();
        }

        public boolean isInterface() {
            return this.resolvedTypeX.isInterface();
        }

        public boolean isEnum() {
            return this.resolvedTypeX.isEnum();
        }

        public boolean isAnnotation() {
            return this.resolvedTypeX.isAnnotation();
        }

        public boolean isAnnotationWithRuntimeRetention() {
            return this.resolvedTypeX.isAnnotationWithRuntimeRetention();
        }

        public boolean isAnonymous() {
            return this.resolvedTypeX.isAnonymous();
        }

        public boolean isNested() {
            return this.resolvedTypeX.isNested();
        }

        public ResolvedType getOuterClass() {
            return this.resolvedTypeX.getOuterClass();
        }

        public String getRetentionPolicy() {
            return this.resolvedTypeX.getRetentionPolicy();
        }

        public boolean canAnnotationTargetType() {
            return this.resolvedTypeX.canAnnotationTargetType();
        }

        public AnnotationTargetKind[] getAnnotationTargetKinds() {
            return this.resolvedTypeX.getAnnotationTargetKinds();
        }

        public boolean isGeneric() {
            return this.resolvedTypeX.isGenericType();
        }

        public String getDeclaredGenericSignature() {
            return this.resolvedTypeX.getDeclaredGenericSignature();
        }

        public boolean hasAnnotation(UnresolvedType ofType) {
            return this.resolvedTypeX.hasAnnotation(ofType);
        }

        public AnnotationAJ[] getAnnotations() {
            return this.resolvedTypeX.getAnnotations();
        }

        public ResolvedType[] getAnnotationTypes() {
            return this.resolvedTypeX.getAnnotationTypes();
        }

        public ResolvedMember[] getDeclaredFields() {
            return this.resolvedTypeX.getDeclaredFields();
        }

        public ResolvedType[] getDeclaredInterfaces() {
            return this.resolvedTypeX.getDeclaredInterfaces();
        }

        public ResolvedMember[] getDeclaredMethods() {
            return this.resolvedTypeX.getDeclaredMethods();
        }

        public ResolvedMember[] getDeclaredPointcuts() {
            return this.resolvedTypeX.getDeclaredPointcuts();
        }

        public PerClause getPerClause() {
            return this.resolvedTypeX.getPerClause();
        }

        public Collection getDeclares() {
            return this.resolvedTypeX.getDeclares();
        }

        public Collection getTypeMungers() {
            return this.resolvedTypeX.getTypeMungers();
        }

        public Collection getPrivilegedAccesses() {
            return Collections.EMPTY_LIST;
        }

        public int getModifiers() {
            return this.resolvedTypeX.getModifiers();
        }

        public ResolvedType getSuperclass() {
            return this.resolvedTypeX.getSuperclass();
        }

        public WeaverStateInfo getWeaverState() {
            return null;
        }

        public TypeVariable[] getTypeVariables() {
            return this.resolvedTypeX.getTypeVariables();
        }
    }
}

