/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing.cache.artifact;

import java.io.File;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.cacheing.CacheingArtifactDescriptor;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.SingleArtifactCache;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.SingleArtifactCacheFactory;
import org.eclipse.virgo.repository.internal.cacheing.cache.artifact.StandardSingleArtifactCache;
import org.osgi.framework.Version;

public class StandardSingleArtifactCacheFactory
implements SingleArtifactCacheFactory {
    private static final String CACHE_NAME_SEPARATOR = ":";
    private final ConcurrentMap<String, SingleArtifactCache> artifactCaches = new ConcurrentHashMap<String, SingleArtifactCache>();

    @Override
    public SingleArtifactCache getArtifactCache(RepositoryAwareArtifactDescriptor artifactDescriptor, File repositoryCacheDirectory) {
        URI remoteUri = this.getRemoteURI(artifactDescriptor);
        return this.getArtifactCache(artifactDescriptor.getRepositoryName(), artifactDescriptor.getType(), artifactDescriptor.getName(), artifactDescriptor.getVersion(), remoteUri, artifactDescriptor.getFilename(), repositoryCacheDirectory);
    }

    private URI getRemoteURI(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        URI remoteUri;
        if (artifactDescriptor instanceof CacheingArtifactDescriptor) {
            CacheingArtifactDescriptor cacheingArtifactDescriptor = (CacheingArtifactDescriptor)artifactDescriptor;
            remoteUri = cacheingArtifactDescriptor.getRemoteUri();
        } else {
            remoteUri = artifactDescriptor.getUri();
        }
        return remoteUri;
    }

    private SingleArtifactCache getArtifactCache(String repositoryName, String type, String name, Version version, URI uri, String fileName, File repositoryCacheDirectory) {
        String cacheName = this.getCacheName(repositoryName, uri);
        SingleArtifactCache cache = (SingleArtifactCache)this.artifactCaches.get(cacheName);
        if (cache == null) {
            this.artifactCaches.putIfAbsent(cacheName, new StandardSingleArtifactCache(type, name, version, uri, fileName, repositoryCacheDirectory));
            cache = (SingleArtifactCache)this.artifactCaches.get(cacheName);
        }
        return cache;
    }

    private String getCacheName(String repositoryName, URI uri) {
        return String.valueOf(repositoryName) + CACHE_NAME_SEPARATOR + uri.toString();
    }
}

