/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.management.console.internal.GZIPResponseStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String HTTP_CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String HTTP_LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String HTTP_EXPIRES_HEADER = "Expires";
    private static final String HTTP_CACHE_CONTROL_HEADER = "Cache-Control";
    private static final Logger log = LoggerFactory.getLogger(ResourceServlet.class);
    private final String protectedPath = "/?WEB-INF/.*";
    private String jarPathPrefix = "META-INF";
    private boolean gzipEnabled = true;
    private int cacheTimeout = 31556926;
    private Set<String> allowedResourcePaths = new HashSet();
    private Map<String, String> defaultMimeTypes;
    private Set<String> compressedMimeTypes;

    public ResourceServlet() {
        this.allowedResourcePaths.add("/.*/.*css");
        this.allowedResourcePaths.add("/.*/.*gif");
        this.allowedResourcePaths.add("/.*/.*ico");
        this.allowedResourcePaths.add("/.*/.*jpeg");
        this.allowedResourcePaths.add("/.*/.*jpg");
        this.allowedResourcePaths.add("/.*/.*js");
        this.allowedResourcePaths.add("/.*/.*png");
        this.allowedResourcePaths.add("META-INF/.*/*css");
        this.allowedResourcePaths.add("META-INF/.*/*gif");
        this.allowedResourcePaths.add("META-INF/.*/*ico");
        this.allowedResourcePaths.add("META-INF/.*/*jpeg");
        this.allowedResourcePaths.add("META-INF/.*/*jpg");
        this.allowedResourcePaths.add("META-INF/.*/*js");
        this.allowedResourcePaths.add("META-INF/.*/*png");
        this.defaultMimeTypes = new HashMap();
        this.defaultMimeTypes.put(".css", "text/css");
        this.defaultMimeTypes.put(".gif", "image/gif");
        this.defaultMimeTypes.put(".ico", "image/vnd.microsoft.icon");
        this.defaultMimeTypes.put(".jpeg", "image/jpeg");
        this.defaultMimeTypes.put(".jpg", "image/jpeg");
        this.defaultMimeTypes.put(".js", "text/javascript");
        this.defaultMimeTypes.put(".png", "image/png");
        this.compressedMimeTypes = new HashSet();
        this.compressedMimeTypes.add("text/.*");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL[] resources;
        String rawRequestPath = request.getPathInfo();
        if (log.isDebugEnabled()) {
            log.debug("Attempting to GET resource: " + rawRequestPath);
        }
        if ((resources = this.getRequestResourceURLs(request)) == null || resources.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Resource not found: " + rawRequestPath);
            }
            response.sendError(404);
            return;
        }
        this.prepareResourcesResponse(response, resources, rawRequestPath);
        OutputStream out = this.selectOutputStream(request, response, resources, rawRequestPath);
        try {
            int i = 0;
            while (i < resources.length) {
                URLConnection resourceConn = resources[i].openConnection();
                InputStream in = resourceConn.getInputStream();
                try {
                    byte[] buffer = new byte[1024];
                    int bytesRead = -1;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    in.close();
                }
                ++i;
            }
        }
        finally {
            out.close();
        }
    }

    private OutputStream selectOutputStream(HttpServletRequest request, HttpServletResponse response, URL[] resources, String rawResourcePath) throws IOException {
        String mimeType;
        String acceptEncoding = request.getHeader("Accept-Encoding");
        try {
            mimeType = response.getContentType();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            mimeType = this.getResponseMimeType(resources, rawResourcePath);
        }
        if (this.gzipEnabled && acceptEncoding != null && acceptEncoding.indexOf("gzip") > -1 && this.matchesCompressedMimeTypes(mimeType)) {
            log.debug("Enabling GZIP compression for the current response.");
            return new GZIPResponseStream(response);
        }
        return response.getOutputStream();
    }

    private boolean matchesCompressedMimeTypes(String mimeType) {
        for (String compressedMimeType : this.compressedMimeTypes) {
            if (!mimeType.matches(compressedMimeType)) continue;
            return true;
        }
        return false;
    }

    private void prepareResourcesResponse(HttpServletResponse response, URL[] resources, String rawResourcePath) throws IOException {
        long lastModified = -1L;
        int contentLength = 0;
        String mimeType = null;
        int i = 0;
        while (i < resources.length) {
            URLConnection resourceConn = resources[i].openConnection();
            if (resourceConn.getLastModified() > lastModified) {
                lastModified = resourceConn.getLastModified();
            }
            mimeType = this.getMimeType(rawResourcePath, resources[i], mimeType);
            contentLength += resourceConn.getContentLength();
            ++i;
        }
        response.setContentType(mimeType);
        response.setHeader("Content-Length", Long.toString(contentLength));
        response.setDateHeader("Last-Modified", lastModified);
        if (this.cacheTimeout > 0) {
            this.configureCaching(response, this.cacheTimeout);
        }
    }

    private String getResponseMimeType(URL[] resources, String rawResourcePath) throws IOException {
        String mimeType = null;
        int i = 0;
        while (i < resources.length) {
            mimeType = this.getMimeType(rawResourcePath, resources[i], mimeType);
            ++i;
        }
        return mimeType;
    }

    private String getMimeType(String rawResourcePath, URL resource, String expectedMimeType) throws MalformedURLException {
        String extension = resource.getPath().substring(resource.getPath().lastIndexOf(46));
        String currentMimeType = (String)this.defaultMimeTypes.get(extension);
        if (currentMimeType == null) {
            currentMimeType = this.getServletContext().getMimeType(resource.getPath());
        }
        if (expectedMimeType == null) {
            expectedMimeType = currentMimeType;
        } else if (!expectedMimeType.equals(currentMimeType)) {
            throw new MalformedURLException("Combined resource path: " + rawResourcePath + " is invalid. All resources in a combined resource path must be of the same mime type.");
        }
        return expectedMimeType;
    }

    protected long getLastModified(HttpServletRequest request) {
        URL[] resources;
        if (log.isDebugEnabled()) {
            log.debug("Checking last modified of resource: " + request.getPathInfo());
        }
        try {
            resources = this.getRequestResourceURLs(request);
        }
        catch (MalformedURLException malformedURLException) {
            return -1L;
        }
        if (resources == null || resources.length == 0) {
            return -1L;
        }
        long lastModified = -1L;
        int i = 0;
        while (i < resources.length) {
            URLConnection resourceConn;
            try {
                resourceConn = resources[i].openConnection();
            }
            catch (IOException iOException) {
                return -1L;
            }
            if (resourceConn.getLastModified() > lastModified) {
                lastModified = resourceConn.getLastModified();
            }
            ++i;
        }
        return lastModified;
    }

    private URL[] getRequestResourceURLs(HttpServletRequest request) throws MalformedURLException {
        String rawResourcePath = request.getPathInfo();
        String appendedPaths = request.getParameter("appended");
        if (appendedPaths != null && appendedPaths.length() < 0) {
            rawResourcePath = String.valueOf(rawResourcePath) + "," + appendedPaths;
        }
        String[] localResourcePaths = this.delimitedListToStringArray(rawResourcePath, ",");
        URL[] resources = new URL[localResourcePaths.length];
        int i = 0;
        while (i < localResourcePaths.length) {
            String localResourcePath = localResourcePaths[i];
            if (!this.isAllowed(localResourcePath)) {
                if (log.isWarnEnabled()) {
                    log.warn("An attempt to access a protected resource at " + localResourcePath + " was disallowed.");
                }
                return null;
            }
            URL resource = this.getServletContext().getResource(localResourcePath);
            if (resource == null) {
                resource = this.getJarResource(this.jarPathPrefix, localResourcePath);
            }
            if (resource == null) {
                if (resources.length > 1) {
                    log.debug("Combined resource not found: " + localResourcePath);
                }
                return null;
            }
            resources[i] = resource;
            ++i;
        }
        return resources;
    }

    private URL getJarResource(String jarPrefix, String resourcePath) {
        String jarResourcePath = String.valueOf(jarPrefix) + resourcePath;
        if (!this.isAllowed(jarResourcePath)) {
            if (log.isWarnEnabled()) {
                log.warn("An attempt to access a protected resource at " + jarResourcePath + " was disallowed.");
            }
            return null;
        }
        if (jarResourcePath.startsWith("/")) {
            jarResourcePath = jarResourcePath.substring(1);
        }
        if (log.isDebugEnabled()) {
            log.debug("Searching classpath for resource: " + jarResourcePath);
        }
        return ResourceServlet.getDefaultClassLoader().getResource(jarResourcePath);
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {}
        if (cl == null) {
            cl = ResourceServlet.class.getClassLoader();
        }
        return cl;
    }

    private boolean isAllowed(String resourcePath) {
        if (resourcePath.matches("/?WEB-INF/.*")) {
            return false;
        }
        for (String allowedResourcePath : this.allowedResourcePaths) {
            if (!resourcePath.matches(allowedResourcePath)) continue;
            return true;
        }
        return false;
    }

    private void configureCaching(HttpServletResponse response, int seconds) {
        response.setDateHeader("Expires", System.currentTimeMillis() + (long)seconds * 1000L);
        response.setHeader("Cache-Control", "max-age=" + seconds);
    }

    private String[] delimitedListToStringArray(String str, String delimiter) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            int i = 0;
            while (i < str.length()) {
                result.add(str.substring(i, i + 1));
                ++i;
            }
        } else {
            int pos = 0;
            int delPos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(str.substring(pos, delPos));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(str.substring(pos));
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

