/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

public class Tokenizer {
    private char[] value;
    private int max;
    private int cursor;

    public Tokenizer(String value) {
        this.value = value.toCharArray();
        this.max = this.value.length;
        this.cursor = 0;
    }

    public char getChar() {
        int cur = this.cursor;
        if (cur < this.max) {
            this.cursor = cur + 1;
            return this.value[cur];
        }
        return '\u0000';
    }

    public String getString(String terminals) {
        this.skipWhiteSpace();
        char[] val = this.value;
        int cur = this.cursor;
        if (cur < this.max) {
            if (val[cur] == '\"') {
                char c = '\u0000';
                int begin = ++cur;
                while (cur < this.max) {
                    c = val[cur];
                    if (c == '\"') break;
                    ++cur;
                }
                int count = cur - begin;
                if (c == '\"') {
                    ++cur;
                }
                this.cursor = cur;
                if (count > 0) {
                    this.skipWhiteSpace();
                    return new String(val, begin, count);
                }
            } else {
                int begin = cur;
                while (cur < this.max) {
                    char c = val[cur];
                    if (c == ' ' || c == '\t' || terminals.indexOf(c) != -1) break;
                    ++cur;
                }
                this.cursor = cur;
                int count = cur - begin;
                if (count > 0) {
                    this.skipWhiteSpace();
                    return new String(val, begin, count);
                }
            }
        }
        return null;
    }

    public String getToken(String terminals) {
        int cur;
        this.skipWhiteSpace();
        char[] val = this.value;
        int begin = cur = this.cursor;
        while (cur < this.max) {
            char c = val[cur];
            if (c == ' ' || c == '\t' || terminals.indexOf(c) != -1) break;
            ++cur;
        }
        this.cursor = cur;
        int count = cur - begin;
        if (count > 0) {
            this.skipWhiteSpace();
            return new String(val, begin, count);
        }
        return null;
    }

    private void skipWhiteSpace() {
        char[] val = this.value;
        int cur = this.cursor;
        while (cur < this.max) {
            char c = val[cur];
            if (c != ' ' && c != '\t') break;
            ++cur;
        }
        this.cursor = cur;
    }
}

